/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.hash.HashContainerFactory;
import net.openhft.collect.hash.IntHashFactory;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ImmutableLHashSeparateKVIntShortMapGO;
import net.openhft.collect.impl.hash.LHashCapacities;
import net.openhft.collect.impl.hash.LHashSeparateKVIntShortMapFactorySO;
import net.openhft.collect.impl.hash.MutableLHashSeparateKVIntShortMapGO;
import net.openhft.collect.impl.hash.SeparateKVIntShortLHash;
import net.openhft.collect.impl.hash.UpdatableLHashSeparateKVIntShortMapGO;
import net.openhft.collect.map.hash.HashIntShortMap;
import net.openhft.collect.map.hash.HashIntShortMapFactory;
import net.openhft.function.Consumer;
import net.openhft.function.IntShortConsumer;
import net.openhft.function.Predicate;

public abstract class LHashSeparateKVIntShortMapFactoryGO
extends LHashSeparateKVIntShortMapFactorySO {
    LHashSeparateKVIntShortMapFactoryGO(HashConfig hashConf, int defaultExpectedSize, int lower, int upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    abstract HashIntShortMapFactory thisWith(HashConfig var1, int var2, int var3, int var4);

    abstract HashIntShortMapFactory lHashLikeThisWith(HashConfig var1, int var2, int var3, int var4);

    abstract HashIntShortMapFactory qHashLikeThisWith(HashConfig var1, int var2, int var3, int var4);

    public final HashIntShortMapFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash(hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public final HashIntShortMapFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize, this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    final HashIntShortMapFactory withDomain(int lower, int upper) {
        if (lower == this.getLowerKeyDomainBound() && upper == this.getUpperKeyDomainBound()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), this.getDefaultExpectedSize(), lower, upper);
    }

    public final HashIntShortMapFactory withKeysDomain(int lower, int upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minPossibleKey shouldn't be greater than maxPossibleKey");
        }
        return this.withDomain(lower, upper);
    }

    public final HashIntShortMapFactory withKeysDomainComplement(int lower, int upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minImpossibleKey shouldn't be greater than maxImpossibleKey");
        }
        return this.withDomain(upper + 1, lower - 1);
    }

    public String toString() {
        return "HashIntShortMapFactory[" + this.commonString() + this.keySpecialString() + ",defaultValue=" + this.getDefaultValue() + "]";
    }

    public int hashCode() {
        int hashCode = this.keySpecialHashCode(this.commonHashCode());
        hashCode = hashCode * 31 + Primitives.hashCode(this.getDefaultValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashIntShortMapFactory) {
            HashIntShortMapFactory factory = (HashIntShortMapFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals((IntHashFactory)factory) && Short.valueOf(this.getDefaultValue()).equals(factory.getDefaultValue());
        }
        return false;
    }

    public short getDefaultValue() {
        return 0;
    }

    private UpdatableLHashSeparateKVIntShortMapGO shrunk(UpdatableLHashSeparateKVIntShortMapGO map) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(map)) {
            map.shrink();
        }
        return map;
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMap() {
        return this.newUpdatableMap(this.getDefaultExpectedSize());
    }

    public MutableLHashSeparateKVIntShortMapGO newMutableMap() {
        return this.newMutableMap(this.getDefaultExpectedSize());
    }

    @Override
    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMap(Map<Integer, Short> map) {
        return this.shrunk((UpdatableLHashSeparateKVIntShortMapGO)super.newUpdatableMap((Map)map));
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMap(Map<Integer, Short> map1, Map<Integer, Short> map2) {
        long expectedSize = map1.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, Containers.sizeAsInt(expectedSize += (long)map2.size()));
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMap(Map<Integer, Short> map1, Map<Integer, Short> map2, Map<Integer, Short> map3) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, Containers.sizeAsInt(expectedSize += (long)map3.size()));
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMap(Map<Integer, Short> map1, Map<Integer, Short> map2, Map<Integer, Short> map3, Map<Integer, Short> map4) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, Containers.sizeAsInt(expectedSize += (long)map4.size()));
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMap(Map<Integer, Short> map1, Map<Integer, Short> map2, Map<Integer, Short> map3, Map<Integer, Short> map4, Map<Integer, Short> map5) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        expectedSize += (long)map4.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, Containers.sizeAsInt(expectedSize += (long)map5.size()));
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMap(Map<Integer, Short> map1, Map<Integer, Short> map2, int expectedSize) {
        UpdatableLHashSeparateKVIntShortMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Integer, ? extends Short>)map1);
        map.putAll((Map<? extends Integer, ? extends Short>)map2);
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMap(Map<Integer, Short> map1, Map<Integer, Short> map2, Map<Integer, Short> map3, int expectedSize) {
        UpdatableLHashSeparateKVIntShortMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Integer, ? extends Short>)map1);
        map.putAll((Map<? extends Integer, ? extends Short>)map2);
        map.putAll((Map<? extends Integer, ? extends Short>)map3);
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMap(Map<Integer, Short> map1, Map<Integer, Short> map2, Map<Integer, Short> map3, Map<Integer, Short> map4, int expectedSize) {
        UpdatableLHashSeparateKVIntShortMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Integer, ? extends Short>)map1);
        map.putAll((Map<? extends Integer, ? extends Short>)map2);
        map.putAll((Map<? extends Integer, ? extends Short>)map3);
        map.putAll((Map<? extends Integer, ? extends Short>)map4);
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMap(Map<Integer, Short> map1, Map<Integer, Short> map2, Map<Integer, Short> map3, Map<Integer, Short> map4, Map<Integer, Short> map5, int expectedSize) {
        UpdatableLHashSeparateKVIntShortMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Integer, ? extends Short>)map1);
        map.putAll((Map<? extends Integer, ? extends Short>)map2);
        map.putAll((Map<? extends Integer, ? extends Short>)map3);
        map.putAll((Map<? extends Integer, ? extends Short>)map4);
        map.putAll((Map<? extends Integer, ? extends Short>)map5);
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMap(Consumer<IntShortConsumer> entriesSupplier) {
        return this.newUpdatableMap((Consumer)entriesSupplier, this.getDefaultExpectedSize());
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMap(Consumer<IntShortConsumer> entriesSupplier, int expectedSize) {
        final UpdatableLHashSeparateKVIntShortMapGO map = this.newUpdatableMap(expectedSize);
        entriesSupplier.accept((Object)new IntShortConsumer(){

            public void accept(int k, short v) {
                map.put(k, v);
            }
        });
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMap(int[] keys, short[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMap(int[] keys, short[] values, int expectedSize) {
        UpdatableLHashSeparateKVIntShortMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMap(Integer[] keys, Short[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMap(Integer[] keys, Short[] values, int expectedSize) {
        UpdatableLHashSeparateKVIntShortMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMap(Iterable<Integer> keys, Iterable<Short> values) {
        int expectedSize = keys instanceof Collection ? ((Collection)keys).size() : this.getDefaultExpectedSize();
        return this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize);
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMap(Iterable<Integer> keys, Iterable<Short> values, int expectedSize) {
        UpdatableLHashSeparateKVIntShortMapGO map = this.newUpdatableMap(expectedSize);
        Iterator<Integer> keysIt = keys.iterator();
        Iterator<Short> valuesIt = values.iterator();
        try {
            while (keysIt.hasNext()) {
                map.put(keysIt.next(), valuesIt.next());
            }
            return this.shrunk(map);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("keys and values iterables must have the same size", e);
        }
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMapOf(int k1, short v1) {
        UpdatableLHashSeparateKVIntShortMapGO map = this.newUpdatableMap(1);
        map.put(k1, v1);
        return map;
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMapOf(int k1, short v1, int k2, short v2) {
        UpdatableLHashSeparateKVIntShortMapGO map = this.newUpdatableMap(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMapOf(int k1, short v1, int k2, short v2, int k3, short v3) {
        UpdatableLHashSeparateKVIntShortMapGO map = this.newUpdatableMap(3);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMapOf(int k1, short v1, int k2, short v2, int k3, short v3, int k4, short v4) {
        UpdatableLHashSeparateKVIntShortMapGO map = this.newUpdatableMap(4);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public UpdatableLHashSeparateKVIntShortMapGO newUpdatableMapOf(int k1, short v1, int k2, short v2, int k3, short v3, int k4, short v4, int k5, short v5) {
        UpdatableLHashSeparateKVIntShortMapGO map = this.newUpdatableMap(5);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public HashIntShortMap newMutableMap(Map<Integer, Short> map1, Map<Integer, Short> map2, int expectedSize) {
        MutableLHashSeparateKVIntShortMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntShortLHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashIntShortMap newMutableMap(Map<Integer, Short> map1, Map<Integer, Short> map2, Map<Integer, Short> map3, int expectedSize) {
        MutableLHashSeparateKVIntShortMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntShortLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashIntShortMap newMutableMap(Map<Integer, Short> map1, Map<Integer, Short> map2, Map<Integer, Short> map3, Map<Integer, Short> map4, int expectedSize) {
        MutableLHashSeparateKVIntShortMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntShortLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashIntShortMap newMutableMap(Map<Integer, Short> map1, Map<Integer, Short> map2, Map<Integer, Short> map3, Map<Integer, Short> map4, Map<Integer, Short> map5, int expectedSize) {
        MutableLHashSeparateKVIntShortMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntShortLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashIntShortMap newMutableMap(Map<Integer, Short> map) {
        MutableLHashSeparateKVIntShortMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntShortLHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashIntShortMap newMutableMap(Map<Integer, Short> map1, Map<Integer, Short> map2) {
        MutableLHashSeparateKVIntShortMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntShortLHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashIntShortMap newMutableMap(Map<Integer, Short> map1, Map<Integer, Short> map2, Map<Integer, Short> map3) {
        MutableLHashSeparateKVIntShortMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntShortLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashIntShortMap newMutableMap(Map<Integer, Short> map1, Map<Integer, Short> map2, Map<Integer, Short> map3, Map<Integer, Short> map4) {
        MutableLHashSeparateKVIntShortMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntShortLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashIntShortMap newMutableMap(Map<Integer, Short> map1, Map<Integer, Short> map2, Map<Integer, Short> map3, Map<Integer, Short> map4, Map<Integer, Short> map5) {
        MutableLHashSeparateKVIntShortMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntShortLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashIntShortMap newMutableMap(Consumer<IntShortConsumer> entriesSupplier) {
        MutableLHashSeparateKVIntShortMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVIntShortLHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashIntShortMap newMutableMap(Consumer<IntShortConsumer> entriesSupplier, int expectedSize) {
        MutableLHashSeparateKVIntShortMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVIntShortLHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashIntShortMap newMutableMap(int[] keys, short[] values) {
        MutableLHashSeparateKVIntShortMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashIntShortMap newMutableMap(int[] keys, short[] values, int expectedSize) {
        MutableLHashSeparateKVIntShortMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashIntShortMap newMutableMap(Integer[] keys, Short[] values) {
        MutableLHashSeparateKVIntShortMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashIntShortMap newMutableMap(Integer[] keys, Short[] values, int expectedSize) {
        MutableLHashSeparateKVIntShortMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashIntShortMap newMutableMap(Iterable<Integer> keys, Iterable<Short> values) {
        MutableLHashSeparateKVIntShortMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVIntShortLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashIntShortMap newMutableMap(Iterable<Integer> keys, Iterable<Short> values, int expectedSize) {
        MutableLHashSeparateKVIntShortMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVIntShortLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashIntShortMap newMutableMapOf(int k1, short v1) {
        MutableLHashSeparateKVIntShortMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashIntShortMap newMutableMapOf(int k1, short v1, int k2, short v2) {
        MutableLHashSeparateKVIntShortMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashIntShortMap newMutableMapOf(int k1, short v1, int k2, short v2, int k3, short v3) {
        MutableLHashSeparateKVIntShortMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashIntShortMap newMutableMapOf(int k1, short v1, int k2, short v2, int k3, short v3, int k4, short v4) {
        MutableLHashSeparateKVIntShortMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashIntShortMap newMutableMapOf(int k1, short v1, int k2, short v2, int k3, short v3, int k4, short v4, int k5, short v5) {
        MutableLHashSeparateKVIntShortMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }

    public HashIntShortMap newImmutableMap(Map<Integer, Short> map1, Map<Integer, Short> map2, int expectedSize) {
        ImmutableLHashSeparateKVIntShortMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntShortLHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashIntShortMap newImmutableMap(Map<Integer, Short> map1, Map<Integer, Short> map2, Map<Integer, Short> map3, int expectedSize) {
        ImmutableLHashSeparateKVIntShortMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntShortLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashIntShortMap newImmutableMap(Map<Integer, Short> map1, Map<Integer, Short> map2, Map<Integer, Short> map3, Map<Integer, Short> map4, int expectedSize) {
        ImmutableLHashSeparateKVIntShortMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntShortLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashIntShortMap newImmutableMap(Map<Integer, Short> map1, Map<Integer, Short> map2, Map<Integer, Short> map3, Map<Integer, Short> map4, Map<Integer, Short> map5, int expectedSize) {
        ImmutableLHashSeparateKVIntShortMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntShortLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashIntShortMap newImmutableMap(Map<Integer, Short> map) {
        ImmutableLHashSeparateKVIntShortMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntShortLHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashIntShortMap newImmutableMap(Map<Integer, Short> map1, Map<Integer, Short> map2) {
        ImmutableLHashSeparateKVIntShortMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntShortLHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashIntShortMap newImmutableMap(Map<Integer, Short> map1, Map<Integer, Short> map2, Map<Integer, Short> map3) {
        ImmutableLHashSeparateKVIntShortMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntShortLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashIntShortMap newImmutableMap(Map<Integer, Short> map1, Map<Integer, Short> map2, Map<Integer, Short> map3, Map<Integer, Short> map4) {
        ImmutableLHashSeparateKVIntShortMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntShortLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashIntShortMap newImmutableMap(Map<Integer, Short> map1, Map<Integer, Short> map2, Map<Integer, Short> map3, Map<Integer, Short> map4, Map<Integer, Short> map5) {
        ImmutableLHashSeparateKVIntShortMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntShortLHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashIntShortMap newImmutableMap(Consumer<IntShortConsumer> entriesSupplier) {
        ImmutableLHashSeparateKVIntShortMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVIntShortLHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashIntShortMap newImmutableMap(Consumer<IntShortConsumer> entriesSupplier, int expectedSize) {
        ImmutableLHashSeparateKVIntShortMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVIntShortLHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashIntShortMap newImmutableMap(int[] keys, short[] values) {
        ImmutableLHashSeparateKVIntShortMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashIntShortMap newImmutableMap(int[] keys, short[] values, int expectedSize) {
        ImmutableLHashSeparateKVIntShortMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashIntShortMap newImmutableMap(Integer[] keys, Short[] values) {
        ImmutableLHashSeparateKVIntShortMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashIntShortMap newImmutableMap(Integer[] keys, Short[] values, int expectedSize) {
        ImmutableLHashSeparateKVIntShortMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashIntShortMap newImmutableMap(Iterable<Integer> keys, Iterable<Short> values) {
        ImmutableLHashSeparateKVIntShortMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVIntShortLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashIntShortMap newImmutableMap(Iterable<Integer> keys, Iterable<Short> values, int expectedSize) {
        ImmutableLHashSeparateKVIntShortMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVIntShortLHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashIntShortMap newImmutableMapOf(int k1, short v1) {
        ImmutableLHashSeparateKVIntShortMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashIntShortMap newImmutableMapOf(int k1, short v1, int k2, short v2) {
        ImmutableLHashSeparateKVIntShortMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashIntShortMap newImmutableMapOf(int k1, short v1, int k2, short v2, int k3, short v3) {
        ImmutableLHashSeparateKVIntShortMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashIntShortMap newImmutableMapOf(int k1, short v1, int k2, short v2, int k3, short v3, int k4, short v4) {
        ImmutableLHashSeparateKVIntShortMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashIntShortMap newImmutableMapOf(int k1, short v1, int k2, short v2, int k3, short v3, int k4, short v4, int k5, short v5) {
        ImmutableLHashSeparateKVIntShortMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }
}

