/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Set;
import net.openhft.collect.ShortCollection;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.hash.ImmutableLHashShortSet;
import net.openhft.collect.impl.hash.ImmutableLHashShortSetGO;
import net.openhft.collect.impl.hash.MutableLHashShortSet;
import net.openhft.collect.impl.hash.MutableLHashShortSetGO;
import net.openhft.collect.impl.hash.SeparateKVShortLHash;
import net.openhft.collect.impl.hash.ShortLHashFactory;
import net.openhft.collect.impl.hash.UpdatableLHashShortSet;
import net.openhft.collect.impl.hash.UpdatableLHashShortSetGO;
import net.openhft.collect.set.hash.HashShortSetFactory;

public abstract class LHashShortSetFactorySO
extends ShortLHashFactory
implements HashShortSetFactory {
    LHashShortSetFactorySO(HashConfig hashConf, int defaultExpectedSize, short lower, short upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    MutableLHashShortSetGO uninitializedMutableSet() {
        return new MutableLHashShortSet();
    }

    UpdatableLHashShortSetGO uninitializedUpdatableSet() {
        return new UpdatableLHashShortSet();
    }

    ImmutableLHashShortSetGO uninitializedImmutableSet() {
        return new ImmutableLHashShortSet();
    }

    public MutableLHashShortSetGO newMutableSet(int expectedSize) {
        MutableLHashShortSet set = new MutableLHashShortSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    public UpdatableLHashShortSetGO newUpdatableSet(int expectedSize) {
        UpdatableLHashShortSet set = new UpdatableLHashShortSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    public UpdatableLHashShortSetGO newUpdatableSet(Iterable<Short> elements, int expectedSize) {
        if (elements instanceof ShortCollection) {
            SeparateKVShortLHash hash;
            if (elements instanceof SeparateKVShortLHash && (hash = (SeparateKVShortLHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableLHashShortSet set = new UpdatableLHashShortSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableLHashShortSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableLHashShortSetGO set = this.newUpdatableSet(size);
        for (short e : elements) {
            set.add(e);
        }
        return set;
    }
}

