/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.collect.ByteCollection;
import net.openhft.collect.ByteCursor;
import net.openhft.collect.impl.CommonByteCollectionOps;
import net.openhft.collect.impl.CommonSetOps;
import net.openhft.collect.impl.InternalByteCollectionOps;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.MutableByteLHashSetSO;
import net.openhft.collect.impl.hash.SeparateKVByteLHash;
import net.openhft.collect.set.ByteSet;
import net.openhft.collect.set.hash.HashByteSet;

public class MutableLHashByteSetGO
extends MutableByteLHashSetSO
implements HashByteSet,
InternalByteCollectionOps {
    @Override
    final void copy(SeparateKVByteLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVByteLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals(this, obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonByteCollectionOps.containsAll(this, c);
    }

    @Nonnull
    public ByteCursor cursor() {
        return this.setCursor();
    }

    public boolean add(Byte e) {
        return this.add((byte)e);
    }

    public boolean add(byte key) {
        byte free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        byte[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVByteKeyMixing.mix(key) & capacityMask;
        byte cur = keys[index];
        if (cur != free) {
            if (cur == key) {
                return false;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != free) {
                if (cur != key) continue;
                return false;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.postInsertHook();
        return true;
    }

    public boolean addAll(@Nonnull Collection<? extends Byte> c) {
        return CommonByteCollectionOps.addAll(this, c);
    }

    public boolean remove(Object key) {
        return this.removeByte((Byte)key);
    }

    @Override
    boolean justRemove(byte key) {
        return this.removeByte(key);
    }

    public boolean removeByte(byte key) {
        byte free = this.freeValue;
        if (key != free) {
            byte keyToShift;
            int indexToRemove;
            byte[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVByteKeyMixing.mix(key) & capacityMask;
            byte cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        if (c instanceof ByteCollection) {
            InternalByteCollectionOps c2;
            if (c instanceof InternalByteCollectionOps && (c2 = (InternalByteCollectionOps)((Object)c)).size() < this.size()) {
                return c2.reverseRemoveAllFrom((ByteSet)this);
            }
            return this.removeAll((HashByteSet)this, (ByteCollection)c);
        }
        return this.removeAll((HashByteSet)this, c);
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

