/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.CharCollection;
import net.openhft.collect.CharCursor;
import net.openhft.collect.CharIterator;
import net.openhft.collect.Equivalence;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractCharValueView;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonCharCharMapOps;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.InternalCharCharMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.MutableLHashParallelKVCharCharMapSO;
import net.openhft.collect.impl.hash.MutableParallelKVCharLHashGO;
import net.openhft.collect.impl.hash.ParallelKVCharCharLHash;
import net.openhft.collect.map.CharCharCursor;
import net.openhft.collect.set.CharSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashCharSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.CharBinaryOperator;
import net.openhft.function.CharCharConsumer;
import net.openhft.function.CharCharPredicate;
import net.openhft.function.CharCharToCharFunction;
import net.openhft.function.CharConsumer;
import net.openhft.function.CharPredicate;
import net.openhft.function.CharUnaryOperator;

public class MutableLHashParallelKVCharCharMapGO
extends MutableLHashParallelKVCharCharMapSO {
    final void copy(ParallelKVCharCharLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVCharCharLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public char defaultValue() {
        return '\u0000';
    }

    @Override
    public boolean containsEntry(char key, char value) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (char)(entry >>> 16) == value;
            }
            if (cur == free) {
                return false;
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (char)(entry >>> 16) == value;
            } while (cur != free);
            return false;
        }
        return false;
    }

    @Override
    public Character get(Object key) {
        char free;
        char k = ((Character)key).charValue();
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == k) {
                return Character.valueOf((char)(entry >>> 16));
            }
            if (cur == free) {
                return null;
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return Character.valueOf((char)(entry >>> 16));
            } while (cur != free);
            return null;
        }
        return null;
    }

    public char get(char key) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (char)(entry >>> 16);
            }
            if (cur == free) {
                return this.defaultValue();
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (char)(entry >>> 16);
            } while (cur != free);
            return this.defaultValue();
        }
        return this.defaultValue();
    }

    @Override
    public Character getOrDefault(Object key, Character defaultValue) {
        char free;
        char k = ((Character)key).charValue();
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == k) {
                return Character.valueOf((char)(entry >>> 16));
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return Character.valueOf((char)(entry >>> 16));
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    public char getOrDefault(char key, char defaultValue) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (char)(entry >>> 16);
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (char)(entry >>> 16);
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Character, ? super Character> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            action.accept(Character.valueOf(key), Character.valueOf((char)(entry >>> 16)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(CharCharConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            action.accept(key, (char)(entry >>> 16));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(CharCharPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free || predicate.test(key, (char)(entry >>> 16))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public CharCharCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonCharCharMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalCharCharMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free || m.containsEntry(key, (char)(entry >>> 16))) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalCharCharMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            m.justPut(key, (char)(entry >>> 16));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Character, Character>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public CharCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            hashCode += key ^ (char)(entry >>> 16);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append((char)(entry >>> 16));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        int[] newTab = this.table;
        int capacityMask = newTab.length - 1;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            if (U.getChar(newTab, INT_BASE + CHAR_KEY_OFFSET + ((long)index << 2)) != free) {
                while (U.getChar(newTab, INT_BASE + CHAR_KEY_OFFSET + ((long)(index = index - 1 & capacityMask) << 2)) != free) {
                }
            }
            newTab[index] = entry;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Character put(Character key, Character value) {
        char free;
        char k = key.charValue();
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = k | value.charValue() << 16;
            this.postInsertHook();
            return null;
        }
        if (cur != k) {
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = k | value.charValue() << 16;
                this.postInsertHook();
                return null;
            } while (cur != k);
        }
        char prevValue = (char)(entry >>> 16);
        U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), value.charValue());
        return Character.valueOf(prevValue);
    }

    @Override
    public char put(char key, char value) {
        char free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key | value << 16;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur != key) {
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = key | value << 16;
                this.postInsertHook();
                return this.defaultValue();
            } while (cur != key);
        }
        char prevValue = (char)(entry >>> 16);
        U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), value);
        return prevValue;
    }

    @Override
    public Character putIfAbsent(Character key, Character value) {
        char free;
        char k = key.charValue();
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = k | value.charValue() << 16;
            this.postInsertHook();
            return null;
        }
        if (cur == k) {
            return Character.valueOf((char)(entry >>> 16));
        }
        do {
            if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
            this.incrementModCount();
            tab[index] = k | value.charValue() << 16;
            this.postInsertHook();
            return null;
        } while (cur != k);
        return Character.valueOf((char)(entry >>> 16));
    }

    @Override
    public char putIfAbsent(char key, char value) {
        char free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key | value << 16;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur == key) {
            return (char)(entry >>> 16);
        }
        do {
            if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
            this.incrementModCount();
            tab[index] = key | value << 16;
            this.postInsertHook();
            return this.defaultValue();
        } while (cur != key);
        return (char)(entry >>> 16);
    }

    @Override
    public void justPut(char key, char value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        U.putChar(this.table, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), value);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Character compute(Character key, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        block5: {
            k = key.charValue();
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
            entry = tab[index];
            cur = (char)entry;
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl16
            while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != free) continue;
lbl16:
                // 2 sources

                if ((newValue = remappingFunction.apply(Character.valueOf(k), null)) != null) {
                    this.incrementModCount();
                    tab[index] = k | newValue.charValue() << 16;
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(Character.valueOf(k), Character.valueOf((char)(entry >>> 16)))) != null) {
            MutableLHashParallelKVCharCharMapGO.U.putChar(tab, MutableLHashParallelKVCharCharMapGO.INT_BASE + MutableLHashParallelKVCharCharMapGO.CHAR_VALUE_OFFSET + ((long)index << 2), newValue.charValue());
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public char compute(char key, CharCharToCharFunction remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            entry = tab[index];
            cur = (char)entry;
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                newValue = remappingFunction.applyAsChar(key, this.defaultValue());
                this.incrementModCount();
                tab[index] = key | newValue << 16;
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsChar(key, (char)(entry >>> 16));
        MutableLHashParallelKVCharCharMapGO.U.putChar(tab, MutableLHashParallelKVCharCharMapGO.INT_BASE + MutableLHashParallelKVCharCharMapGO.CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    @Override
    public Character computeIfAbsent(Character key, Function<? super Character, ? extends Character> mappingFunction) {
        Character value;
        char k = key.charValue();
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        char free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur != free) {
            if (cur == k) {
                return Character.valueOf((char)(entry >>> 16));
            }
            while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != free) {
                if (cur != k) continue;
                return Character.valueOf((char)(entry >>> 16));
            }
        }
        if ((value = mappingFunction.apply(Character.valueOf(k))) != null) {
            this.incrementModCount();
            tab[index] = k | value.charValue() << 16;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public char computeIfAbsent(char key, CharUnaryOperator mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        char free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur != free) {
            if (cur == key) {
                return (char)(entry >>> 16);
            }
            while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != free) {
                if (cur != key) continue;
                return (char)(entry >>> 16);
            }
        }
        char value = mappingFunction.applyAsChar(key);
        this.incrementModCount();
        tab[index] = key | value << 16;
        this.postInsertHook();
        return value;
    }

    @Override
    public Character computeIfPresent(Character key, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        char k = key.charValue();
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        char free = this.freeValue;
        if (k != free) {
            Character newValue;
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            if ((newValue = remappingFunction.apply(Character.valueOf(k), Character.valueOf((char)(entry >>> 16)))) != null) {
                U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue.charValue());
                return newValue;
            }
            this.removeAt(index);
            return null;
        }
        return null;
    }

    public char computeIfPresent(char key, CharCharToCharFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            char newValue = remappingFunction.applyAsChar(key, (char)(entry >>> 16));
            U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Character merge(Character key, Character value, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        block5: {
            k = key.charValue();
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
            entry = tab[index];
            cur = (char)entry;
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl18
            while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != free) continue;
lbl18:
                // 2 sources

                this.incrementModCount();
                tab[index] = k | value.charValue() << 16;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply(Character.valueOf((char)(entry >>> 16)), value)) != null) {
            MutableLHashParallelKVCharCharMapGO.U.putChar(tab, MutableLHashParallelKVCharCharMapGO.INT_BASE + MutableLHashParallelKVCharCharMapGO.CHAR_VALUE_OFFSET + ((long)index << 2), newValue.charValue());
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public char merge(char key, char value, CharBinaryOperator remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            entry = tab[index];
            cur = (char)entry;
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                this.incrementModCount();
                tab[index] = key | value << 16;
                this.postInsertHook();
                return value;
            }
        }
        newValue = remappingFunction.applyAsChar((char)(entry >>> 16), value);
        MutableLHashParallelKVCharCharMapGO.U.putChar(tab, MutableLHashParallelKVCharCharMapGO.INT_BASE + MutableLHashParallelKVCharCharMapGO.CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public char addValue(char key, char value) {
        char free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key | value << 16;
            this.postInsertHook();
            return value;
        }
        if (cur != key) {
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = key | value << 16;
                this.postInsertHook();
                return value;
            } while (cur != key);
        }
        char newValue = (char)((char)(entry >>> 16) + value);
        U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public char addValue(char key, char addition, char defaultValue) {
        char value = (char)(defaultValue + addition);
        char free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key | value << 16;
            this.postInsertHook();
            return value;
        }
        if (cur != key) {
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = key | value << 16;
                this.postInsertHook();
                return value;
            } while (cur != key);
        }
        char newValue = (char)((char)(entry >>> 16) + addition);
        U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Character, ? extends Character> m) {
        CommonCharCharMapOps.putAll(this, m);
    }

    @Override
    public Character replace(Character key, Character value) {
        char free;
        char k = key.charValue();
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            char oldValue = (char)(entry >>> 16);
            U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), value.charValue());
            return Character.valueOf(oldValue);
        }
        return null;
    }

    @Override
    public char replace(char key, char value) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            char oldValue = (char)(entry >>> 16);
            U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), value);
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Character key, Character oldValue, Character newValue) {
        return this.replace(key.charValue(), oldValue.charValue(), newValue.charValue());
    }

    @Override
    public boolean replace(char key, char oldValue, char newValue) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            if ((char)(entry >>> 16) == oldValue) {
                U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Character, ? super Character, ? extends Character> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)i << 2), function.apply(Character.valueOf(key), Character.valueOf((char)(entry >>> 16))).charValue());
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(CharCharToCharFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)i << 2), function.applyAsChar(key, (char)(entry >>> 16)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        int entry;
        char keyToShift;
        int indexToRemove;
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
            if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                tab[indexToRemove] = entry;
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
        this.postRemoveHook();
    }

    @Override
    public Character remove(Object key) {
        char free;
        char k = ((Character)key).charValue();
        if (k != (free = this.freeValue)) {
            char keyToShift;
            int indexToRemove;
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            char val = (char)(entry >>> 16);
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = entry;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
            this.postRemoveHook();
            return Character.valueOf(val);
        }
        return null;
    }

    @Override
    public boolean justRemove(char key) {
        char free = this.freeValue;
        if (key != free) {
            char keyToShift;
            int indexToRemove;
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = entry;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public char remove(char key) {
        char free = this.freeValue;
        if (key != free) {
            char keyToShift;
            int indexToRemove;
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            char val = (char)(entry >>> 16);
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = entry;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(((Character)key).charValue(), ((Character)value).charValue());
    }

    public boolean remove(char key, char value) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            if ((char)(entry >>> 16) == value) {
                char keyToShift;
                int indexToRemove;
                this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(CharCharPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || !filter.test(key, (char)(entry >>> 16))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                } else {
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(Predicate<? super Character> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || !filter.test(Character.valueOf(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                } else {
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(CharPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                } else {
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeAll(@Nonnull HashCharSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || !c.contains(Character.valueOf(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                } else {
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashCharSet thisC, @Nonnull CharCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                } else {
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull HashCharSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof CharCollection) {
            return this.retainAll(thisC, (CharCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = tab.length - 1; i >= 0; --i) {
            block13: {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || c.contains(Character.valueOf(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                break block13;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                } else {
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashCharSet thisC, @Nonnull CharCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = tab.length - 1; i >= 0; --i) {
            block12: {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                } else {
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    void closeDelayedRemoved(int firstDelayedRemoved, char delayedRemoved) {
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        for (int i = firstDelayedRemoved; i >= 0; --i) {
            char keyToShift;
            int indexToRemove;
            int entry = tab[i];
            if ((char)entry != delayedRemoved) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 1;
            while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                if (keyToShift != delayedRemoved && (LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = entry;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + i) continue;
                throw new ConcurrentModificationException();
            }
            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
        }
    }

    @Override
    public CharIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedKeyIterator(mc);
    }

    @Override
    public CharCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedKeyCursor(mc);
    }

    class NoRemovedMapCursor
    implements CharCharCursor {
        int[] tab;
        final char free;
        final int capacityMask;
        int expectedModCount;
        int index;
        char curKey;
        char curValue;

        NoRemovedMapCursor(int mc) {
            char free;
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVCharCharMapGO.this.table;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            this.capacityMask = tab.length - 1;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableLHashParallelKVCharCharMapGO.this.freeValue);
        }

        public void forEachForward(CharCharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(key, (char)(entry >>> 16));
            }
            if (index != this.index || mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char key() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public char value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValue(char value) {
            if (this.curKey == this.free) throw new IllegalStateException();
            if (this.expectedModCount != MutableLHashParallelKVCharCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_VALUE_OFFSET + ((long)this.index << 2), value);
            if (this.tab == MutableLHashParallelKVCharCharMapGO.this.table) return;
            UnsafeConstants.U.putChar(MutableLHashParallelKVCharCharMapGO.this.table, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_VALUE_OFFSET + ((long)this.index << 2), value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (char)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            char curKey = this.curKey;
            char free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVCharCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            int[] tab = this.tab;
            if (tab == MutableLHashParallelKVCharCharMapGO.this.table) {
                int entry;
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVCharCharMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                MutableLHashParallelKVCharCharMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVCharCharMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueCursor
    implements CharCursor {
        int[] tab;
        final char free;
        final int capacityMask;
        int expectedModCount;
        int index;
        char curKey;
        char curValue;

        NoRemovedValueCursor(int mc) {
            char free;
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVCharCharMapGO.this.table;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            this.capacityMask = tab.length - 1;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableLHashParallelKVCharCharMapGO.this.freeValue);
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((char)(entry >>> 16));
            }
            if (index != this.index || mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (char)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            char curKey = this.curKey;
            char free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVCharCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            int[] tab = this.tab;
            if (tab == MutableLHashParallelKVCharCharMapGO.this.table) {
                int entry;
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVCharCharMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                MutableLHashParallelKVCharCharMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVCharCharMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueIterator
    implements CharIterator {
        int[] tab;
        final char free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        char next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVCharCharMapGO.this.table;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            this.capacityMask = tab.length - 1;
            char free = this.free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                if ((char)entry == free) continue;
                this.next = (char)(entry >>> 16);
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                    this.index = nextI;
                    int[] tab = this.tab;
                    char free = this.free;
                    char prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        if ((char)entry == free) continue;
                        this.next = (char)(entry >>> 16);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept(Character.valueOf((char)(entry >>> 16)));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((char)(entry >>> 16));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVCharCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            int[] tab = this.tab;
            if (tab == MutableLHashParallelKVCharCharMapGO.this.table) {
                int entry;
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVCharCharMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != this.free) {
                    if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), this.free);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = (char)(entry >>> 16);
                                }
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), this.free);
                MutableLHashParallelKVCharCharMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVCharCharMapGO.this.justRemove(UnsafeConstants.U.getChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)index << 2)));
            }
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Character, Character>> {
        int[] tab;
        final char free;
        final int capacityMask;
        int expectedModCount;
        int index;
        char curKey;
        char curValue;

        NoRemovedEntryCursor(int mc) {
            char free;
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVCharCharMapGO.this.table;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            this.capacityMask = tab.length - 1;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableLHashParallelKVCharCharMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Character, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(new MutableEntry2(mc, i, key, (char)(entry >>> 16)));
            }
            if (index != this.index || mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Character, Character> elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry2(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (char)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            char curKey = this.curKey;
            char free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVCharCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            int[] tab = this.tab;
            if (tab == MutableLHashParallelKVCharCharMapGO.this.table) {
                int entry;
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVCharCharMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                MutableLHashParallelKVCharCharMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVCharCharMapGO.this.justRemove(curKey);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, char key, char value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(char newValue) {
                if (NoRemovedEntryCursor.this.tab == MutableLHashParallelKVCharCharMapGO.this.table) {
                    UnsafeConstants.U.putChar(NoRemovedEntryCursor.this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_VALUE_OFFSET + ((long)NoRemovedEntryCursor.this.index << 2), newValue);
                } else {
                    MutableLHashParallelKVCharCharMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Character, Character>> {
        int[] tab;
        final char free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVCharCharMapGO.this.table;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            this.capacityMask = tab.length - 1;
            char free = this.free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                char key = (char)entry;
                if (key == free) continue;
                this.next = new MutableEntry2(mc, nextI, key, (char)(entry >>> 16));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Character, Character>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(new MutableEntry2(mc, i, key, (char)(entry >>> 16)));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Character, Character> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                    this.index = nextI;
                    int[] tab = this.tab;
                    char free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        char key = (char)entry;
                        if (key == free) continue;
                        this.next = new MutableEntry2(mc, nextI, key, (char)(entry >>> 16));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVCharCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            int[] tab = this.tab;
            if (tab == MutableLHashParallelKVCharCharMapGO.this.table) {
                int entry;
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVCharCharMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != this.free) {
                    if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), this.free);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = new MutableEntry2(MutableLHashParallelKVCharCharMapGO.this.modCount(), indexToShift, keyToShift, (char)(entry >>> 16));
                                }
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), this.free);
                MutableLHashParallelKVCharCharMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVCharCharMapGO.this.justRemove(UnsafeConstants.U.getChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)index << 2)));
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, char key, char value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(char newValue) {
                if (NoRemovedEntryIterator.this.tab == MutableLHashParallelKVCharCharMapGO.this.table) {
                    UnsafeConstants.U.putChar(NoRemovedEntryIterator.this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_VALUE_OFFSET + ((long)NoRemovedEntryIterator.this.index << 2), newValue);
                } else {
                    MutableLHashParallelKVCharCharMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class ValueView
    extends AbstractCharValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return MutableLHashParallelKVCharCharMapGO.this.size();
        }

        public boolean shrink() {
            return MutableLHashParallelKVCharCharMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableLHashParallelKVCharCharMapGO.this.containsValue(o);
        }

        public boolean contains(char v) {
            return MutableLHashParallelKVCharCharMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Character> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept(Character.valueOf((char)(entry >>> 16)));
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((char)(entry >>> 16));
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(CharPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free || predicate.test((char)(entry >>> 16))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(CharCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free || c.contains((char)(entry >>> 16))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(CharCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                changed |= c.add((char)(entry >>> 16));
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(CharSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                changed |= s.removeChar((char)(entry >>> 16));
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public CharIterator iterator() {
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public CharCursor cursor() {
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                result[resultIndex++] = Character.valueOf((char)(entry >>> 16));
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                a[resultIndex++] = Character.valueOf((char)(entry >>> 16));
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public char[] toCharArray() {
            int size = this.size();
            char[] result = new char[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                result[resultIndex++] = (char)(entry >>> 16);
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public char[] toArray(char[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new char[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = '\u0000';
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                a[resultIndex++] = (char)(entry >>> 16);
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = '\u0000';
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                sb.append(' ').append((char)(entry >>> 16)).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeChar(((Character)o).charValue());
        }

        public boolean removeChar(char v) {
            return MutableLHashParallelKVCharCharMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            MutableLHashParallelKVCharCharMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Character> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            for (int i = tab.length - 1; i >= 0; --i) {
                block11: {
                    int entry = tab[i];
                    if ((char)entry == free || !filter.test(Character.valueOf((char)(entry >>> 16)))) continue;
                    MutableLHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    } else {
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                MutableLHashParallelKVCharCharMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVCharCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(CharPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            for (int i = tab.length - 1; i >= 0; --i) {
                block11: {
                    int entry = tab[i];
                    if ((char)entry == free || !filter.test((char)(entry >>> 16))) continue;
                    MutableLHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    } else {
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                MutableLHashParallelKVCharCharMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVCharCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof CharCollection) {
                return this.removeAll((CharCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            for (int i = tab.length - 1; i >= 0; --i) {
                block12: {
                    int entry = tab[i];
                    if ((char)entry == free || !c.contains(Character.valueOf((char)(entry >>> 16)))) continue;
                    MutableLHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    } else {
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                MutableLHashParallelKVCharCharMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVCharCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(CharCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            for (int i = tab.length - 1; i >= 0; --i) {
                block11: {
                    int entry = tab[i];
                    if ((char)entry == free || !c.contains((char)(entry >>> 16))) continue;
                    MutableLHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    } else {
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                MutableLHashParallelKVCharCharMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVCharCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof CharCollection) {
                return this.retainAll((CharCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            for (int i = tab.length - 1; i >= 0; --i) {
                block13: {
                    int entry = tab[i];
                    if ((char)entry == free || c.contains(Character.valueOf((char)(entry >>> 16)))) continue;
                    MutableLHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    } else {
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                MutableLHashParallelKVCharCharMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVCharCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(CharCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            for (int i = tab.length - 1; i >= 0; --i) {
                block12: {
                    int entry = tab[i];
                    if ((char)entry == free || c.contains((char)(entry >>> 16))) continue;
                    MutableLHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    } else {
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                MutableLHashParallelKVCharCharMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVCharCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends CharCharEntry {
        private char key;
        private char value;

        ReusableEntry() {
        }

        ReusableEntry with(char key, char value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }
    }

    class MutableEntry
    extends CharCharEntry {
        int modCount;
        private final int index;
        final char key;
        private char value;

        MutableEntry(int modCount, int index, char key, char value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }

        @Override
        public Character setValue(Character newValue) {
            char unwrappedNewValue;
            if (this.modCount != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            char oldValue = this.value;
            this.value = unwrappedNewValue = newValue.charValue();
            this.updateValueInTable(unwrappedNewValue);
            return Character.valueOf(oldValue);
        }

        void updateValueInTable(char newValue) {
            UnsafeConstants.U.putChar(MutableLHashParallelKVCharCharMapGO.this.table, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_VALUE_OFFSET + ((long)this.index << 2), newValue);
        }
    }

    abstract class CharCharEntry
    extends AbstractEntry<Character, Character> {
        CharCharEntry() {
        }

        abstract char key();

        @Override
        public final Character getKey() {
            return Character.valueOf(this.key());
        }

        abstract char value();

        @Override
        public final Character getValue() {
            return Character.valueOf(this.value());
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                char k2 = ((Character)e2.getKey()).charValue();
                char v2 = ((Character)e2.getValue()).charValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Character, Character>>
    implements HashObjSet<Map.Entry<Character, Character>>,
    InternalObjCollectionOps<Map.Entry<Character, Character>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Character, Character>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableLHashParallelKVCharCharMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableLHashParallelKVCharCharMapGO.this.size();
        }

        public double currentLoad() {
            return MutableLHashParallelKVCharCharMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableLHashParallelKVCharCharMapGO.this.containsEntry(((Character)e.getKey()).charValue(), ((Character)e.getValue()).charValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, (char)(entry >>> 16));
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, (char)(entry >>> 16));
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Character, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, (char)(entry >>> 16)));
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Character, Character>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || predicate.test(new MutableEntry(mc, i, key, (char)(entry >>> 16)))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Character, Character>> iterator() {
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Character, Character>> cursor() {
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || c.contains((Object)e.with(key, (char)(entry >>> 16)))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, (char)(entry >>> 16)));
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Character, Character>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, (char)(entry >>> 16)));
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableLHashParallelKVCharCharMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((char)(entry >>> 16));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableLHashParallelKVCharCharMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                char key = ((Character)e.getKey()).charValue();
                char value = ((Character)e.getValue()).charValue();
                return MutableLHashParallelKVCharCharMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Character, Character>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            for (int i = tab.length - 1; i >= 0; --i) {
                block11: {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || !filter.test(new MutableEntry(mc, i, key, (char)(entry >>> 16)))) continue;
                    MutableLHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    } else {
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                MutableLHashParallelKVCharCharMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVCharCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            for (int i = tab.length - 1; i >= 0; --i) {
                block13: {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || !c.contains(e.with(key, (char)(entry >>> 16)))) continue;
                    MutableLHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    } else {
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                MutableLHashParallelKVCharCharMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVCharCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVCharCharMapGO.this.modCount();
            char free = MutableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = MutableLHashParallelKVCharCharMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            for (int i = tab.length - 1; i >= 0; --i) {
                block12: {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || c.contains(e.with(key, (char)(entry >>> 16)))) continue;
                    MutableLHashParallelKVCharCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                    } else {
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                    }
                }
                MutableLHashParallelKVCharCharMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVCharCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableLHashParallelKVCharCharMapGO.this.clear();
        }
    }

    class NoRemovedKeyCursor
    extends MutableParallelKVCharLHashGO.NoRemovedCursor {
        private NoRemovedKeyCursor(int mc) {
            super(MutableLHashParallelKVCharCharMapGO.this, mc);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            char curKey = this.curKey;
            char free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVCharCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            int[] tab = this.tab;
            if (tab == MutableLHashParallelKVCharCharMapGO.this.table) {
                int entry;
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVCharCharMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                MutableLHashParallelKVCharCharMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVCharCharMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedKeyIterator
    extends MutableParallelKVCharLHashGO.NoRemovedIterator {
        private NoRemovedKeyIterator(int mc) {
            super(MutableLHashParallelKVCharCharMapGO.this, mc);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVCharCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            int[] tab = this.tab;
            if (tab == MutableLHashParallelKVCharCharMapGO.this.table) {
                int entry;
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVCharCharMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != this.free) {
                    if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), this.free);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = keyToShift;
                                }
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), this.free);
                MutableLHashParallelKVCharCharMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVCharCharMapGO.this.justRemove(UnsafeConstants.U.getChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)index << 2)));
            }
        }
    }
}

