/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import net.openhft.collect.impl.InternalDoubleDoubleMapOps;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.MutableLHashParallelKVDoubleKeyMap;
import net.openhft.collect.impl.hash.ParallelKVDoubleDoubleLHash;
import net.openhft.collect.map.hash.HashDoubleDoubleMap;

public abstract class MutableLHashParallelKVDoubleDoubleMapSO
extends MutableLHashParallelKVDoubleKeyMap
implements HashDoubleDoubleMap,
InternalDoubleDoubleMapOps,
ParallelKVDoubleDoubleLHash {
    int valueIndex(long value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || value != tab[i + 1]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    boolean containsValue(long value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(long value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    int valueIndex(double value) {
        if (this.isEmpty()) {
            return -1;
        }
        long val = Double.doubleToLongBits(value);
        int index = -1;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || val != tab[i + 1]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(double value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(double value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Double)value);
    }

    int insert(long key, long value) {
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVDoubleKeyMixing.mix(key) & capacityMask;
        long cur = tab[index];
        if (cur == key) {
            return index;
        }
        if (cur != 0x7FFFFFFFFFFFFFFEL) {
            do {
                if ((cur = tab[index = index - 2 & capacityMask]) != key) continue;
                return index;
            } while (cur != 0x7FFFFFFFFFFFFFFEL);
        }
        this.incrementModCount();
        tab[index] = key;
        tab[index + 1] = value;
        this.postInsertHook();
        return -1;
    }
}

