/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import net.openhft.collect.impl.InternalFloatFloatMapOps;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.MutableLHashParallelKVFloatKeyMap;
import net.openhft.collect.impl.hash.ParallelKVFloatFloatLHash;
import net.openhft.collect.map.hash.HashFloatFloatMap;

public abstract class MutableLHashParallelKVFloatFloatMapSO
extends MutableLHashParallelKVFloatKeyMap
implements HashFloatFloatMap,
InternalFloatFloatMapOps,
ParallelKVFloatFloatLHash {
    int valueIndex(int value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            if ((int)entry >= 0x7FFFFFFE || value != (int)(entry >>> 32)) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    boolean containsValue(int value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(int value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    int valueIndex(float value) {
        if (this.isEmpty()) {
            return -1;
        }
        int val = Float.floatToIntBits(value);
        int index = -1;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            if ((int)entry >= 0x7FFFFFFE || val != (int)(entry >>> 32)) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(float value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(float value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(((Float)value).floatValue());
    }

    int insert(int key, int value) {
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(key) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == key) {
            return index;
        }
        if (cur != 0x7FFFFFFE) {
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return index;
            } while (cur != 0x7FFFFFFE);
        }
        this.incrementModCount();
        tab[index] = (long)key & 0xFFFFFFFFL | (long)value << 32;
        this.postInsertHook();
        return -1;
    }
}

