/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.FloatCollection;
import net.openhft.collect.FloatCursor;
import net.openhft.collect.FloatIterator;
import net.openhft.collect.IntCollection;
import net.openhft.collect.IntCursor;
import net.openhft.collect.IntIterator;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractIntValueView;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonFloatIntMapOps;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.InternalFloatCollectionOps;
import net.openhft.collect.impl.InternalFloatIntMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.MutableLHashParallelKVFloatIntMapSO;
import net.openhft.collect.impl.hash.MutableParallelKVFloatLHashGO;
import net.openhft.collect.impl.hash.ParallelKVFloatIntLHash;
import net.openhft.collect.map.FloatIntCursor;
import net.openhft.collect.set.IntSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashFloatSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.FloatIntConsumer;
import net.openhft.function.FloatIntPredicate;
import net.openhft.function.FloatIntToIntFunction;
import net.openhft.function.FloatPredicate;
import net.openhft.function.FloatToIntFunction;

public class MutableLHashParallelKVFloatIntMapGO
extends MutableLHashParallelKVFloatIntMapSO {
    final void copy(ParallelKVFloatIntLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVFloatIntLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public int defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(float key, int value) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32) == value;
        }
        if (cur == 0x7FFFFFFE) {
            return false;
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
            return (int)(entry >>> 32) == value;
        } while (cur != 0x7FFFFFFE);
        return false;
    }

    @Override
    public boolean containsEntry(int key, int value) {
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(key) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == key) {
            return (int)(entry >>> 32) == value;
        }
        if (cur == 0x7FFFFFFE) {
            return false;
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
            return (int)(entry >>> 32) == value;
        } while (cur != 0x7FFFFFFE);
        return false;
    }

    @Override
    public Integer get(Object key) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        if (cur == 0x7FFFFFFE) {
            return null;
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
            return (int)(entry >>> 32);
        } while (cur != 0x7FFFFFFE);
        return null;
    }

    public int get(float key) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        if (cur == 0x7FFFFFFE) {
            return this.defaultValue();
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
            return (int)(entry >>> 32);
        } while (cur != 0x7FFFFFFE);
        return this.defaultValue();
    }

    @Override
    public Integer getOrDefault(Object key, Integer defaultValue) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        if (cur == 0x7FFFFFFE) {
            return defaultValue;
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
            return (int)(entry >>> 32);
        } while (cur != 0x7FFFFFFE);
        return defaultValue;
    }

    public int getOrDefault(float key, int defaultValue) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        if (cur == 0x7FFFFFFE) {
            return defaultValue;
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
            return (int)(entry >>> 32);
        } while (cur != 0x7FFFFFFE);
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Float, ? super Integer> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.valueOf(Float.intBitsToFloat(key)), (Integer)((int)(entry >>> 32)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(FloatIntConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.intBitsToFloat(key), (int)(entry >>> 32));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(FloatIntPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE || predicate.test(Float.intBitsToFloat(key), (int)(entry >>> 32))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public FloatIntCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonFloatIntMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalFloatIntMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE || m.containsEntry(key, (int)(entry >>> 32))) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalFloatIntMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            m.justPut(key, (int)(entry >>> 32));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Float, Integer>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public IntCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            hashCode += key ^ (int)(entry >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            sb.append(' ');
            sb.append(Float.intBitsToFloat(key));
            sb.append('=');
            sb.append((int)(entry >>> 32));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newTab = this.table;
        int capacityMask = newTab.length - 1;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            int index = LHash.ParallelKVFloatKeyMixing.mix(key) & capacityMask;
            if (U.getInt(newTab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)index << 3)) != 0x7FFFFFFE) {
                while (U.getInt(newTab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)(index = index - 1 & capacityMask) << 3)) != 0x7FFFFFFE) {
                }
            }
            newTab[index] = entry;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Integer put(Float key, Integer value) {
        int k = Float.floatToIntBits(key.floatValue());
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == 0x7FFFFFFE) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
            this.postInsertHook();
            return null;
        }
        if (cur != k) {
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != 0x7FFFFFFE) continue;
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
                this.postInsertHook();
                return null;
            } while (cur != k);
        }
        int prevValue = (int)(entry >>> 32);
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
        return prevValue;
    }

    @Override
    public int put(float key, int value) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == 0x7FFFFFFE) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur != k) {
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != 0x7FFFFFFE) continue;
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
                this.postInsertHook();
                return this.defaultValue();
            } while (cur != k);
        }
        int prevValue = (int)(entry >>> 32);
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
        return prevValue;
    }

    @Override
    public Integer putIfAbsent(Float key, Integer value) {
        int k = Float.floatToIntBits(key.floatValue());
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == 0x7FFFFFFE) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
            this.postInsertHook();
            return null;
        }
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != 0x7FFFFFFE) continue;
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
            this.postInsertHook();
            return null;
        } while (cur != k);
        return (int)(entry >>> 32);
    }

    @Override
    public int putIfAbsent(float key, int value) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == 0x7FFFFFFE) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != 0x7FFFFFFE) continue;
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
            this.postInsertHook();
            return this.defaultValue();
        } while (cur != k);
        return (int)(entry >>> 32);
    }

    @Override
    public void justPut(float key, int value) {
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return;
        }
        U.putInt(this.table, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
    }

    @Override
    public void justPut(int key, int value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        U.putInt(this.table, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Integer compute(Float key, BiFunction<? super Float, ? super Integer, ? extends Integer> remappingFunction) {
        block4: {
            k = Float.floatToIntBits(key.floatValue());
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
            entry = tab[index];
            cur = (int)entry;
            if (cur == k) break block4;
            if (cur == 0x7FFFFFFE) ** GOTO lbl13
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl13:
                // 2 sources

                if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), null)) != null) {
                    this.incrementModCount();
                    tab[index] = (long)k & 0xFFFFFFFFL | (long)newValue.intValue() << 32;
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), (Integer)((int)(entry >>> 32)))) != null) {
            MutableLHashParallelKVFloatIntMapGO.U.putInt(tab, MutableLHashParallelKVFloatIntMapGO.LONG_BASE + MutableLHashParallelKVFloatIntMapGO.INT_VALUE_OFFSET + ((long)index << 3), newValue);
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public int compute(float key, FloatIntToIntFunction remappingFunction) {
        block2: {
            k = Float.floatToIntBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
            entry = tab[index];
            cur = (int)entry;
            if (cur == k) break block2;
            if (cur == 0x7FFFFFFE) ** GOTO lbl13
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl13:
                // 2 sources

                newValue = remappingFunction.applyAsInt(Float.intBitsToFloat(k), this.defaultValue());
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)newValue << 32;
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsInt(Float.intBitsToFloat(k), (int)(entry >>> 32));
        MutableLHashParallelKVFloatIntMapGO.U.putInt(tab, MutableLHashParallelKVFloatIntMapGO.LONG_BASE + MutableLHashParallelKVFloatIntMapGO.INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    @Override
    public Integer computeIfAbsent(Float key, Function<? super Float, ? extends Integer> mappingFunction) {
        Integer value;
        int k = Float.floatToIntBits(key.floatValue());
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != 0x7FFFFFFE) {
            if (cur == k) {
                return (int)(entry >>> 32);
            }
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != 0x7FFFFFFE) {
                if (cur != k) continue;
                return (int)(entry >>> 32);
            }
        }
        if ((value = mappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)))) != null) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public int computeIfAbsent(float key, FloatToIntFunction mappingFunction) {
        int k = Float.floatToIntBits(key);
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != 0x7FFFFFFE) {
            if (cur == k) {
                return (int)(entry >>> 32);
            }
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != 0x7FFFFFFE) {
                if (cur != k) continue;
                return (int)(entry >>> 32);
            }
        }
        int value = mappingFunction.applyAsInt(Float.intBitsToFloat(k));
        this.incrementModCount();
        tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
        this.postInsertHook();
        return value;
    }

    @Override
    public Integer computeIfPresent(Float key, BiFunction<? super Float, ? super Integer, ? extends Integer> remappingFunction) {
        Integer newValue;
        int k = Float.floatToIntBits(key.floatValue());
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return null;
            }
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), (Integer)((int)(entry >>> 32)))) != null) {
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    public int computeIfPresent(float key, FloatIntToIntFunction remappingFunction) {
        int k = Float.floatToIntBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return this.defaultValue();
            }
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return this.defaultValue();
            }
        }
        int newValue = remappingFunction.applyAsInt(Float.intBitsToFloat(k), (int)(entry >>> 32));
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Integer merge(Float key, Integer value, BiFunction<? super Integer, ? super Integer, ? extends Integer> remappingFunction) {
        block4: {
            k = Float.floatToIntBits(key.floatValue());
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
            entry = tab[index];
            cur = (int)entry;
            if (cur == k) break block4;
            if (cur == 0x7FFFFFFE) ** GOTO lbl15
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl15:
                // 2 sources

                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Integer)((int)(entry >>> 32)), value)) != null) {
            MutableLHashParallelKVFloatIntMapGO.U.putInt(tab, MutableLHashParallelKVFloatIntMapGO.LONG_BASE + MutableLHashParallelKVFloatIntMapGO.INT_VALUE_OFFSET + ((long)index << 3), newValue);
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public int merge(float key, int value, IntBinaryOperator remappingFunction) {
        block2: {
            k = Float.floatToIntBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
            entry = tab[index];
            cur = (int)entry;
            if (cur == k) break block2;
            if (cur == 0x7FFFFFFE) ** GOTO lbl13
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl13:
                // 2 sources

                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
                this.postInsertHook();
                return value;
            }
        }
        newValue = remappingFunction.applyAsInt((int)(entry >>> 32), value);
        MutableLHashParallelKVFloatIntMapGO.U.putInt(tab, MutableLHashParallelKVFloatIntMapGO.LONG_BASE + MutableLHashParallelKVFloatIntMapGO.INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    public int addValue(float key, int value) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == 0x7FFFFFFE) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
            this.postInsertHook();
            return value;
        }
        if (cur != k) {
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != 0x7FFFFFFE) continue;
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
                this.postInsertHook();
                return value;
            } while (cur != k);
        }
        int newValue = (int)(entry >>> 32) + value;
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    public int addValue(float key, int addition, int defaultValue) {
        int k = Float.floatToIntBits(key);
        int value = defaultValue + addition;
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == 0x7FFFFFFE) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
            this.postInsertHook();
            return value;
        }
        if (cur != k) {
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != 0x7FFFFFFE) continue;
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
                this.postInsertHook();
                return value;
            } while (cur != k);
        }
        int newValue = (int)(entry >>> 32) + addition;
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Float, ? extends Integer> m) {
        CommonFloatIntMapOps.putAll(this, m);
    }

    @Override
    public Integer replace(Float key, Integer value) {
        int k = Float.floatToIntBits(key.floatValue());
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return null;
            }
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return null;
            }
        }
        int oldValue = (int)(entry >>> 32);
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
        return oldValue;
    }

    @Override
    public int replace(float key, int value) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return this.defaultValue();
            }
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return this.defaultValue();
            }
        }
        int oldValue = (int)(entry >>> 32);
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
        return oldValue;
    }

    @Override
    public boolean replace(Float key, Integer oldValue, Integer newValue) {
        return this.replace(key.floatValue(), (int)oldValue, (int)newValue);
    }

    @Override
    public boolean replace(float key, int oldValue, int newValue) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return false;
            }
        }
        if ((int)(entry >>> 32) == oldValue) {
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
            return true;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Float, ? super Integer, ? extends Integer> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)i << 3), function.apply(Float.valueOf(Float.intBitsToFloat(key)), (Integer)((int)(entry >>> 32))));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(FloatIntToIntFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)i << 3), function.applyAsInt(Float.intBitsToFloat(key), (int)(entry >>> 32)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        long entry;
        int keyToShift;
        int indexToRemove;
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
            if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                tab[indexToRemove] = entry;
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
        this.postRemoveHook();
    }

    @Override
    public Integer remove(Object key) {
        int keyToShift;
        int indexToRemove;
        int k = Float.floatToIntBits(((Float)key).floatValue());
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return null;
            }
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return null;
            }
        }
        int val = (int)(entry >>> 32);
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
            if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                tab[indexToRemove] = entry;
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
        this.postRemoveHook();
        return val;
    }

    @Override
    public boolean justRemove(float key) {
        int keyToShift;
        int indexToRemove;
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return false;
            }
        }
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
            if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                tab[indexToRemove] = entry;
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
        this.postRemoveHook();
        return true;
    }

    @Override
    public boolean justRemove(int key) {
        int keyToShift;
        int indexToRemove;
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(key) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != key) {
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != 0x7FFFFFFE) continue;
                return false;
            }
        }
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
            if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                tab[indexToRemove] = entry;
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
        this.postRemoveHook();
        return true;
    }

    public int remove(float key) {
        int keyToShift;
        int indexToRemove;
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return this.defaultValue();
            }
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return this.defaultValue();
            }
        }
        int val = (int)(entry >>> 32);
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
            if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                tab[indexToRemove] = entry;
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
        this.postRemoveHook();
        return val;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(((Float)key).floatValue(), (Integer)value);
    }

    public boolean remove(float key, int value) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix(k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return false;
            }
        }
        if ((int)(entry >>> 32) == value) {
            int keyToShift;
            int indexToRemove;
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = entry;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public boolean removeIf(FloatIntPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || !filter.test(Float.intBitsToFloat(key), (int)(entry >>> 32))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                        if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3));
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                } else {
                    U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(Predicate<? super Float> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || !filter.test(Float.valueOf(Float.intBitsToFloat(key)))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                        if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3));
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                } else {
                    U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(FloatPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || !filter.test(Float.intBitsToFloat(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                        if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3));
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                } else {
                    U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeAll(@Nonnull HashFloatSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof InternalFloatCollectionOps) {
            return this.removeAll(thisC, (InternalFloatCollectionOps)((Object)c));
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block12: {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || !c.contains(Float.valueOf(Float.intBitsToFloat(key)))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                        if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3));
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                } else {
                    U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashFloatSet thisC, @Nonnull FloatCollection c) {
        if (c instanceof InternalFloatCollectionOps) {
            return this.removeAll(thisC, (InternalFloatCollectionOps)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block12: {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || !c.contains(Float.intBitsToFloat(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                        if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3));
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                } else {
                    U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashFloatSet thisC, @Nonnull InternalFloatCollectionOps c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                        if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3));
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                } else {
                    U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull HashFloatSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof FloatCollection) {
            return this.retainAll(thisC, (FloatCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block13: {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || c.contains(Float.valueOf(Float.intBitsToFloat(key)))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                        if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3));
                                break block13;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                } else {
                    U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashFloatSet thisC, @Nonnull FloatCollection c) {
        if (c instanceof InternalFloatCollectionOps) {
            return this.retainAll(thisC, (InternalFloatCollectionOps)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block13: {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || c.contains(Float.intBitsToFloat(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                        if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3));
                                break block13;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                } else {
                    U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashFloatSet thisC, @Nonnull InternalFloatCollectionOps c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block12: {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                        if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3));
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                } else {
                    U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    void closeDelayedRemoved(int firstDelayedRemoved, int delayedRemoved) {
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        for (int i = firstDelayedRemoved; i >= 0; --i) {
            int keyToShift;
            int indexToRemove;
            long entry = tab[i];
            if ((int)entry != delayedRemoved) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 1;
            while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                if (keyToShift != delayedRemoved && (LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = entry;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + i) continue;
                throw new ConcurrentModificationException();
            }
            U.putInt(tab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
        }
    }

    @Override
    public FloatIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedKeyIterator(mc);
    }

    @Override
    public FloatCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedKeyCursor(mc);
    }

    class NoRemovedMapCursor
    implements FloatIntCursor {
        long[] tab;
        final int capacityMask;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            this.capacityMask = tab.length - 1;
            this.index = tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(FloatIntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat(key), (int)(entry >>> 32));
            }
            if (index != this.index || mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public float key() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(curKey);
            }
            throw new IllegalStateException();
        }

        public int value() {
            if (this.curKey != 0x7FFFFFFE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValue(int value) {
            if (this.curKey == 0x7FFFFFFE) throw new IllegalStateException();
            if (this.expectedModCount != MutableLHashParallelKVFloatIntMapGO.this.modCount()) throw new ConcurrentModificationException();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_VALUE_OFFSET + ((long)this.index << 3), value);
            if (this.tab == MutableLHashParallelKVFloatIntMapGO.this.table) return;
            UnsafeConstants.U.putInt(MutableLHashParallelKVFloatIntMapGO.this.table, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_VALUE_OFFSET + ((long)this.index << 3), value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int curKey = this.curKey;
            if (curKey == 0x7FFFFFFE) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVFloatIntMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = 0x7FFFFFFE;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVFloatIntMapGO.this.table) {
                long entry;
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVFloatIntMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                    if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                MutableLHashParallelKVFloatIntMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVFloatIntMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueCursor
    implements IntCursor {
        long[] tab;
        final int capacityMask;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            this.capacityMask = tab.length - 1;
            this.index = tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((int)(entry >>> 32));
            }
            if (index != this.index || mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public int elem() {
            if (this.curKey != 0x7FFFFFFE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int curKey = this.curKey;
            if (curKey == 0x7FFFFFFE) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVFloatIntMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = 0x7FFFFFFE;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVFloatIntMapGO.this.table) {
                long entry;
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVFloatIntMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                    if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                MutableLHashParallelKVFloatIntMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVFloatIntMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueIterator
    implements IntIterator {
        long[] tab;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        int next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            this.capacityMask = tab.length - 1;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                if ((int)entry >= 0x7FFFFFFE) continue;
                this.next = (int)(entry >>> 32);
                break;
            }
            this.nextIndex = nextI;
        }

        public int nextInt() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    int prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        if ((int)entry >= 0x7FFFFFFE) continue;
                        this.next = (int)(entry >>> 32);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Integer> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((Integer)((int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(IntConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((int)(entry >>> 32));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Integer next() {
            return this.nextInt();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVFloatIntMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVFloatIntMapGO.this.table) {
                long entry;
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVFloatIntMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                    if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = (int)(entry >>> 32);
                                }
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                MutableLHashParallelKVFloatIntMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVFloatIntMapGO.this.justRemove(UnsafeConstants.U.getInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)index << 3)));
            }
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Float, Integer>> {
        long[] tab;
        final int capacityMask;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            this.capacityMask = tab.length - 1;
            this.index = tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(Consumer<? super Map.Entry<Float, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(new MutableEntry2(mc, i, key, (int)(entry >>> 32)));
            }
            if (index != this.index || mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public Map.Entry<Float, Integer> elem() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return new MutableEntry2(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int curKey = this.curKey;
            if (curKey == 0x7FFFFFFE) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVFloatIntMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = 0x7FFFFFFE;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVFloatIntMapGO.this.table) {
                long entry;
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVFloatIntMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                    if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                MutableLHashParallelKVFloatIntMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVFloatIntMapGO.this.justRemove(curKey);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, int key, int value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(int newValue) {
                if (NoRemovedEntryCursor.this.tab == MutableLHashParallelKVFloatIntMapGO.this.table) {
                    UnsafeConstants.U.putInt(NoRemovedEntryCursor.this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_VALUE_OFFSET + ((long)NoRemovedEntryCursor.this.index << 3), newValue);
                } else {
                    MutableLHashParallelKVFloatIntMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Float, Integer>> {
        long[] tab;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            this.capacityMask = tab.length - 1;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                this.next = new MutableEntry2(mc, nextI, key, (int)(entry >>> 32));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Float, Integer>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(new MutableEntry2(mc, i, key, (int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Float, Integer> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        int key = (int)entry;
                        if (key >= 0x7FFFFFFE) continue;
                        this.next = new MutableEntry2(mc, nextI, key, (int)(entry >>> 32));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVFloatIntMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVFloatIntMapGO.this.table) {
                long entry;
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVFloatIntMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                    if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = new MutableEntry2(MutableLHashParallelKVFloatIntMapGO.this.modCount(), indexToShift, keyToShift, (int)(entry >>> 32));
                                }
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                MutableLHashParallelKVFloatIntMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVFloatIntMapGO.this.justRemove(UnsafeConstants.U.getInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)index << 3)));
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, int key, int value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(int newValue) {
                if (NoRemovedEntryIterator.this.tab == MutableLHashParallelKVFloatIntMapGO.this.table) {
                    UnsafeConstants.U.putInt(NoRemovedEntryIterator.this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_VALUE_OFFSET + ((long)NoRemovedEntryIterator.this.index << 3), newValue);
                } else {
                    MutableLHashParallelKVFloatIntMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class ValueView
    extends AbstractIntValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return MutableLHashParallelKVFloatIntMapGO.this.size();
        }

        public boolean shrink() {
            return MutableLHashParallelKVFloatIntMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableLHashParallelKVFloatIntMapGO.this.containsValue(o);
        }

        public boolean contains(int v) {
            return MutableLHashParallelKVFloatIntMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Integer> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((Integer)((int)(entry >>> 32)));
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((int)(entry >>> 32));
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(IntPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || predicate.test((int)(entry >>> 32))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(IntCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || c.contains((int)(entry >>> 32))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(IntCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                changed |= c.add((int)(entry >>> 32));
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(IntSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                changed |= s.removeInt((int)(entry >>> 32));
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public IntIterator iterator() {
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public IntCursor cursor() {
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                result[resultIndex++] = (int)(entry >>> 32);
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                a[resultIndex++] = (int)(entry >>> 32);
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public int[] toIntArray() {
            int size = this.size();
            int[] result = new int[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                result[resultIndex++] = (int)(entry >>> 32);
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public int[] toArray(int[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new int[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                a[resultIndex++] = (int)(entry >>> 32);
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                sb.append(' ').append((int)(entry >>> 32)).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeInt((Integer)o);
        }

        public boolean removeInt(int v) {
            return MutableLHashParallelKVFloatIntMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            MutableLHashParallelKVFloatIntMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Integer> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            int delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block11: {
                    long entry = tab[i];
                    if ((int)entry >= 0x7FFFFFFE || !filter.test((Integer)((int)(entry >>> 32)))) continue;
                    MutableLHashParallelKVFloatIntMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                            if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3));
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                    } else {
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                    }
                }
                MutableLHashParallelKVFloatIntMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVFloatIntMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(IntPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            int delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block11: {
                    long entry = tab[i];
                    if ((int)entry >= 0x7FFFFFFE || !filter.test((int)(entry >>> 32))) continue;
                    MutableLHashParallelKVFloatIntMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                            if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3));
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                    } else {
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                    }
                }
                MutableLHashParallelKVFloatIntMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVFloatIntMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof IntCollection) {
                return this.removeAll((IntCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            int delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block12: {
                    long entry = tab[i];
                    if ((int)entry >= 0x7FFFFFFE || !c.contains((int)(entry >>> 32))) continue;
                    MutableLHashParallelKVFloatIntMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                            if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3));
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                    } else {
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                    }
                }
                MutableLHashParallelKVFloatIntMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVFloatIntMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(IntCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            int delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block11: {
                    long entry = tab[i];
                    if ((int)entry >= 0x7FFFFFFE || !c.contains((int)(entry >>> 32))) continue;
                    MutableLHashParallelKVFloatIntMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                            if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3));
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                    } else {
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                    }
                }
                MutableLHashParallelKVFloatIntMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVFloatIntMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof IntCollection) {
                return this.retainAll((IntCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            int delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block13: {
                    long entry = tab[i];
                    if ((int)entry >= 0x7FFFFFFE || c.contains((int)(entry >>> 32))) continue;
                    MutableLHashParallelKVFloatIntMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                            if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3));
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                    } else {
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                    }
                }
                MutableLHashParallelKVFloatIntMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVFloatIntMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(IntCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            int delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block12: {
                    long entry = tab[i];
                    if ((int)entry >= 0x7FFFFFFE || c.contains((int)(entry >>> 32))) continue;
                    MutableLHashParallelKVFloatIntMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                            if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3));
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                    } else {
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                    }
                }
                MutableLHashParallelKVFloatIntMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVFloatIntMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends FloatIntEntry {
        private int key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    class MutableEntry
    extends FloatIntEntry {
        int modCount;
        private final int index;
        final int key;
        private int value;

        MutableEntry(int modCount, int index, int key, int value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }

        @Override
        public Integer setValue(Integer newValue) {
            int unwrappedNewValue;
            if (this.modCount != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            int oldValue = this.value;
            this.value = unwrappedNewValue = newValue.intValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(int newValue) {
            UnsafeConstants.U.putInt(MutableLHashParallelKVFloatIntMapGO.this.table, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_VALUE_OFFSET + ((long)this.index << 3), newValue);
        }
    }

    abstract class FloatIntEntry
    extends AbstractEntry<Float, Integer> {
        FloatIntEntry() {
        }

        abstract int key();

        @Override
        public final Float getKey() {
            return Float.valueOf(Float.intBitsToFloat(this.key()));
        }

        abstract int value();

        @Override
        public final Integer getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = Float.floatToIntBits(((Float)e2.getKey()).floatValue());
                int v2 = (Integer)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Float, Integer>>
    implements HashObjSet<Map.Entry<Float, Integer>>,
    InternalObjCollectionOps<Map.Entry<Float, Integer>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Float, Integer>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableLHashParallelKVFloatIntMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableLHashParallelKVFloatIntMapGO.this.size();
        }

        public double currentLoad() {
            return MutableLHashParallelKVFloatIntMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableLHashParallelKVFloatIntMapGO.this.containsEntry(((Float)e.getKey()).floatValue(), (int)((Integer)e.getValue()));
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, (int)(entry >>> 32));
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, (int)(entry >>> 32));
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Float, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(new MutableEntry(mc, i, key, (int)(entry >>> 32)));
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Float, Integer>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || predicate.test(new MutableEntry(mc, i, key, (int)(entry >>> 32)))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Float, Integer>> iterator() {
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Float, Integer>> cursor() {
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || c.contains((Object)e.with(key, (int)(entry >>> 32)))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                changed |= s.remove((Object)e.with(key, (int)(entry >>> 32)));
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Float, Integer>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32)));
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableLHashParallelKVFloatIntMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                sb.append(' ');
                sb.append(Float.intBitsToFloat(key));
                sb.append('=');
                sb.append((int)(entry >>> 32));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableLHashParallelKVFloatIntMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                float key = ((Float)e.getKey()).floatValue();
                int value = (Integer)e.getValue();
                return MutableLHashParallelKVFloatIntMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Float, Integer>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            int delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block11: {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE || !filter.test(new MutableEntry(mc, i, key, (int)(entry >>> 32)))) continue;
                    MutableLHashParallelKVFloatIntMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                            if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3));
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                    } else {
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                    }
                }
                MutableLHashParallelKVFloatIntMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVFloatIntMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            int delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block13: {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE || !c.contains(e.with(key, (int)(entry >>> 32)))) continue;
                    MutableLHashParallelKVFloatIntMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                            if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3));
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                    } else {
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                    }
                }
                MutableLHashParallelKVFloatIntMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVFloatIntMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = MutableLHashParallelKVFloatIntMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            int delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block12: {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE || c.contains(e.with(key, (int)(entry >>> 32)))) continue;
                    MutableLHashParallelKVFloatIntMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                            if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = UnsafeConstants.U.getInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3));
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                    } else {
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                    }
                }
                MutableLHashParallelKVFloatIntMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVFloatIntMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableLHashParallelKVFloatIntMapGO.this.clear();
        }
    }

    class NoRemovedKeyCursor
    extends MutableParallelKVFloatLHashGO.NoRemovedCursor {
        private NoRemovedKeyCursor(int mc) {
            super(MutableLHashParallelKVFloatIntMapGO.this, mc);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int curKey = this.curKey;
            if (curKey == 0x7FFFFFFE) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVFloatIntMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = 0x7FFFFFFE;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVFloatIntMapGO.this.table) {
                long entry;
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVFloatIntMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                    if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                MutableLHashParallelKVFloatIntMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVFloatIntMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedKeyIterator
    extends MutableParallelKVFloatLHashGO.NoRemovedIterator {
        private NoRemovedKeyIterator(int mc) {
            super(MutableLHashParallelKVFloatIntMapGO.this, mc);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVFloatIntMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVFloatIntMapGO.this.table) {
                long entry;
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVFloatIntMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != 0x7FFFFFFE) {
                    if ((LHash.ParallelKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = Float.intBitsToFloat(keyToShift);
                                }
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)indexToRemove << 3), 0x7FFFFFFE);
                MutableLHashParallelKVFloatIntMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVFloatIntMapGO.this.justRemove(UnsafeConstants.U.getInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)index << 3)));
            }
        }
    }
}

