/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.collect.impl.InternalCharFloatMapOps;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.MutableLHashSeparateKVCharKeyMap;
import net.openhft.collect.impl.hash.SeparateKVCharFloatLHash;
import net.openhft.collect.map.hash.HashCharFloatMap;

public abstract class MutableLHashSeparateKVCharFloatMapSO
extends MutableLHashSeparateKVCharKeyMap
implements HashCharFloatMap,
InternalCharFloatMapOps,
SeparateKVCharFloatLHash {
    int[] values;

    void copy(SeparateKVCharFloatLHash hash) {
        super.copy(hash);
        this.values = (int[])hash.valueArray().clone();
    }

    void move(SeparateKVCharFloatLHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public int[] valueArray() {
        return this.values;
    }

    int valueIndex(int value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == free || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    boolean containsValue(int value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(int value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    int valueIndex(float value) {
        if (this.isEmpty()) {
            return -1;
        }
        int val = Float.floatToIntBits(value);
        int index = -1;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == free || val != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(float value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(float value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(((Float)value).floatValue());
    }

    int insert(char key, int value) {
        char free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        char[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVCharKeyMixing.mix(key) & capacityMask;
        char cur = keys[index];
        if (cur == key) {
            return index;
        }
        if (cur != free) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return index;
            } while (cur != free);
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new int[capacity];
    }
}

