/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.FloatCollection;
import net.openhft.collect.FloatCursor;
import net.openhft.collect.FloatIterator;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractFloatValueView;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.CommonObjFloatMapOps;
import net.openhft.collect.impl.InternalFloatCollectionOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.InternalObjFloatMapOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.MutableLHashSeparateKVObjFloatMapSO;
import net.openhft.collect.impl.hash.MutableSeparateKVObjLHashGO;
import net.openhft.collect.impl.hash.ObjHash;
import net.openhft.collect.impl.hash.SeparateKVObjFloatLHash;
import net.openhft.collect.map.ObjFloatCursor;
import net.openhft.collect.set.FloatSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.FloatBinaryOperator;
import net.openhft.function.FloatConsumer;
import net.openhft.function.FloatPredicate;
import net.openhft.function.ObjFloatConsumer;
import net.openhft.function.ObjFloatPredicate;
import net.openhft.function.ObjFloatToFloatFunction;
import net.openhft.function.ToFloatFunction;

public class MutableLHashSeparateKVObjFloatMapGO<K>
extends MutableLHashSeparateKVObjFloatMapSO<K> {
    @Override
    final void copy(SeparateKVObjFloatLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVObjFloatLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public float defaultValue() {
        return 0.0f;
    }

    @Override
    public boolean containsEntry(Object key, float value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == Float.floatToIntBits(value);
        }
        return false;
    }

    @Override
    public boolean containsEntry(Object key, int value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Float get(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return Float.valueOf(Float.intBitsToFloat(this.values[index]));
        }
        return null;
    }

    public float getFloat(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return Float.intBitsToFloat(this.values[index]);
        }
        return this.defaultValue();
    }

    @Override
    public Float getOrDefault(Object key, Float defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Float.valueOf(Float.intBitsToFloat(this.values[index]));
        }
        return defaultValue;
    }

    @Override
    public float getOrDefault(Object key, float defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Float.intBitsToFloat(this.values[index]);
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super Float> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key, Float.valueOf(Float.intBitsToFloat(vals[i])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void forEach(ObjFloatConsumer<? super K> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key, Float.intBitsToFloat(vals[i]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean forEachWhile(ObjFloatPredicate<? super K> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || predicate.test(key, Float.intBitsToFloat(vals[i]))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ObjFloatCursor<K> cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonObjFloatMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalObjFloatMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalObjFloatMapOps<? super K> m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<K, Float>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public FloatCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            hashCode += this.nullableKeyHashCode(key) ^ vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            sb.append(' ');
            sb.append(key != this ? key : "(this Map)");
            sb.append('=');
            sb.append(Float.intBitsToFloat(vals[i]));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        Object[] keys = this.set;
        int[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        Object[] newKeys = this.set;
        int capacityMask = newKeys.length - 1;
        int[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            int index = LHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(key)) & capacityMask;
            if (newKeys[index] != FREE) {
                while (newKeys[index = index - 1 & capacityMask] != FREE) {
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Float put(K key, Float value) {
        int index = this.insert(key, Float.floatToIntBits(value.floatValue()));
        if (index < 0) {
            return null;
        }
        int[] vals = this.values;
        float prevValue = Float.intBitsToFloat(vals[index]);
        vals[index] = Float.floatToIntBits(value.floatValue());
        return Float.valueOf(prevValue);
    }

    @Override
    public float put(K key, float value) {
        int index = this.insert(key, Float.floatToIntBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        int[] vals = this.values;
        float prevValue = Float.intBitsToFloat(vals[index]);
        vals[index] = Float.floatToIntBits(value);
        return prevValue;
    }

    @Override
    public Float putIfAbsent(K key, Float value) {
        int index = this.insert(key, Float.floatToIntBits(value.floatValue()));
        if (index < 0) {
            return null;
        }
        return Float.valueOf(Float.intBitsToFloat(this.values[index]));
    }

    @Override
    public float putIfAbsent(K key, float value) {
        int index = this.insert(key, Float.floatToIntBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        return Float.intBitsToFloat(this.values[index]);
    }

    @Override
    public void justPut(K key, float value) {
        int index = this.insert(key, Float.floatToIntBits(value));
        if (index < 0) {
            return;
        }
        this.values[index] = Float.floatToIntBits(value);
    }

    @Override
    public void justPut(K key, int value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Float compute(K key, BiFunction<? super K, ? super Float, ? extends Float> remappingFunction) {
        block5: {
            block6: {
                if (key == null) break block5;
                if (remappingFunction == null) {
                    throw new NullPointerException();
                }
                keys = this.set;
                vals = this.values;
                capacityMask = keys.length - 1;
                index = LHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) & capacityMask;
                cur = keys[index];
                if (cur == key) break block6;
                if (cur == MutableLHashSeparateKVObjFloatMapGO.FREE) ** GOTO lbl15
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != MutableLHashSeparateKVObjFloatMapGO.FREE) {
                        if (!this.keyEquals(key, cur)) continue;
                        break;
                    }
lbl15:
                    // 3 sources

                    if ((newValue = remappingFunction.apply(key, null)) != null) {
                        this.incrementModCount();
                        keys[index] = key;
                        vals[index] = Float.floatToIntBits(newValue.floatValue());
                        this.postInsertHook();
                        return newValue;
                    }
                    return null;
                }
            }
            if ((newValue = remappingFunction.apply(key, Float.valueOf(Float.intBitsToFloat(vals[index])))) != null) {
                vals[index] = Float.floatToIntBits(newValue.floatValue());
                return newValue;
            }
            this.removeAt(index);
            return null;
        }
        return this.computeNullKey(remappingFunction);
    }

    /*
     * Unable to fully structure code
     */
    Float computeNullKey(BiFunction<? super K, ? super Float, ? extends Float> remappingFunction) {
        block4: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            index = 0;
            cur = keys[0];
            if (cur == null) break block4;
            if (cur == MutableLHashSeparateKVObjFloatMapGO.FREE) ** GOTO lbl12
            capacityMask = keys.length - 1;
            while ((cur = keys[index = index - 1 & capacityMask]) != null) {
                if (cur != MutableLHashSeparateKVObjFloatMapGO.FREE) continue;
lbl12:
                // 2 sources

                if ((newValue = remappingFunction.apply(null, null)) != null) {
                    this.incrementModCount();
                    keys[index] = null;
                    vals[index] = Float.floatToIntBits(newValue.floatValue());
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(null, Float.valueOf(Float.intBitsToFloat(vals[index])))) != null) {
            vals[index] = Float.floatToIntBits(newValue.floatValue());
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public float compute(K key, ObjFloatToFloatFunction<? super K> remappingFunction) {
        block3: {
            block4: {
                if (key == null) break block3;
                if (remappingFunction == null) {
                    throw new NullPointerException();
                }
                keys = this.set;
                vals = this.values;
                capacityMask = keys.length - 1;
                index = LHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) & capacityMask;
                cur = keys[index];
                if (cur == key) break block4;
                if (cur == MutableLHashSeparateKVObjFloatMapGO.FREE) ** GOTO lbl15
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != MutableLHashSeparateKVObjFloatMapGO.FREE) {
                        if (!this.keyEquals(key, cur)) continue;
                        break;
                    }
lbl15:
                    // 3 sources

                    newValue = remappingFunction.applyAsFloat(key, this.defaultValue());
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = Float.floatToIntBits(newValue);
                    this.postInsertHook();
                    return newValue;
                }
            }
            newValue = remappingFunction.applyAsFloat(key, Float.intBitsToFloat(vals[index]));
            vals[index] = Float.floatToIntBits(newValue);
            return newValue;
        }
        return this.computeNullKey(remappingFunction);
    }

    /*
     * Unable to fully structure code
     */
    float computeNullKey(ObjFloatToFloatFunction<? super K> remappingFunction) {
        block2: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            index = 0;
            cur = keys[0];
            if (cur == null) break block2;
            if (cur == MutableLHashSeparateKVObjFloatMapGO.FREE) ** GOTO lbl12
            capacityMask = keys.length - 1;
            while ((cur = keys[index = index - 1 & capacityMask]) != null) {
                if (cur != MutableLHashSeparateKVObjFloatMapGO.FREE) continue;
lbl12:
                // 2 sources

                newValue = remappingFunction.applyAsFloat(null, this.defaultValue());
                this.incrementModCount();
                keys[index] = null;
                vals[index] = Float.floatToIntBits(newValue);
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsFloat(null, Float.intBitsToFloat(vals[index]));
        vals[index] = Float.floatToIntBits(newValue);
        return newValue;
    }

    @Override
    public Float computeIfAbsent(K key, Function<? super K, ? extends Float> mappingFunction) {
        if (key != null) {
            Float value;
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            int[] vals = this.values;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) & capacityMask;
            Object cur = keys[index];
            if (cur != FREE) {
                if (cur == key) {
                    return Float.valueOf(Float.intBitsToFloat(vals[index]));
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != FREE) {
                    if (cur != key && !this.keyEquals(key, cur)) continue;
                    return Float.valueOf(Float.intBitsToFloat(vals[index]));
                }
            }
            if ((value = mappingFunction.apply(key)) != null) {
                this.incrementModCount();
                keys[index] = key;
                vals[index] = Float.floatToIntBits(value.floatValue());
                this.postInsertHook();
                return value;
            }
            return null;
        }
        return this.computeIfAbsentNullKey(mappingFunction);
    }

    Float computeIfAbsentNullKey(Function<? super K, ? extends Float> mappingFunction) {
        Float value;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        Object[] keys = this.set;
        int[] vals = this.values;
        int index = 0;
        Object cur = keys[0];
        if (cur != FREE) {
            if (cur == null) {
                return Float.valueOf(Float.intBitsToFloat(vals[index]));
            }
            int capacityMask = keys.length - 1;
            while ((cur = keys[index = index - 1 & capacityMask]) != FREE) {
                if (cur != null) continue;
                return Float.valueOf(Float.intBitsToFloat(vals[index]));
            }
        }
        if ((value = mappingFunction.apply(null)) != null) {
            this.incrementModCount();
            keys[index] = null;
            vals[index] = Float.floatToIntBits(value.floatValue());
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public float computeIfAbsent(K key, ToFloatFunction<? super K> mappingFunction) {
        if (key != null) {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            int[] vals = this.values;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) & capacityMask;
            Object cur = keys[index];
            if (cur != FREE) {
                if (cur == key) {
                    return Float.intBitsToFloat(vals[index]);
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != FREE) {
                    if (cur != key && !this.keyEquals(key, cur)) continue;
                    return Float.intBitsToFloat(vals[index]);
                }
            }
            float value = mappingFunction.applyAsFloat(key);
            this.incrementModCount();
            keys[index] = key;
            vals[index] = Float.floatToIntBits(value);
            this.postInsertHook();
            return value;
        }
        return this.computeIfAbsentNullKey(mappingFunction);
    }

    float computeIfAbsentNullKey(ToFloatFunction<? super K> mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        Object[] keys = this.set;
        int[] vals = this.values;
        int index = 0;
        Object cur = keys[0];
        if (cur != FREE) {
            if (cur == null) {
                return Float.intBitsToFloat(vals[index]);
            }
            int capacityMask = keys.length - 1;
            while ((cur = keys[index = index - 1 & capacityMask]) != FREE) {
                if (cur != null) continue;
                return Float.intBitsToFloat(vals[index]);
            }
        }
        float value = mappingFunction.applyAsFloat(null);
        this.incrementModCount();
        keys[index] = null;
        vals[index] = Float.floatToIntBits(value);
        this.postInsertHook();
        return value;
    }

    @Override
    public Float computeIfPresent(K key, BiFunction<? super K, ? super Float, ? extends Float> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            int[] vals = this.values;
            Float newValue = remappingFunction.apply(key, Float.valueOf(Float.intBitsToFloat(vals[index])));
            if (newValue != null) {
                vals[index] = Float.floatToIntBits(newValue.floatValue());
                return newValue;
            }
            this.removeAt(index);
            return null;
        }
        return null;
    }

    public float computeIfPresent(K key, ObjFloatToFloatFunction<? super K> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            int[] vals = this.values;
            float newValue = remappingFunction.applyAsFloat(key, Float.intBitsToFloat(vals[index]));
            vals[index] = Float.floatToIntBits(newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Float merge(K key, Float value, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        block5: {
            block6: {
                if (key == null) break block5;
                if (value == null) {
                    throw new NullPointerException();
                }
                if (remappingFunction == null) {
                    throw new NullPointerException();
                }
                keys = this.set;
                vals = this.values;
                capacityMask = keys.length - 1;
                index = LHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) & capacityMask;
                cur = keys[index];
                if (cur == key) break block6;
                if (cur == MutableLHashSeparateKVObjFloatMapGO.FREE) ** GOTO lbl17
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != MutableLHashSeparateKVObjFloatMapGO.FREE) {
                        if (!this.keyEquals(key, cur)) continue;
                        break;
                    }
lbl17:
                    // 3 sources

                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = Float.floatToIntBits(value.floatValue());
                    this.postInsertHook();
                    return value;
                }
            }
            if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(vals[index])), value)) != null) {
                vals[index] = Float.floatToIntBits(newValue.floatValue());
                return newValue;
            }
            this.removeAt(index);
            return null;
        }
        return this.mergeNullKey(value, remappingFunction);
    }

    /*
     * Unable to fully structure code
     */
    Float mergeNullKey(Float value, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        block4: {
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            index = 0;
            cur = keys[0];
            if (cur == null) break block4;
            if (cur == MutableLHashSeparateKVObjFloatMapGO.FREE) ** GOTO lbl14
            capacityMask = keys.length - 1;
            while ((cur = keys[index = index - 1 & capacityMask]) != null) {
                if (cur != MutableLHashSeparateKVObjFloatMapGO.FREE) continue;
lbl14:
                // 2 sources

                this.incrementModCount();
                keys[index] = null;
                vals[index] = Float.floatToIntBits(value.floatValue());
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(vals[index])), value)) != null) {
            vals[index] = Float.floatToIntBits(newValue.floatValue());
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public float merge(K key, float value, FloatBinaryOperator remappingFunction) {
        block3: {
            block4: {
                if (key == null) break block3;
                if (remappingFunction == null) {
                    throw new NullPointerException();
                }
                keys = this.set;
                vals = this.values;
                capacityMask = keys.length - 1;
                index = LHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) & capacityMask;
                cur = keys[index];
                if (cur == key) break block4;
                if (cur == MutableLHashSeparateKVObjFloatMapGO.FREE) ** GOTO lbl15
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != MutableLHashSeparateKVObjFloatMapGO.FREE) {
                        if (!this.keyEquals(key, cur)) continue;
                        break;
                    }
lbl15:
                    // 3 sources

                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = Float.floatToIntBits(value);
                    this.postInsertHook();
                    return value;
                }
            }
            newValue = remappingFunction.applyAsFloat(Float.intBitsToFloat(vals[index]), value);
            vals[index] = Float.floatToIntBits(newValue);
            return newValue;
        }
        return this.mergeNullKey(value, remappingFunction);
    }

    /*
     * Unable to fully structure code
     */
    float mergeNullKey(float value, FloatBinaryOperator remappingFunction) {
        block2: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            index = 0;
            cur = keys[0];
            if (cur == null) break block2;
            if (cur == MutableLHashSeparateKVObjFloatMapGO.FREE) ** GOTO lbl12
            capacityMask = keys.length - 1;
            while ((cur = keys[index = index - 1 & capacityMask]) != null) {
                if (cur != MutableLHashSeparateKVObjFloatMapGO.FREE) continue;
lbl12:
                // 2 sources

                this.incrementModCount();
                keys[index] = null;
                vals[index] = Float.floatToIntBits(value);
                this.postInsertHook();
                return value;
            }
        }
        newValue = remappingFunction.applyAsFloat(Float.intBitsToFloat(vals[index]), value);
        vals[index] = Float.floatToIntBits(newValue);
        return newValue;
    }

    public float addValue(K key, float value) {
        int index = this.insert(key, Float.floatToIntBits(value));
        if (index < 0) {
            return value;
        }
        int[] vals = this.values;
        float newValue = Float.intBitsToFloat(vals[index]) + value;
        vals[index] = Float.floatToIntBits(newValue);
        return newValue;
    }

    public float addValue(K key, float addition, float defaultValue) {
        float value = defaultValue + addition;
        int index = this.insert(key, Float.floatToIntBits(value));
        if (index < 0) {
            return value;
        }
        int[] vals = this.values;
        float newValue = Float.intBitsToFloat(vals[index]) + addition;
        vals[index] = Float.floatToIntBits(newValue);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends Float> m) {
        CommonObjFloatMapOps.putAll(this, m);
    }

    @Override
    public Float replace(K key, Float value) {
        int index = this.index(key);
        if (index >= 0) {
            int[] vals = this.values;
            float oldValue = Float.intBitsToFloat(vals[index]);
            vals[index] = Float.floatToIntBits(value.floatValue());
            return Float.valueOf(oldValue);
        }
        return null;
    }

    @Override
    public float replace(K key, float value) {
        int index = this.index(key);
        if (index >= 0) {
            int[] vals = this.values;
            float oldValue = Float.intBitsToFloat(vals[index]);
            vals[index] = Float.floatToIntBits(value);
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(K key, Float oldValue, Float newValue) {
        return this.replace(key, oldValue.floatValue(), newValue.floatValue());
    }

    @Override
    public boolean replace(K key, float oldValue, float newValue) {
        int index = this.index(key);
        if (index >= 0) {
            int[] vals = this.values;
            if (vals[index] == Float.floatToIntBits(oldValue)) {
                vals[index] = Float.floatToIntBits(newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super Float, ? extends Float> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            vals[i] = Float.floatToIntBits(function.apply(key, Float.valueOf(Float.intBitsToFloat(vals[i]))).floatValue());
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ObjFloatToFloatFunction<? super K> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            vals[i] = Float.floatToIntBits(function.applyAsFloat(key, Float.intBitsToFloat(vals[i])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        Object keyToShift;
        int indexToRemove;
        Object[] keys = this.set;
        int[] vals = this.values;
        int capacityMask = keys.length - 1;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
            if ((LHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
        }
        keys[indexToRemove] = FREE;
        this.postRemoveHook();
    }

    @Override
    public Float remove(Object key) {
        if (key != null) {
            Object keyToShift;
            int indexToRemove;
            Object k = key;
            Object[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(k)) & capacityMask;
            Object cur = keys[index];
            if (cur != k) {
                if (cur == FREE) {
                    return null;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                    if (cur == FREE) {
                        return null;
                    }
                    if (!this.keyEquals(k, cur)) continue;
                }
            }
            int[] vals = this.values;
            float val = Float.intBitsToFloat(vals[index]);
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                if ((LHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
            }
            keys[indexToRemove] = FREE;
            this.postRemoveHook();
            return Float.valueOf(val);
        }
        return this.removeNullKey();
    }

    Float removeNullKey() {
        Object keyToShift;
        int indexToRemove;
        Object[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return null;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != null) {
                if (cur != FREE) continue;
                return null;
            }
        }
        int[] vals = this.values;
        float val = Float.intBitsToFloat(vals[index]);
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
            if ((LHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
        }
        keys[indexToRemove] = FREE;
        this.postRemoveHook();
        return Float.valueOf(val);
    }

    @Override
    public boolean justRemove(Object key) {
        if (key != null) {
            Object keyToShift;
            int indexToRemove;
            Object k = key;
            Object[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(k)) & capacityMask;
            Object cur = keys[index];
            if (cur != k) {
                if (cur == FREE) {
                    return false;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                    if (cur == FREE) {
                        return false;
                    }
                    if (!this.keyEquals(k, cur)) continue;
                }
            }
            int[] vals = this.values;
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                if ((LHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
            }
            keys[indexToRemove] = FREE;
            this.postRemoveHook();
            return true;
        }
        return this.justRemoveNullKey();
    }

    boolean justRemoveNullKey() {
        Object keyToShift;
        int indexToRemove;
        Object[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return false;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != null) {
                if (cur != FREE) continue;
                return false;
            }
        }
        int[] vals = this.values;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
            if ((LHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
        }
        keys[indexToRemove] = FREE;
        this.postRemoveHook();
        return true;
    }

    public float removeAsFloat(Object key) {
        if (key != null) {
            Object keyToShift;
            int indexToRemove;
            Object k = key;
            Object[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(k)) & capacityMask;
            Object cur = keys[index];
            if (cur != k) {
                if (cur == FREE) {
                    return this.defaultValue();
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                    if (cur == FREE) {
                        return this.defaultValue();
                    }
                    if (!this.keyEquals(k, cur)) continue;
                }
            }
            int[] vals = this.values;
            float val = Float.intBitsToFloat(vals[index]);
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                if ((LHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
            }
            keys[indexToRemove] = FREE;
            this.postRemoveHook();
            return val;
        }
        return this.removeAsFloatNullKey();
    }

    float removeAsFloatNullKey() {
        Object keyToShift;
        int indexToRemove;
        Object[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return this.defaultValue();
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != null) {
                if (cur != FREE) continue;
                return this.defaultValue();
            }
        }
        int[] vals = this.values;
        float val = Float.intBitsToFloat(vals[index]);
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
            if ((LHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
        }
        keys[indexToRemove] = FREE;
        this.postRemoveHook();
        return val;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(key, ((Float)value).floatValue());
    }

    public boolean remove(Object key, float value) {
        if (key != null) {
            int[] vals;
            Object k = key;
            Object[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(k)) & capacityMask;
            Object cur = keys[index];
            if (cur != k) {
                if (cur == FREE) {
                    return false;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                    if (cur == FREE) {
                        return false;
                    }
                    if (!this.keyEquals(k, cur)) continue;
                }
            }
            if ((vals = this.values)[index] == Float.floatToIntBits(value)) {
                Object keyToShift;
                int indexToRemove;
                this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                    if ((LHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                }
                keys[indexToRemove] = FREE;
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return this.removeEntryNullKey(value);
    }

    boolean removeEntryNullKey(float value) {
        int[] vals;
        Object[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return false;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != null) {
                if (cur != FREE) continue;
                return false;
            }
        }
        if ((vals = this.values)[index] == Float.floatToIntBits(value)) {
            Object keyToShift;
            int indexToRemove;
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                if ((LHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
            }
            keys[indexToRemove] = FREE;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIf(ObjFloatPredicate<? super K> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                Object key = keys[i];
                if (key == FREE || !filter.test(key, Float.intBitsToFloat(vals[i]))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    Object keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                        if ((LHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = REMOVED;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                    }
                    keys[indexToRemove] = FREE;
                } else {
                    keys[i] = REMOVED;
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(Predicate<? super K> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                Object key = keys[i];
                if (key == FREE || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    Object keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                        if ((LHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = REMOVED;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                    }
                    keys[indexToRemove] = FREE;
                } else {
                    keys[i] = REMOVED;
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeAll(@Nonnull HashObjSet<K> thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                Object key = keys[i];
                if (key == FREE || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    Object keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                        if ((LHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = REMOVED;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                    }
                    keys[indexToRemove] = FREE;
                } else {
                    keys[i] = REMOVED;
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull HashObjSet<K> thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block12: {
                Object key = keys[i];
                if (key == FREE || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    Object keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                        if ((LHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = REMOVED;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                    }
                    keys[indexToRemove] = FREE;
                } else {
                    keys[i] = REMOVED;
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    void closeDelayedRemoved(int firstDelayedRemoved) {
        Object[] keys = this.set;
        int[] vals = this.values;
        int capacityMask = keys.length - 1;
        for (int i = firstDelayedRemoved; i >= 0; --i) {
            Object keyToShift;
            int indexToRemove;
            if (keys[i] != REMOVED) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                if (keyToShift != REMOVED && (LHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
            }
            keys[indexToRemove] = FREE;
        }
    }

    @Override
    public ObjIterator<K> iterator() {
        int mc = this.modCount();
        return new NoRemovedKeyIterator(mc);
    }

    @Override
    public ObjCursor<K> setCursor() {
        int mc = this.modCount();
        return new NoRemovedKeyCursor(mc);
    }

    class NoRemovedMapCursor
    implements ObjFloatCursor<K> {
        K[] keys;
        int[] vals;
        final int capacityMask;
        int expectedModCount;
        int index;
        Object curKey;
        int curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            Object[] keys = this.keys;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ObjFloatConsumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            int[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key, Float.intBitsToFloat(vals[i]));
            }
            if (index != this.index || mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public K key() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public float value() {
            if (this.curKey != ObjHash.FREE) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValue(float value) {
            if (this.curKey == ObjHash.FREE) throw new IllegalStateException();
            if (this.expectedModCount != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.vals[this.index] = Float.floatToIntBits(value);
            if (this.vals == MutableLHashSeparateKVObjFloatMapGO.this.values) return;
            MutableLHashSeparateKVObjFloatMapGO.this.values[this.index] = Float.floatToIntBits(value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            Object curKey = this.curKey;
            if (curKey == ObjHash.FREE) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = ObjHash.FREE;
            int index = this.index;
            K[] keys = this.keys;
            int[] vals = this.vals;
            if (keys == MutableLHashSeparateKVObjFloatMapGO.this.set) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVObjFloatMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                    if ((LHash.SeparateKVObjKeyMixing.mix(MutableLHashSeparateKVObjFloatMapGO.this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        keys[indexToRemove] = ObjHash.FREE;
                                    }
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                }
                keys[indexToRemove] = ObjHash.FREE;
                MutableLHashSeparateKVObjFloatMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVObjFloatMapGO.this.justRemove(curKey);
                keys[index] = null;
            }
        }
    }

    class NoRemovedValueCursor
    implements FloatCursor {
        K[] keys;
        int[] vals;
        final int capacityMask;
        int expectedModCount;
        int index;
        Object curKey;
        int curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            Object[] keys = this.keys;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            int[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (index != this.index || mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public float elem() {
            if (this.curKey != ObjHash.FREE) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            Object curKey = this.curKey;
            if (curKey == ObjHash.FREE) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = ObjHash.FREE;
            int index = this.index;
            K[] keys = this.keys;
            int[] vals = this.vals;
            if (keys == MutableLHashSeparateKVObjFloatMapGO.this.set) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVObjFloatMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                    if ((LHash.SeparateKVObjKeyMixing.mix(MutableLHashSeparateKVObjFloatMapGO.this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        keys[indexToRemove] = ObjHash.FREE;
                                    }
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                }
                keys[indexToRemove] = ObjHash.FREE;
                MutableLHashSeparateKVObjFloatMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVObjFloatMapGO.this.justRemove(curKey);
                keys[index] = null;
            }
        }
    }

    class NoRemovedValueIterator
    implements FloatIterator {
        K[] keys;
        int[] vals;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        float next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            Object[] keys = this.keys;
            this.capacityMask = keys.length - 1;
            this.vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == ObjHash.FREE) continue;
                this.next = Float.intBitsToFloat(vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public float nextFloat() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                    this.index = nextI;
                    K[] keys = this.keys;
                    float prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == ObjHash.FREE) continue;
                        this.next = Float.intBitsToFloat(this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Float> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            int[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat(vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(FloatConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            int[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Float next() {
            return Float.valueOf(this.nextFloat());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            K[] keys = this.keys;
            int[] vals = this.vals;
            if (keys == MutableLHashSeparateKVObjFloatMapGO.this.set) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVObjFloatMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                    if ((LHash.SeparateKVObjKeyMixing.mix(MutableLHashSeparateKVObjFloatMapGO.this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        keys[indexToRemove] = ObjHash.FREE;
                                    }
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = Float.intBitsToFloat(vals[indexToShift]);
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                }
                keys[indexToRemove] = ObjHash.FREE;
                MutableLHashSeparateKVObjFloatMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVObjFloatMapGO.this.justRemove(keys[index]);
                keys[index] = null;
            }
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, Float>> {
        K[] keys;
        int[] vals;
        final int capacityMask;
        int expectedModCount;
        int index;
        Object curKey;
        int curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            Object[] keys = this.keys;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            int[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(new MutableEntry2(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public Map.Entry<K, Float> elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return new MutableEntry2(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            Object curKey = this.curKey;
            if (curKey == ObjHash.FREE) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = ObjHash.FREE;
            int index = this.index;
            K[] keys = this.keys;
            int[] vals = this.vals;
            if (keys == MutableLHashSeparateKVObjFloatMapGO.this.set) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVObjFloatMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                    if ((LHash.SeparateKVObjKeyMixing.mix(MutableLHashSeparateKVObjFloatMapGO.this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        keys[indexToRemove] = ObjHash.FREE;
                                    }
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                }
                keys[indexToRemove] = ObjHash.FREE;
                MutableLHashSeparateKVObjFloatMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVObjFloatMapGO.this.justRemove(curKey);
                keys[index] = null;
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, K key, int value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(int newValue) {
                if (NoRemovedEntryCursor.this.vals == MutableLHashSeparateKVObjFloatMapGO.this.values) {
                    NoRemovedEntryCursor.this.vals[NoRemovedEntryCursor.this.index] = newValue;
                } else {
                    MutableLHashSeparateKVObjFloatMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, Float>> {
        K[] keys;
        int[] vals;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            Object[] keys = this.keys;
            this.capacityMask = keys.length - 1;
            this.vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE) continue;
                this.next = new MutableEntry2(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, Float>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            int[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(new MutableEntry2(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, Float> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                    this.index = nextI;
                    K[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        Object key = keys[nextI];
                        if (key == ObjHash.FREE) continue;
                        this.next = new MutableEntry2(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            K[] keys = this.keys;
            int[] vals = this.vals;
            if (keys == MutableLHashSeparateKVObjFloatMapGO.this.set) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVObjFloatMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                    if ((LHash.SeparateKVObjKeyMixing.mix(MutableLHashSeparateKVObjFloatMapGO.this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        keys[indexToRemove] = ObjHash.FREE;
                                    }
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = new MutableEntry2(MutableLHashSeparateKVObjFloatMapGO.this.modCount(), indexToShift, keyToShift, vals[indexToShift]);
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                }
                keys[indexToRemove] = ObjHash.FREE;
                MutableLHashSeparateKVObjFloatMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVObjFloatMapGO.this.justRemove(keys[index]);
                keys[index] = null;
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, K key, int value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(int newValue) {
                if (NoRemovedEntryIterator.this.vals == MutableLHashSeparateKVObjFloatMapGO.this.values) {
                    NoRemovedEntryIterator.this.vals[NoRemovedEntryIterator.this.index] = newValue;
                } else {
                    MutableLHashSeparateKVObjFloatMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class ValueView
    extends AbstractFloatValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return MutableLHashSeparateKVObjFloatMapGO.this.size();
        }

        public boolean shrink() {
            return MutableLHashSeparateKVObjFloatMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableLHashSeparateKVObjFloatMapGO.this.containsValue(o);
        }

        public boolean contains(float v) {
            return MutableLHashSeparateKVObjFloatMapGO.this.containsValue(v);
        }

        @Override
        public boolean contains(int bits) {
            return MutableLHashSeparateKVObjFloatMapGO.this.containsValue(bits);
        }

        @Override
        public void forEach(Consumer<? super Float> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat(vals[i])));
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(FloatPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || predicate.test(Float.intBitsToFloat(vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.allContainingIn((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || c.contains(Float.intBitsToFloat(vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.reverseAddAllTo((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= c.add(Float.intBitsToFloat(vals[i]));
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(FloatSet s) {
            if (s instanceof InternalFloatCollectionOps) {
                return this.reverseRemoveAllFrom((InternalFloatCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= s.removeFloat(Float.intBitsToFloat(vals[i]));
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalFloatCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= s.removeFloat(vals[i]);
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public FloatIterator iterator() {
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public FloatCursor cursor() {
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                result[resultIndex++] = Float.valueOf(Float.intBitsToFloat(vals[i]));
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                a[resultIndex++] = Float.valueOf(Float.intBitsToFloat(vals[i]));
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public float[] toFloatArray() {
            int size = this.size();
            float[] result = new float[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                result[resultIndex++] = Float.intBitsToFloat(vals[i]);
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public float[] toArray(float[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new float[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0f;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                a[resultIndex++] = Float.intBitsToFloat(vals[i]);
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0f;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                sb.append(' ').append(Float.intBitsToFloat(vals[i])).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeFloat(((Float)o).floatValue());
        }

        public boolean removeFloat(float v) {
            return MutableLHashSeparateKVObjFloatMapGO.this.removeValue(v);
        }

        @Override
        public boolean removeFloat(int bits) {
            return MutableLHashSeparateKVObjFloatMapGO.this.removeValue(bits);
        }

        @Override
        public void clear() {
            MutableLHashSeparateKVObjFloatMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Float> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    if (keys[i] == ObjHash.FREE || !filter.test(Float.valueOf(Float.intBitsToFloat(vals[i])))) continue;
                    MutableLHashSeparateKVObjFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            if ((LHash.SeparateKVObjKeyMixing.mix(MutableLHashSeparateKVObjFloatMapGO.this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                MutableLHashSeparateKVObjFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(FloatPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    if (keys[i] == ObjHash.FREE || !filter.test(Float.intBitsToFloat(vals[i]))) continue;
                    MutableLHashSeparateKVObjFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            if ((LHash.SeparateKVObjKeyMixing.mix(MutableLHashSeparateKVObjFloatMapGO.this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                MutableLHashSeparateKVObjFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof FloatCollection) {
                return this.removeAll((FloatCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    if (keys[i] == ObjHash.FREE || !c.contains(Float.valueOf(Float.intBitsToFloat(vals[i])))) continue;
                    MutableLHashSeparateKVObjFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            if ((LHash.SeparateKVObjKeyMixing.mix(MutableLHashSeparateKVObjFloatMapGO.this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                MutableLHashSeparateKVObjFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.removeAll((InternalFloatCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    if (keys[i] == ObjHash.FREE || !c.contains(Float.intBitsToFloat(vals[i]))) continue;
                    MutableLHashSeparateKVObjFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            if ((LHash.SeparateKVObjKeyMixing.mix(MutableLHashSeparateKVObjFloatMapGO.this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                MutableLHashSeparateKVObjFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(InternalFloatCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    if (keys[i] == ObjHash.FREE || !c.contains(vals[i])) continue;
                    MutableLHashSeparateKVObjFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            if ((LHash.SeparateKVObjKeyMixing.mix(MutableLHashSeparateKVObjFloatMapGO.this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                MutableLHashSeparateKVObjFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof FloatCollection) {
                return this.retainAll((FloatCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block13: {
                    if (keys[i] == ObjHash.FREE || c.contains(Float.valueOf(Float.intBitsToFloat(vals[i])))) continue;
                    MutableLHashSeparateKVObjFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            if ((LHash.SeparateKVObjKeyMixing.mix(MutableLHashSeparateKVObjFloatMapGO.this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                MutableLHashSeparateKVObjFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.retainAll((InternalFloatCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block13: {
                    if (keys[i] == ObjHash.FREE || c.contains(Float.intBitsToFloat(vals[i]))) continue;
                    MutableLHashSeparateKVObjFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            if ((LHash.SeparateKVObjKeyMixing.mix(MutableLHashSeparateKVObjFloatMapGO.this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                MutableLHashSeparateKVObjFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(InternalFloatCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                    MutableLHashSeparateKVObjFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            if ((LHash.SeparateKVObjKeyMixing.mix(MutableLHashSeparateKVObjFloatMapGO.this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                MutableLHashSeparateKVObjFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends ObjFloatEntry {
        private K key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(K key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ObjFloatEntry {
        int modCount;
        private final int index;
        final K key;
        private int value;

        MutableEntry(int modCount, int index, K key, int value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }

        @Override
        public Float setValue(Float newValue) {
            int unwrappedNewValue;
            if (this.modCount != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            float oldValue = Float.intBitsToFloat(this.value);
            this.value = unwrappedNewValue = Float.floatToIntBits(newValue.floatValue());
            this.updateValueInTable(unwrappedNewValue);
            return Float.valueOf(oldValue);
        }

        void updateValueInTable(int newValue) {
            MutableLHashSeparateKVObjFloatMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class ObjFloatEntry
    extends AbstractEntry<K, Float> {
        ObjFloatEntry() {
        }

        abstract K key();

        @Override
        public final K getKey() {
            return this.key();
        }

        abstract int value();

        @Override
        public final Float getValue() {
            return Float.valueOf(Float.intBitsToFloat(this.value()));
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                Object k2 = e2.getKey();
                int v2 = Float.floatToIntBits(((Float)e2.getValue()).floatValue());
                return MutableLHashSeparateKVObjFloatMapGO.this.nullableKeyEquals(this.key(), k2) && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return MutableLHashSeparateKVObjFloatMapGO.this.nullableKeyHashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<K, Float>>
    implements HashObjSet<Map.Entry<K, Float>>,
    InternalObjCollectionOps<Map.Entry<K, Float>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<K, Float>> equivalence() {
            return Equivalence.entryEquivalence(MutableLHashSeparateKVObjFloatMapGO.this.keyEquivalence(), null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableLHashSeparateKVObjFloatMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableLHashSeparateKVObjFloatMapGO.this.size();
        }

        public double currentLoad() {
            return MutableLHashSeparateKVObjFloatMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableLHashSeparateKVObjFloatMapGO.this.containsEntry(e.getKey(), ((Float)e.getValue()).floatValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<K, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<K, Float>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || predicate.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<K, Float>> iterator() {
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<K, Float>> cursor() {
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<K, Float>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableLHashSeparateKVObjFloatMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Collection)");
                sb.append('=');
                sb.append(Float.intBitsToFloat(vals[i]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableLHashSeparateKVObjFloatMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                float value = ((Float)e.getValue()).floatValue();
                return MutableLHashSeparateKVObjFloatMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<K, Float>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || !filter.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                    MutableLHashSeparateKVObjFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            if ((LHash.SeparateKVObjKeyMixing.mix(MutableLHashSeparateKVObjFloatMapGO.this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                MutableLHashSeparateKVObjFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block13: {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || !c.contains(e.with(key, vals[i]))) continue;
                    MutableLHashSeparateKVObjFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            if ((LHash.SeparateKVObjKeyMixing.mix(MutableLHashSeparateKVObjFloatMapGO.this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                MutableLHashSeparateKVObjFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = MutableLHashSeparateKVObjFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            int[] vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || c.contains(e.with(key, vals[i]))) continue;
                    MutableLHashSeparateKVObjFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        Object keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                            if ((LHash.SeparateKVObjKeyMixing.mix(MutableLHashSeparateKVObjFloatMapGO.this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = ObjHash.REMOVED;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                        }
                        keys[indexToRemove] = ObjHash.FREE;
                    } else {
                        keys[i] = ObjHash.REMOVED;
                    }
                }
                MutableLHashSeparateKVObjFloatMapGO.this.postRemoveHook();
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVObjFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableLHashSeparateKVObjFloatMapGO.this.clear();
        }
    }

    class NoRemovedKeyCursor
    extends MutableSeparateKVObjLHashGO.NoRemovedCursor {
        int[] vals;

        private NoRemovedKeyCursor(int mc) {
            super(MutableLHashSeparateKVObjFloatMapGO.this, mc);
            this.vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            Object curKey = this.curKey;
            if (curKey == ObjHash.FREE) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = ObjHash.FREE;
            int index = this.index;
            Object[] keys = this.keys;
            int[] vals = this.vals;
            if (keys == MutableLHashSeparateKVObjFloatMapGO.this.set) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVObjFloatMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                    if ((LHash.SeparateKVObjKeyMixing.mix(MutableLHashSeparateKVObjFloatMapGO.this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        keys[indexToRemove] = ObjHash.FREE;
                                    }
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                }
                keys[indexToRemove] = ObjHash.FREE;
                MutableLHashSeparateKVObjFloatMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVObjFloatMapGO.this.justRemove(curKey);
                keys[index] = null;
            }
        }
    }

    class NoRemovedKeyIterator
    extends MutableSeparateKVObjLHashGO.NoRemovedIterator {
        int[] vals;

        private NoRemovedKeyIterator(int mc) {
            super(MutableLHashSeparateKVObjFloatMapGO.this, mc);
            this.vals = MutableLHashSeparateKVObjFloatMapGO.this.values;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVObjFloatMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            Object[] keys = this.keys;
            int[] vals = this.vals;
            if (keys == MutableLHashSeparateKVObjFloatMapGO.this.set) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVObjFloatMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                    if ((LHash.SeparateKVObjKeyMixing.mix(MutableLHashSeparateKVObjFloatMapGO.this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        keys[indexToRemove] = ObjHash.FREE;
                                    }
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = keyToShift;
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                }
                keys[indexToRemove] = ObjHash.FREE;
                MutableLHashSeparateKVObjFloatMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVObjFloatMapGO.this.justRemove(keys[index]);
                keys[index] = null;
            }
        }
    }
}

