/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.collect.ByteCollection;
import net.openhft.collect.ByteCursor;
import net.openhft.collect.ByteIterator;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.MutableParallelKVByteQHashSO;
import net.openhft.collect.set.ByteSet;
import net.openhft.collect.set.hash.HashByteSet;
import net.openhft.function.ByteConsumer;
import net.openhft.function.BytePredicate;

public abstract class MutableParallelKVByteQHashGO
extends MutableParallelKVByteQHashSO {
    @Override
    @Nonnull
    public char[] table() {
        return this.table;
    }

    @Override
    public int capacity() {
        return this.table.length;
    }

    public void forEach(Consumer<? super Byte> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free) continue;
                action.accept((Byte)key);
            }
        } else {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || key == removed) continue;
                action.accept((Byte)key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(ByteConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free) continue;
                action.accept(key);
            }
        } else {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || key == removed) continue;
                action.accept(key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(BytePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || predicate.test(key)) continue;
                terminated = true;
                break;
            }
        } else {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || key == removed || predicate.test(key)) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    public boolean allContainingIn(ByteCollection c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || c.contains(key)) continue;
                containsAll = false;
                break;
            }
        } else {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || key == removed || c.contains(key)) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(ByteCollection c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free) continue;
                changed |= c.add(key);
            }
        } else {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || key == removed) continue;
                changed |= c.add(key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(ByteSet s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free) continue;
                changed |= s.removeByte(key);
            }
        } else {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || key == removed) continue;
                changed |= s.removeByte(key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public ByteIterator iterator() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedIterator(mc);
        }
        return new NoRemovedIterator(mc);
    }

    public ByteCursor setCursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedCursor(mc);
        }
        return new NoRemovedCursor(mc);
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free) continue;
                result[resultIndex++] = key;
            }
        } else {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || key == removed) continue;
                result[resultIndex++] = key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free) continue;
                a[resultIndex++] = key;
            }
        } else {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || key == removed) continue;
                a[resultIndex++] = key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    @Nonnull
    public byte[] toByteArray() {
        int size = this.size();
        byte[] result = new byte[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free) continue;
                result[resultIndex++] = key;
            }
        } else {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || key == removed) continue;
                result[resultIndex++] = key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public byte[] toArray(byte[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new byte[size];
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = 0;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free) continue;
                a[resultIndex++] = key;
            }
        } else {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || key == removed) continue;
                a[resultIndex++] = key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = 0;
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free) continue;
                hashCode += key;
            }
        } else {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || key == removed) continue;
                hashCode += key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free) continue;
                sb.append(' ').append(key).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || key == removed) continue;
                sb.append(' ').append(key).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(byte var1);

    public boolean removeIf(Predicate<? super Byte> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || !filter.test((Byte)key)) continue;
                this.incrementModCount();
                ++mc;
                U.putByte(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || key == removed || !filter.test((Byte)key)) continue;
                this.incrementModCount();
                ++mc;
                U.putByte(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean removeIf(BytePredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putByte(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || key == removed || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putByte(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashByteSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putByte(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || key == removed || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putByte(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashByteSet thisC, @Nonnull ByteCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putByte(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || key == removed || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putByte(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean retainAll(@Nonnull HashByteSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof ByteCollection) {
            return this.retainAll(thisC, (ByteCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putByte(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || key == removed || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putByte(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashByteSet thisC, @Nonnull ByteCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putByte(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            long off = (long)tab.length << 1;
            while ((off -= 2L) >= 0L) {
                byte key = U.getByte(tab, base + off);
                if (key == free || key == removed || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putByte(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedCursor
    implements ByteCursor {
        final char[] tab;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;

        SomeRemovedCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVByteQHashGO.this.table;
            this.index = this.tab.length;
            byte free = this.free = MutableParallelKVByteQHashGO.this.freeValue;
            this.removed = MutableParallelKVByteQHashGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            byte removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || key == removed) continue;
                action.accept(key);
            }
            if (index != this.index || mc != MutableParallelKVByteQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableParallelKVByteQHashGO.this.modCount()) {
                char[] tab = this.tab;
                byte free = this.free;
                byte removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableParallelKVByteQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableParallelKVByteQHashGO.this.incrementModCount();
            UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)this.index << 1), this.removed);
            MutableParallelKVByteQHashGO.this.postRemoveHook();
        }
    }

    class SomeRemovedIterator
    implements ByteIterator {
        final char[] tab;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        byte next;

        SomeRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVByteQHashGO.this.table;
            char[] tab = MutableParallelKVByteQHashGO.this.table;
            byte free = this.free = MutableParallelKVByteQHashGO.this.freeValue;
            byte removed = this.removed = MutableParallelKVByteQHashGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                char entry = tab[nextI];
                byte key = (byte)entry;
                if (key == free || key == removed) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableParallelKVByteQHashGO.this.modCount()) {
                    this.index = nextI;
                    char[] tab = this.tab;
                    byte free = this.free;
                    byte removed = this.removed;
                    byte prev = this.next;
                    while (--nextI >= 0) {
                        char entry = tab[nextI];
                        byte key = (byte)entry;
                        if (key == free || key == removed) continue;
                        this.next = key;
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            byte removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || key == removed) continue;
                action.accept((Byte)key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVByteQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            byte removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || key == removed) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVByteQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableParallelKVByteQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableParallelKVByteQHashGO.this.incrementModCount();
            UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)index << 1), this.removed);
            MutableParallelKVByteQHashGO.this.postRemoveHook();
        }
    }

    class NoRemovedCursor
    implements ByteCursor {
        final char[] tab;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;

        NoRemovedCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVByteQHashGO.this.table;
            this.index = this.tab.length;
            byte free = this.free = MutableParallelKVByteQHashGO.this.freeValue;
            this.removed = MutableParallelKVByteQHashGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept(key);
            }
            if (index != this.index || mc != MutableParallelKVByteQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableParallelKVByteQHashGO.this.modCount()) {
                char[] tab = this.tab;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableParallelKVByteQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableParallelKVByteQHashGO.this.incrementModCount();
            UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)this.index << 1), this.removed);
            MutableParallelKVByteQHashGO.this.postRemoveHook();
        }
    }

    class NoRemovedIterator
    implements ByteIterator {
        final char[] tab;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        byte next;

        NoRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVByteQHashGO.this.table;
            char[] tab = MutableParallelKVByteQHashGO.this.table;
            byte free = this.free = MutableParallelKVByteQHashGO.this.freeValue;
            this.removed = MutableParallelKVByteQHashGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                char entry = tab[nextI];
                byte key = (byte)entry;
                if (key == free) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableParallelKVByteQHashGO.this.modCount()) {
                    this.index = nextI;
                    char[] tab = this.tab;
                    byte free = this.free;
                    byte prev = this.next;
                    while (--nextI >= 0) {
                        char entry = tab[nextI];
                        byte key = (byte)entry;
                        if (key == free) continue;
                        this.next = key;
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept((Byte)key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVByteQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVByteQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableParallelKVByteQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableParallelKVByteQHashGO.this.incrementModCount();
            UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)index << 1), this.removed);
            MutableParallelKVByteQHashGO.this.postRemoveHook();
        }
    }
}

