/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.openhft.collect.hash.HashOverflowException;
import net.openhft.collect.impl.ByteArrays;
import net.openhft.collect.impl.PrimitiveConstants;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.HashConfigWrapper;
import net.openhft.collect.impl.hash.MutableQHash;
import net.openhft.collect.impl.hash.ParallelKVByteQHash;
import net.openhft.collect.impl.hash.QHash;

public abstract class MutableParallelKVByteQHashSO
extends MutableQHash
implements ParallelKVByteQHash,
PrimitiveConstants,
UnsafeConstants {
    byte freeValue;
    byte removedValue;
    char[] table;

    void copy(ParallelKVByteQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        if (hash.supportRemoved()) {
            this.removedValue = hash.removedValue();
        }
        this.table = (char[])hash.table().clone();
        if (!hash.supportRemoved()) {
            this.removedValue = this.freeValue;
            this.removedValue = this.findNewFreeOrRemoved();
        }
    }

    void move(ParallelKVByteQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        if (hash.supportRemoved()) {
            this.removedValue = hash.removedValue();
        }
        this.table = hash.table();
        if (!hash.supportRemoved()) {
            this.removedValue = this.freeValue;
            this.removedValue = this.findNewFreeOrRemoved();
        }
    }

    final void init(HashConfigWrapper configWrapper, int size, byte freeValue, byte removedValue) {
        this.freeValue = freeValue;
        this.removedValue = removedValue;
        super.init(configWrapper, size);
    }

    @Override
    public byte freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return true;
    }

    @Override
    public byte removedValue() {
        return this.removedValue;
    }

    public boolean contains(Object key) {
        return this.contains((Byte)key);
    }

    public boolean contains(byte key) {
        return this.index(key) >= 0;
    }

    int index(byte key) {
        byte free = this.freeValue;
        if (key != free && key != this.removedValue) {
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix(key) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (byte)(entry = tab[bIndex])) == key) {
                    return bIndex;
                }
                if (cur == free) {
                    return -1;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (byte)(entry = tab[fIndex])) == key) {
                    return fIndex;
                }
                if (cur == free) {
                    return -1;
                }
                step += 2;
            }
        }
        return -1;
    }

    private byte findNewFreeOrRemoved() {
        byte newFree;
        block6: {
            int mc = this.modCount();
            int size = this.size();
            if (size >= 254) {
                throw new HashOverflowException();
            }
            byte free = this.freeValue;
            byte removed = this.removedValue;
            char[] tab = this.table;
            int capacity = this.capacity();
            ThreadLocalRandom random = ThreadLocalRandom.current();
            if (size > 192) {
                int nf = ((Random)random).nextInt(256) * 97;
                for (int i = 0; i < 256; ++i) {
                    newFree = (byte)(nf += 97);
                    if (newFree == free || newFree == removed || this.index(newFree) >= 0) {
                        continue;
                    }
                    break block6;
                }
                if (mc != this.modCount()) {
                    throw new ConcurrentModificationException();
                }
                throw new AssertionError((Object)"Impossible state");
            }
            while ((newFree = (byte)((Random)random).nextInt()) == free || newFree == removed || this.index(newFree) >= 0) {
            }
        }
        return newFree;
    }

    byte changeFree() {
        int mc = this.modCount();
        byte newFree = this.findNewFreeOrRemoved();
        this.incrementModCount();
        ByteArrays.replaceAllKeys(this.table, this.freeValue, newFree);
        this.freeValue = newFree;
        if (++mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newFree;
    }

    byte changeRemoved() {
        int mc = this.modCount();
        byte newRemoved = this.findNewFreeOrRemoved();
        this.incrementModCount();
        ++mc;
        if (!this.noRemoved()) {
            ByteArrays.replaceAllKeys(this.table, this.removedValue, newRemoved);
        }
        this.removedValue = newRemoved;
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newRemoved;
    }

    @Override
    void allocateArrays(int capacity) {
        this.table = new char[capacity];
        if (this.freeValue != 0) {
            ByteArrays.fillKeys(this.table, this.freeValue);
        }
    }

    @Override
    public void clear() {
        super.clear();
        ByteArrays.fillKeys(this.table, this.freeValue);
    }

    @Override
    void removeAt(int index) {
        U.putByte(this.table, CHAR_BASE + BYTE_KEY_OFFSET + ((long)index << 1), this.removedValue);
    }
}

