/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.collect.CharCollection;
import net.openhft.collect.CharCursor;
import net.openhft.collect.CharIterator;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.MutableParallelKVCharLHashSO;
import net.openhft.collect.set.CharSet;
import net.openhft.collect.set.hash.HashCharSet;
import net.openhft.function.CharConsumer;
import net.openhft.function.CharPredicate;

public abstract class MutableParallelKVCharLHashGO
extends MutableParallelKVCharLHashSO {
    @Override
    @Nonnull
    public int[] table() {
        return this.table;
    }

    @Override
    public int capacity() {
        return this.table.length;
    }

    public void forEach(Consumer<? super Character> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free) continue;
            action.accept(Character.valueOf(key));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(CharConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free) continue;
            action.accept(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(CharPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free || predicate.test(key)) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    public boolean allContainingIn(CharCollection c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free || c.contains(key)) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(CharCollection c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free) continue;
            changed |= c.add(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(CharSet s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free) continue;
            changed |= s.removeChar(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public CharIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedIterator(mc);
    }

    public CharCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedCursor(mc);
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free) continue;
            result[resultIndex++] = Character.valueOf(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free) continue;
            a[resultIndex++] = Character.valueOf(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    @Nonnull
    public char[] toCharArray() {
        int size = this.size();
        char[] result = new char[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free) continue;
            result[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public char[] toArray(char[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new char[size];
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = '\u0000';
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free) continue;
            a[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = '\u0000';
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free) continue;
            hashCode += key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            char key = U.getChar(tab, base + off);
            if (key == free) continue;
            sb.append(' ').append(key).append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(char var1);

    public boolean removeIf(Predicate<? super Character> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || !filter.test(Character.valueOf(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), keyToShift);
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                } else {
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean removeIf(CharPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), keyToShift);
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                } else {
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashCharSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || !c.contains(Character.valueOf(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), keyToShift);
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                } else {
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashCharSet thisC, @Nonnull CharCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), keyToShift);
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                } else {
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean retainAll(@Nonnull HashCharSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof CharCollection) {
            return this.retainAll(thisC, (CharCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = tab.length - 1; i >= 0; --i) {
            block13: {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || c.contains(Character.valueOf(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                break block13;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), keyToShift);
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                } else {
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashCharSet thisC, @Nonnull CharCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = tab.length - 1; i >= 0; --i) {
            block12: {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = U.getChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2));
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), keyToShift);
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                } else {
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), delayedRemoved);
                }
            }
            this.postRemoveHook();
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    void closeDelayedRemoved(int firstDelayedRemoved, char delayedRemoved) {
        char free = this.freeValue;
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        for (int i = firstDelayedRemoved; i >= 0; --i) {
            char keyToShift;
            int indexToRemove;
            int entry = tab[i];
            if ((char)entry != delayedRemoved) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 1;
            while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                if (keyToShift != delayedRemoved && (LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), keyToShift);
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + i) continue;
                throw new ConcurrentModificationException();
            }
            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
        }
    }

    class NoRemovedCursor
    implements CharCursor {
        int[] tab;
        final char free;
        final int capacityMask;
        int expectedModCount;
        int index;
        char curKey;

        NoRemovedCursor(int mc) {
            char free;
            this.expectedModCount = mc;
            this.tab = MutableParallelKVCharLHashGO.this.table;
            int[] tab = MutableParallelKVCharLHashGO.this.table;
            this.capacityMask = tab.length - 1;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableParallelKVCharLHashGO.this.freeValue);
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(key);
            }
            if (index != this.index || mc != MutableParallelKVCharLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableParallelKVCharLHashGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            char curKey = this.curKey;
            char free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableParallelKVCharLHashGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            int[] tab = this.tab;
            if (tab == MutableParallelKVCharLHashGO.this.table) {
                int entry;
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableParallelKVCharLHashGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), keyToShift);
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), free);
                MutableParallelKVCharLHashGO.this.postRemoveHook();
                return;
            } else {
                MutableParallelKVCharLHashGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedIterator
    implements CharIterator {
        int[] tab;
        final char free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        char next;

        NoRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVCharLHashGO.this.table;
            int[] tab = MutableParallelKVCharLHashGO.this.table;
            this.capacityMask = tab.length - 1;
            char free = this.free = MutableParallelKVCharLHashGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                char key = (char)entry;
                if (key == free) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableParallelKVCharLHashGO.this.modCount()) {
                    this.index = nextI;
                    int[] tab = this.tab;
                    char free = this.free;
                    char prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        char key = (char)entry;
                        if (key == free) continue;
                        this.next = key;
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(Character.valueOf(key));
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVCharLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVCharLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableParallelKVCharLHashGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            int[] tab = this.tab;
            if (tab == MutableParallelKVCharLHashGO.this.table) {
                int entry;
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableParallelKVCharLHashGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (char)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != this.free) {
                    if ((LHash.ParallelKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), this.free);
                                    }
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = keyToShift;
                                }
                            }
                        }
                        UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), keyToShift);
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)indexToRemove << 2), this.free);
                MutableParallelKVCharLHashGO.this.postRemoveHook();
                return;
            } else {
                MutableParallelKVCharLHashGO.this.justRemove(UnsafeConstants.U.getChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)index << 2)));
            }
        }
    }
}

