/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import net.openhft.collect.impl.LongArrays;
import net.openhft.collect.impl.PrimitiveConstants;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.MutableQHash;
import net.openhft.collect.impl.hash.ParallelKVDoubleQHash;
import net.openhft.collect.impl.hash.QHash;

public abstract class MutableParallelKVDoubleQHashSO
extends MutableQHash
implements ParallelKVDoubleQHash,
PrimitiveConstants,
UnsafeConstants {
    long[] table;

    void copy(ParallelKVDoubleQHash hash) {
        super.copy(hash);
        this.table = (long[])hash.table().clone();
    }

    void move(ParallelKVDoubleQHash hash) {
        super.copy(hash);
        this.table = hash.table();
    }

    public boolean contains(Object key) {
        return this.contains((Double)key);
    }

    public boolean contains(double key) {
        return this.index(Double.doubleToLongBits(key)) >= 0;
    }

    public boolean contains(long key) {
        return this.index(key) >= 0;
    }

    int index(long key) {
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVDoubleKeyMixing.mix(key) % capacity;
        long cur = tab[index];
        if (cur == key) {
            return index;
        }
        if (cur == 0x7FFFFFFFFFFFFFFEL) {
            return -1;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 2;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = tab[bIndex]) == key) {
                return bIndex;
            }
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return -1;
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = tab[fIndex]) == key) {
                return fIndex;
            }
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return -1;
            }
            step += 4;
        }
    }

    @Override
    void allocateArrays(int capacity) {
        this.table = new long[capacity * 2];
        LongArrays.fillKeys(this.table, 0x7FFFFFFFFFFFFFFEL);
    }

    @Override
    public void clear() {
        super.clear();
        LongArrays.fillKeys(this.table, 0x7FFFFFFFFFFFFFFEL);
    }

    @Override
    void removeAt(int index) {
        this.table[index] = Long.MAX_VALUE;
    }
}

