/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.impl.hash.MutableParallelKVObjQHashSO;
import net.openhft.collect.impl.hash.ObjHash;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;

public abstract class MutableParallelKVObjQHashGO<E>
extends MutableParallelKVObjQHashSO<E> {
    @Override
    @Nonnull
    public Object[] table() {
        return this.table;
    }

    @Override
    boolean doubleSizedArrays() {
        return true;
    }

    @Override
    public int capacity() {
        return this.table.length >> 1;
    }

    public void forEach(Consumer<? super E> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE) continue;
                action.accept(key);
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED) continue;
                action.accept(key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(Predicate<? super E> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || predicate.test(key)) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED || predicate.test(key)) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    public boolean allContainingIn(ObjCollection<?> c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || c.contains(key)) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED || c.contains(key)) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(ObjCollection<? super E> c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE) continue;
                changed |= c.add(key);
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED) continue;
                changed |= c.add(key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(ObjSet<?> s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE) continue;
                changed |= s.remove(key);
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED) continue;
                changed |= s.remove(key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public ObjIterator<E> iterator() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedIterator(mc);
        }
        return new NoRemovedIterator(mc);
    }

    public ObjCursor<E> setCursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedCursor(mc);
        }
        return new NoRemovedCursor(mc);
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE) continue;
                result[resultIndex++] = key;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED) continue;
                result[resultIndex++] = key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE) continue;
                a[resultIndex++] = key;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED) continue;
                a[resultIndex++] = key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE) continue;
                hashCode += this.nullableKeyHashCode(key);
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED) continue;
                hashCode += this.nullableKeyHashCode(key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE) continue;
                sb.append(' ').append(key != this ? key : "(this Collection)").append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED) continue;
                sb.append(' ').append(key != this ? key : "(this Collection)").append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(E var1);

    public boolean removeIf(Predicate<? super E> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = REMOVED;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = REMOVED;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashObjSet<E> thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = REMOVED;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = REMOVED;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean retainAll(@Nonnull HashObjSet<E> thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = REMOVED;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == FREE || key == REMOVED || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = REMOVED;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedCursor
    implements ObjCursor<E> {
        final Object[] tab;
        int expectedModCount;
        int index;
        Object curKey;

        SomeRemovedCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVObjQHashGO.this.table;
            this.index = this.tab.length;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept(key);
            }
            if (index != this.index || mc != MutableParallelKVObjQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public E elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableParallelKVObjQHashGO.this.modCount()) {
                Object[] tab = this.tab;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableParallelKVObjQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableParallelKVObjQHashGO.this.incrementModCount();
            this.tab[this.index] = ObjHash.REMOVED;
            MutableParallelKVObjQHashGO.this.postRemoveHook();
        }
    }

    class SomeRemovedIterator
    implements ObjIterator<E> {
        final Object[] tab;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        E next;

        SomeRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVObjQHashGO.this.table;
            Object[] tab = MutableParallelKVObjQHashGO.this.table;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                Object key = tab[nextI];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(Consumer<? super E> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVObjQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public E next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableParallelKVObjQHashGO.this.modCount()) {
                    this.index = nextI;
                    Object[] tab = this.tab;
                    Object prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        Object key = tab[nextI];
                        if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                        this.next = key;
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableParallelKVObjQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableParallelKVObjQHashGO.this.incrementModCount();
            this.tab[index] = ObjHash.REMOVED;
            MutableParallelKVObjQHashGO.this.postRemoveHook();
        }
    }

    class NoRemovedCursor
    implements ObjCursor<E> {
        final Object[] tab;
        int expectedModCount;
        int index;
        Object curKey;

        NoRemovedCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVObjQHashGO.this.table;
            this.index = this.tab.length;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key);
            }
            if (index != this.index || mc != MutableParallelKVObjQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public E elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableParallelKVObjQHashGO.this.modCount()) {
                Object[] tab = this.tab;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    Object key = tab[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableParallelKVObjQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableParallelKVObjQHashGO.this.incrementModCount();
            this.tab[this.index] = ObjHash.REMOVED;
            MutableParallelKVObjQHashGO.this.postRemoveHook();
        }
    }

    class NoRemovedIterator
    implements ObjIterator<E> {
        final Object[] tab;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        E next;

        NoRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVObjQHashGO.this.table;
            Object[] tab = MutableParallelKVObjQHashGO.this.table;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                Object key = tab[nextI];
                if (key == ObjHash.FREE) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(Consumer<? super E> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVObjQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public E next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableParallelKVObjQHashGO.this.modCount()) {
                    this.index = nextI;
                    Object[] tab = this.tab;
                    Object prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        Object key = tab[nextI];
                        if (key == ObjHash.FREE) continue;
                        this.next = key;
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableParallelKVObjQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableParallelKVObjQHashGO.this.incrementModCount();
            this.tab[index] = ObjHash.REMOVED;
            MutableParallelKVObjQHashGO.this.postRemoveHook();
        }
    }
}

