/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.CharCollection;
import net.openhft.collect.CharCursor;
import net.openhft.collect.CharIterator;
import net.openhft.collect.Equivalence;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractCharValueView;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.CommonShortCharMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.InternalShortCharMapOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.MutableQHashParallelKVShortCharMapSO;
import net.openhft.collect.impl.hash.ParallelKVShortCharQHash;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.map.ShortCharCursor;
import net.openhft.collect.set.CharSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.CharBinaryOperator;
import net.openhft.function.CharConsumer;
import net.openhft.function.CharPredicate;
import net.openhft.function.ShortCharConsumer;
import net.openhft.function.ShortCharPredicate;
import net.openhft.function.ShortCharToCharFunction;
import net.openhft.function.ShortToCharFunction;

public class MutableQHashParallelKVShortCharMapGO
extends MutableQHashParallelKVShortCharMapSO {
    final void copy(ParallelKVShortCharQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVShortCharQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public char defaultValue() {
        return '\u0000';
    }

    @Override
    public boolean containsEntry(short key, char value) {
        short free = this.freeValue;
        if (key != free && key != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == key) {
                return (char)(entry >>> 16) == value;
            }
            if (cur == free) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == key) {
                    return (char)(entry >>> 16) == value;
                }
                if (cur == free) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == key) {
                    return (char)(entry >>> 16) == value;
                }
                if (cur == free) {
                    return false;
                }
                step += 2;
            }
        }
        return false;
    }

    @Override
    public Character get(Object key) {
        short free;
        short k = (Short)key;
        if (k != (free = this.freeValue) && k != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(k) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == k) {
                return Character.valueOf((char)(entry >>> 16));
            }
            if (cur == free) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == k) {
                    return Character.valueOf((char)(entry >>> 16));
                }
                if (cur == free) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == k) {
                    return Character.valueOf((char)(entry >>> 16));
                }
                if (cur == free) {
                    return null;
                }
                step += 2;
            }
        }
        return null;
    }

    public char get(short key) {
        short free = this.freeValue;
        if (key != free && key != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == key) {
                return (char)(entry >>> 16);
            }
            if (cur == free) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == key) {
                    return (char)(entry >>> 16);
                }
                if (cur == free) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == key) {
                    return (char)(entry >>> 16);
                }
                if (cur == free) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        return this.defaultValue();
    }

    @Override
    public Character getOrDefault(Object key, Character defaultValue) {
        short free;
        short k = (Short)key;
        if (k != (free = this.freeValue) && k != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(k) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == k) {
                return Character.valueOf((char)(entry >>> 16));
            }
            if (cur == free) {
                return defaultValue;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == k) {
                    return Character.valueOf((char)(entry >>> 16));
                }
                if (cur == free) {
                    return defaultValue;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == k) {
                    return Character.valueOf((char)(entry >>> 16));
                }
                if (cur == free) {
                    return defaultValue;
                }
                step += 2;
            }
        }
        return defaultValue;
    }

    public char getOrDefault(short key, char defaultValue) {
        short free = this.freeValue;
        if (key != free && key != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == key) {
                return (char)(entry >>> 16);
            }
            if (cur == free) {
                return defaultValue;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == key) {
                    return (char)(entry >>> 16);
                }
                if (cur == free) {
                    return defaultValue;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == key) {
                    return (char)(entry >>> 16);
                }
                if (cur == free) {
                    return defaultValue;
                }
                step += 2;
            }
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Short, ? super Character> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept((Short)key, Character.valueOf((char)(entry >>> 16)));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || key == removed) continue;
                action.accept((Short)key, Character.valueOf((char)(entry >>> 16)));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(ShortCharConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept(key, (char)(entry >>> 16));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || key == removed) continue;
                action.accept(key, (char)(entry >>> 16));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(ShortCharPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || predicate.test(key, (char)(entry >>> 16))) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || key == removed || predicate.test(key, (char)(entry >>> 16))) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ShortCharCursor cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonShortCharMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalShortCharMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || m.containsEntry(key, (char)(entry >>> 16))) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || key == removed || m.containsEntry(key, (char)(entry >>> 16))) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalShortCharMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                m.justPut(key, (char)(entry >>> 16));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || key == removed) continue;
                m.justPut(key, (char)(entry >>> 16));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Short, Character>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public CharCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                hashCode += key ^ (char)(entry >>> 16);
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || key == removed) continue;
                hashCode += key ^ (char)(entry >>> 16);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((char)(entry >>> 16));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || key == removed) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((char)(entry >>> 16));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        int[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        int[] newTab = this.table;
        int capacity = newTab.length;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
                if (U.getShort(newTab, INT_BASE + SHORT_KEY_OFFSET + ((long)index << 2)) != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (U.getShort(newTab, INT_BASE + SHORT_KEY_OFFSET + ((long)bIndex << 2)) == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (U.getShort(newTab, INT_BASE + SHORT_KEY_OFFSET + ((long)fIndex << 2)) == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newTab[index] = entry;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || key == removed) continue;
                int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
                if (U.getShort(newTab, INT_BASE + SHORT_KEY_OFFSET + ((long)index << 2)) != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (U.getShort(newTab, INT_BASE + SHORT_KEY_OFFSET + ((long)bIndex << 2)) == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (U.getShort(newTab, INT_BASE + SHORT_KEY_OFFSET + ((long)fIndex << 2)) == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newTab[index] = entry;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Character put(Short key, Character value) {
        int entry;
        int index;
        int[] tab;
        block26: {
            short k = key;
            short removed = this.removedValue;
            short free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVShortKeyMixing.mix(k) % capacity;
            entry = tab[index];
            short cur = (short)entry;
            if (cur == free) {
                this.incrementModCount();
                tab[index] = k & 0xFFFF | value.charValue() << 16;
                this.postFreeSlotInsertHook();
                return null;
            }
            if (cur != k) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (short)(entry = tab[bIndex])) == free) {
                                this.incrementModCount();
                                tab[bIndex] = k & 0xFFFF | value.charValue() << 16;
                                this.postFreeSlotInsertHook();
                                return null;
                            }
                            if (cur == k) {
                                index = bIndex;
                                break block26;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (short)(entry = tab[fIndex])) == free) {
                                this.incrementModCount();
                                tab[fIndex] = k & 0xFFFF | value.charValue() << 16;
                                this.postFreeSlotInsertHook();
                                return null;
                            }
                            if (cur == k) {
                                index = fIndex;
                                break block26;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[bIndex] = k & 0xFFFF | value.charValue() << 16;
                            this.postFreeSlotInsertHook();
                            return null;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = k & 0xFFFF | value.charValue() << 16;
                        this.postRemovedSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[fIndex] = k & 0xFFFF | value.charValue() << 16;
                            this.postFreeSlotInsertHook();
                            return null;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = k & 0xFFFF | value.charValue() << 16;
                        this.postRemovedSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
            }
        }
        char prevValue = (char)(entry >>> 16);
        U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), value.charValue());
        return Character.valueOf(prevValue);
    }

    @Override
    public char put(short key, char value) {
        int entry;
        int index;
        int[] tab;
        block26: {
            short removed = this.removedValue;
            short free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            entry = tab[index];
            short cur = (short)entry;
            if (cur == free) {
                this.incrementModCount();
                tab[index] = key & 0xFFFF | value << 16;
                this.postFreeSlotInsertHook();
                return this.defaultValue();
            }
            if (cur != key) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (short)(entry = tab[bIndex])) == free) {
                                this.incrementModCount();
                                tab[bIndex] = key & 0xFFFF | value << 16;
                                this.postFreeSlotInsertHook();
                                return this.defaultValue();
                            }
                            if (cur == key) {
                                index = bIndex;
                                break block26;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (short)(entry = tab[fIndex])) == free) {
                                this.incrementModCount();
                                tab[fIndex] = key & 0xFFFF | value << 16;
                                this.postFreeSlotInsertHook();
                                return this.defaultValue();
                            }
                            if (cur == key) {
                                index = fIndex;
                                break block26;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[bIndex] = key & 0xFFFF | value << 16;
                            this.postFreeSlotInsertHook();
                            return this.defaultValue();
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = key & 0xFFFF | value << 16;
                        this.postRemovedSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[fIndex] = key & 0xFFFF | value << 16;
                            this.postFreeSlotInsertHook();
                            return this.defaultValue();
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = key & 0xFFFF | value << 16;
                        this.postRemovedSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
            }
        }
        char prevValue = (char)(entry >>> 16);
        U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), value);
        return prevValue;
    }

    @Override
    public Character putIfAbsent(Short key, Character value) {
        int firstRemoved;
        short k = key;
        short removed = this.removedValue;
        short free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        } else if (k == removed) {
            removed = this.changeRemoved();
        }
        int[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVShortKeyMixing.mix(k) % capacity;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = k & 0xFFFF | value.charValue() << 16;
            this.postFreeSlotInsertHook();
            return null;
        }
        if (cur == k) {
            return Character.valueOf((char)(entry >>> 16));
        }
        if (cur != removed) {
            if (this.noRemoved()) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == free) {
                        this.incrementModCount();
                        tab[bIndex] = k & 0xFFFF | value.charValue() << 16;
                        this.postFreeSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        return Character.valueOf((char)(entry >>> 16));
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == free) {
                        this.incrementModCount();
                        tab[fIndex] = k & 0xFFFF | value.charValue() << 16;
                        this.postFreeSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        return Character.valueOf((char)(entry >>> 16));
                    }
                    step += 2;
                }
            }
            firstRemoved = -1;
        } else {
            firstRemoved = index;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            int t;
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (short)(entry = tab[bIndex])) == free) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[bIndex] = k & 0xFFFF | value.charValue() << 16;
                    this.postFreeSlotInsertHook();
                    return null;
                }
                this.incrementModCount();
                tab[firstRemoved] = k & 0xFFFF | value.charValue() << 16;
                this.postRemovedSlotInsertHook();
                return null;
            }
            if (cur == k) {
                return Character.valueOf((char)(entry >>> 16));
            }
            if (cur == removed && firstRemoved < 0) {
                firstRemoved = bIndex;
            }
            if ((t = (fIndex += step) - capacity) >= 0) {
                fIndex = t;
            }
            if ((cur = (short)(entry = tab[fIndex])) == free) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[fIndex] = k & 0xFFFF | value.charValue() << 16;
                    this.postFreeSlotInsertHook();
                    return null;
                }
                this.incrementModCount();
                tab[firstRemoved] = k & 0xFFFF | value.charValue() << 16;
                this.postRemovedSlotInsertHook();
                return null;
            }
            if (cur == k) {
                return Character.valueOf((char)(entry >>> 16));
            }
            if (cur == removed && firstRemoved < 0) {
                firstRemoved = fIndex;
            }
            step += 2;
        }
    }

    @Override
    public char putIfAbsent(short key, char value) {
        int firstRemoved;
        short removed = this.removedValue;
        short free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        } else if (key == removed) {
            removed = this.changeRemoved();
        }
        int[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key & 0xFFFF | value << 16;
            this.postFreeSlotInsertHook();
            return this.defaultValue();
        }
        if (cur == key) {
            return (char)(entry >>> 16);
        }
        if (cur != removed) {
            if (this.noRemoved()) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == free) {
                        this.incrementModCount();
                        tab[bIndex] = key & 0xFFFF | value << 16;
                        this.postFreeSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == key) {
                        return (char)(entry >>> 16);
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == free) {
                        this.incrementModCount();
                        tab[fIndex] = key & 0xFFFF | value << 16;
                        this.postFreeSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == key) {
                        return (char)(entry >>> 16);
                    }
                    step += 2;
                }
            }
            firstRemoved = -1;
        } else {
            firstRemoved = index;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            int t;
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (short)(entry = tab[bIndex])) == free) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[bIndex] = key & 0xFFFF | value << 16;
                    this.postFreeSlotInsertHook();
                    return this.defaultValue();
                }
                this.incrementModCount();
                tab[firstRemoved] = key & 0xFFFF | value << 16;
                this.postRemovedSlotInsertHook();
                return this.defaultValue();
            }
            if (cur == key) {
                return (char)(entry >>> 16);
            }
            if (cur == removed && firstRemoved < 0) {
                firstRemoved = bIndex;
            }
            if ((t = (fIndex += step) - capacity) >= 0) {
                fIndex = t;
            }
            if ((cur = (short)(entry = tab[fIndex])) == free) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[fIndex] = key & 0xFFFF | value << 16;
                    this.postFreeSlotInsertHook();
                    return this.defaultValue();
                }
                this.incrementModCount();
                tab[firstRemoved] = key & 0xFFFF | value << 16;
                this.postRemovedSlotInsertHook();
                return this.defaultValue();
            }
            if (cur == key) {
                return (char)(entry >>> 16);
            }
            if (cur == removed && firstRemoved < 0) {
                firstRemoved = fIndex;
            }
            step += 2;
        }
    }

    @Override
    public void justPut(short key, char value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        U.putChar(this.table, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), value);
    }

    @Override
    public Character compute(Short key, BiFunction<? super Short, ? super Character, ? extends Character> remappingFunction) {
        Character newValue;
        int entry;
        int index;
        int[] tab;
        short removed;
        short k;
        block28: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            short free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVShortKeyMixing.mix(k) % capacity;
            entry = tab[index];
            short cur = (short)entry;
            if (cur != k) {
                Character newValue2;
                block29: {
                    if (cur != free) {
                        Character newValue3;
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (short)(entry = tab[bIndex])) == k) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (short)(entry = tab[fIndex])) == k) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (short)(entry = tab[bIndex])) == k) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (short)(entry = tab[fIndex])) == k) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply((Short)k, null)) != null) {
                            this.incrementModCount();
                            tab[firstRemoved] = k & 0xFFFF | newValue3.charValue() << 16;
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply((Short)k, null)) != null) {
                    this.incrementModCount();
                    tab[index] = k & 0xFFFF | newValue2.charValue() << 16;
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Short)k, Character.valueOf((char)(entry >>> 16)))) != null) {
            U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue.charValue());
            return newValue;
        }
        this.incrementModCount();
        U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)index << 2), removed);
        this.postRemoveHook();
        return null;
    }

    public char compute(short key, ShortCharToCharFunction remappingFunction) {
        char newValue;
        int entry;
        int index;
        int[] tab;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            short removed = this.removedValue;
            short free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (short)(entry = tab[bIndex])) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (short)(entry = tab[fIndex])) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (short)(entry = tab[bIndex])) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (short)(entry = tab[fIndex])) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        char newValue2 = remappingFunction.applyAsChar(key, this.defaultValue());
                        this.incrementModCount();
                        tab[firstRemoved] = key & 0xFFFF | newValue2 << 16;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = remappingFunction.applyAsChar(key, this.defaultValue());
                this.incrementModCount();
                tab[index] = key & 0xFFFF | newValue << 16;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsChar(key, (char)(entry >>> 16));
        U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    @Override
    public Character computeIfAbsent(Short key, Function<? super Short, ? extends Character> mappingFunction) {
        Character value;
        short k;
        block27: {
            k = key;
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            short removed = this.removedValue;
            short free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(k) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != free) {
                Character value2;
                int firstRemoved;
                if (cur == k) {
                    return Character.valueOf((char)(entry >>> 16));
                }
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (short)(entry = tab[bIndex])) == free) {
                                index = bIndex;
                                break block27;
                            }
                            if (cur == k) {
                                return Character.valueOf((char)(entry >>> 16));
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (short)(entry = tab[fIndex])) == free) {
                                index = fIndex;
                                break block27;
                            }
                            if (cur == k) {
                                return Character.valueOf((char)(entry >>> 16));
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block27;
                    }
                    if (cur == k) {
                        return Character.valueOf((char)(entry >>> 16));
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block27;
                    }
                    if (cur == k) {
                        return Character.valueOf((char)(entry >>> 16));
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                if ((value2 = mappingFunction.apply((Short)k)) != null) {
                    this.incrementModCount();
                    tab[firstRemoved] = k & 0xFFFF | value2.charValue() << 16;
                    this.postRemovedSlotInsertHook();
                    return value2;
                }
                return null;
            }
        }
        if ((value = mappingFunction.apply((Short)k)) != null) {
            this.incrementModCount();
            tab[index] = k & 0xFFFF | value.charValue() << 16;
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    public char computeIfAbsent(short key, ShortToCharFunction mappingFunction) {
        block25: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            short removed = this.removedValue;
            short free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != free) {
                int firstRemoved;
                if (cur == key) {
                    return (char)(entry >>> 16);
                }
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (short)(entry = tab[bIndex])) == free) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == key) {
                                return (char)(entry >>> 16);
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (short)(entry = tab[fIndex])) == free) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == key) {
                                return (char)(entry >>> 16);
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block25;
                    }
                    if (cur == key) {
                        return (char)(entry >>> 16);
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block25;
                    }
                    if (cur == key) {
                        return (char)(entry >>> 16);
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                char value = mappingFunction.applyAsChar(key);
                this.incrementModCount();
                tab[firstRemoved] = key & 0xFFFF | value << 16;
                this.postRemovedSlotInsertHook();
                return value;
            }
        }
        char value = mappingFunction.applyAsChar(key);
        this.incrementModCount();
        tab[index] = key & 0xFFFF | value << 16;
        this.postFreeSlotInsertHook();
        return value;
    }

    @Override
    public Character computeIfPresent(Short key, BiFunction<? super Short, ? super Character, ? extends Character> remappingFunction) {
        short removed;
        short k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        short free = this.freeValue;
        if (k != free && k != (removed = this.removedValue)) {
            Character newValue;
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(k) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            if ((newValue = remappingFunction.apply((Short)k, Character.valueOf((char)(entry >>> 16)))) != null) {
                U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue.charValue());
                return newValue;
            }
            this.incrementModCount();
            U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)index << 2), removed);
            this.postRemoveHook();
            return null;
        }
        return null;
    }

    public char computeIfPresent(short key, ShortCharToCharFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        short free = this.freeValue;
        if (key != free && key != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            char newValue = remappingFunction.applyAsChar(key, (char)(entry >>> 16));
            U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    @Override
    public Character merge(Short key, Character value, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        Character newValue;
        int entry;
        int index;
        int[] tab;
        short removed;
        block27: {
            short k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            short free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVShortKeyMixing.mix(k) % capacity;
            entry = tab[index];
            short cur = (short)entry;
            if (cur != k) {
                block28: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (short)(entry = tab[bIndex])) == k) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (short)(entry = tab[fIndex])) == k) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (short)(entry = tab[bIndex])) == k) {
                                index = bIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (short)(entry = tab[fIndex])) == k) {
                                index = fIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = k & 0xFFFF | value.charValue() << 16;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                tab[index] = k & 0xFFFF | value.charValue() << 16;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply(Character.valueOf((char)(entry >>> 16)), value)) != null) {
            U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue.charValue());
            return newValue;
        }
        this.incrementModCount();
        U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)index << 2), removed);
        this.postRemoveHook();
        return null;
    }

    public char merge(short key, char value, CharBinaryOperator remappingFunction) {
        int entry;
        int index;
        int[] tab;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            short removed = this.removedValue;
            short free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (short)(entry = tab[bIndex])) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (short)(entry = tab[fIndex])) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (short)(entry = tab[bIndex])) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (short)(entry = tab[fIndex])) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = key & 0xFFFF | value << 16;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                tab[index] = key & 0xFFFF | value << 16;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        char newValue = remappingFunction.applyAsChar((char)(entry >>> 16), value);
        U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public char addValue(short key, char value) {
        int entry;
        int index;
        int[] tab;
        block26: {
            short removed = this.removedValue;
            short free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            entry = tab[index];
            short cur = (short)entry;
            if (cur == free) {
                this.incrementModCount();
                tab[index] = key & 0xFFFF | value << 16;
                this.postFreeSlotInsertHook();
                return value;
            }
            if (cur != key) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (short)(entry = tab[bIndex])) == free) {
                                this.incrementModCount();
                                tab[bIndex] = key & 0xFFFF | value << 16;
                                this.postFreeSlotInsertHook();
                                return value;
                            }
                            if (cur == key) {
                                index = bIndex;
                                break block26;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (short)(entry = tab[fIndex])) == free) {
                                this.incrementModCount();
                                tab[fIndex] = key & 0xFFFF | value << 16;
                                this.postFreeSlotInsertHook();
                                return value;
                            }
                            if (cur == key) {
                                index = fIndex;
                                break block26;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[bIndex] = key & 0xFFFF | value << 16;
                            this.postFreeSlotInsertHook();
                            return value;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = key & 0xFFFF | value << 16;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                    if (cur == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[fIndex] = key & 0xFFFF | value << 16;
                            this.postFreeSlotInsertHook();
                            return value;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = key & 0xFFFF | value << 16;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                    if (cur == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
            }
        }
        char newValue = (char)((char)(entry >>> 16) + value);
        U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public char addValue(short key, char addition, char defaultValue) {
        int entry;
        int index;
        int[] tab;
        block26: {
            char value = (char)(defaultValue + addition);
            short removed = this.removedValue;
            short free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            entry = tab[index];
            short cur = (short)entry;
            if (cur == free) {
                this.incrementModCount();
                tab[index] = key & 0xFFFF | value << 16;
                this.postFreeSlotInsertHook();
                return value;
            }
            if (cur != key) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (short)(entry = tab[bIndex])) == free) {
                                this.incrementModCount();
                                tab[bIndex] = key & 0xFFFF | value << 16;
                                this.postFreeSlotInsertHook();
                                return value;
                            }
                            if (cur == key) {
                                index = bIndex;
                                break block26;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (short)(entry = tab[fIndex])) == free) {
                                this.incrementModCount();
                                tab[fIndex] = key & 0xFFFF | value << 16;
                                this.postFreeSlotInsertHook();
                                return value;
                            }
                            if (cur == key) {
                                index = fIndex;
                                break block26;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[bIndex] = key & 0xFFFF | value << 16;
                            this.postFreeSlotInsertHook();
                            return value;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = key & 0xFFFF | value << 16;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                    if (cur == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[fIndex] = key & 0xFFFF | value << 16;
                            this.postFreeSlotInsertHook();
                            return value;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = key & 0xFFFF | value << 16;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                    if (cur == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
            }
        }
        char newValue = (char)((char)(entry >>> 16) + addition);
        U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Short, ? extends Character> m) {
        CommonShortCharMapOps.putAll(this, m);
    }

    @Override
    public Character replace(Short key, Character value) {
        short free;
        short k = key;
        if (k != (free = this.freeValue) && k != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(k) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            char oldValue = (char)(entry >>> 16);
            U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), value.charValue());
            return Character.valueOf(oldValue);
        }
        return null;
    }

    @Override
    public char replace(short key, char value) {
        short free = this.freeValue;
        if (key != free && key != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            char oldValue = (char)(entry >>> 16);
            U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), value);
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Short key, Character oldValue, Character newValue) {
        return this.replace((short)key, oldValue.charValue(), newValue.charValue());
    }

    @Override
    public boolean replace(short key, char oldValue, char newValue) {
        short free = this.freeValue;
        if (key != free && key != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if ((char)(entry >>> 16) == oldValue) {
                U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Short, ? super Character, ? extends Character> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)i << 2), function.apply((Short)key, Character.valueOf((char)(entry >>> 16))).charValue());
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || key == removed) continue;
                U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)i << 2), function.apply((Short)key, Character.valueOf((char)(entry >>> 16))).charValue());
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ShortCharToCharFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)i << 2), function.applyAsChar(key, (char)(entry >>> 16)));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || key == removed) continue;
                U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)i << 2), function.applyAsChar(key, (char)(entry >>> 16)));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.postRemoveHook();
    }

    @Override
    public Character remove(Object key) {
        short removed;
        short free;
        short k = (Short)key;
        if (k != (free = this.freeValue) && k != (removed = this.removedValue)) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(k) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            char val = (char)(entry >>> 16);
            this.incrementModCount();
            U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)index << 2), removed);
            this.postRemoveHook();
            return Character.valueOf(val);
        }
        return null;
    }

    @Override
    public boolean justRemove(short key) {
        short removed;
        short free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            this.incrementModCount();
            U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)index << 2), removed);
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public char remove(short key) {
        short removed;
        short free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            char val = (char)(entry >>> 16);
            this.incrementModCount();
            U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)index << 2), removed);
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Short)key, ((Character)value).charValue());
    }

    public boolean remove(short key, char value) {
        short removed;
        short free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (short)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (short)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if ((char)(entry >>> 16) == value) {
                this.incrementModCount();
                U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)index << 2), removed);
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(ShortCharPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || !filter.test(key, (char)(entry >>> 16))) continue;
                this.incrementModCount();
                ++mc;
                U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)i << 2), removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || key == removed || !filter.test(key, (char)(entry >>> 16))) continue;
                this.incrementModCount();
                ++mc;
                U.putShort(tab, INT_BASE + SHORT_KEY_OFFSET + ((long)i << 2), removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedMapCursor
    implements ShortCharCursor {
        final int[] tab;
        final short free;
        final short removed;
        int expectedModCount;
        int index;
        short curKey;
        char curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVShortCharMapGO.this.table;
            this.index = this.tab.length;
            short free = this.free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ShortCharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            short removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || key == removed) continue;
                action.accept(key, (char)(entry >>> 16));
            }
            if (index != this.index || mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short key() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public char value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(char value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_VALUE_OFFSET + ((long)this.index << 2), value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                int[] tab = this.tab;
                short free = this.free;
                short removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (char)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            short free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
            UnsafeConstants.U.putShort(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)this.index << 2), this.removed);
            MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements ShortCharCursor {
        final int[] tab;
        final short free;
        final short removed;
        int expectedModCount;
        int index;
        short curKey;
        char curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVShortCharMapGO.this.table;
            this.index = this.tab.length;
            short free = this.free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ShortCharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept(key, (char)(entry >>> 16));
            }
            if (index != this.index || mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short key() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public char value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(char value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_VALUE_OFFSET + ((long)this.index << 2), value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                int[] tab = this.tab;
                short free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (char)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            short free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
            UnsafeConstants.U.putShort(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)this.index << 2), this.removed);
            MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements CharCursor {
        final int[] tab;
        final short free;
        final short removed;
        int expectedModCount;
        int index;
        short curKey;
        char curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVShortCharMapGO.this.table;
            this.index = this.tab.length;
            short free = this.free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            short removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || key == removed) continue;
                action.accept((char)(entry >>> 16));
            }
            if (index != this.index || mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                int[] tab = this.tab;
                short free = this.free;
                short removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (char)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            short free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
            UnsafeConstants.U.putShort(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)this.index << 2), this.removed);
            MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements CharIterator {
        final int[] tab;
        final short free;
        final short removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        char next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVShortCharMapGO.this.table;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            short free = this.free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = this.removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                short key = (short)entry;
                if (key == free || key == removed) continue;
                this.next = (char)(entry >>> 16);
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                    this.index = nextI;
                    int[] tab = this.tab;
                    short free = this.free;
                    short removed = this.removed;
                    char prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        short key = (short)entry;
                        if (key == free || key == removed) continue;
                        this.next = (char)(entry >>> 16);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            short removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || key == removed) continue;
                action.accept(Character.valueOf((char)(entry >>> 16)));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            short removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || key == removed) continue;
                action.accept((char)(entry >>> 16));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
            UnsafeConstants.U.putShort(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)index << 2), this.removed);
            MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements CharCursor {
        final int[] tab;
        final short free;
        final short removed;
        int expectedModCount;
        int index;
        short curKey;
        char curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVShortCharMapGO.this.table;
            this.index = this.tab.length;
            short free = this.free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept((char)(entry >>> 16));
            }
            if (index != this.index || mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                int[] tab = this.tab;
                short free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (char)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            short free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
            UnsafeConstants.U.putShort(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)this.index << 2), this.removed);
            MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements CharIterator {
        final int[] tab;
        final short free;
        final short removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        char next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVShortCharMapGO.this.table;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            short free = this.free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                if ((short)entry == free) continue;
                this.next = (char)(entry >>> 16);
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                    this.index = nextI;
                    int[] tab = this.tab;
                    short free = this.free;
                    char prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        if ((short)entry == free) continue;
                        this.next = (char)(entry >>> 16);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept(Character.valueOf((char)(entry >>> 16)));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept((char)(entry >>> 16));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
            UnsafeConstants.U.putShort(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)index << 2), this.removed);
            MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<Short, Character>> {
        final int[] tab;
        final short free;
        final short removed;
        int expectedModCount;
        int index;
        short curKey;
        char curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVShortCharMapGO.this.table;
            this.index = this.tab.length;
            short free = this.free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Short, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            short removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || key == removed) continue;
                action.accept(new MutableEntry(mc, i, key, (char)(entry >>> 16)));
            }
            if (index != this.index || mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Short, Character> elem() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                int[] tab = this.tab;
                short free = this.free;
                short removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (char)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            short free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
            UnsafeConstants.U.putShort(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)this.index << 2), this.removed);
            MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<Short, Character>> {
        final int[] tab;
        final short free;
        final short removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVShortCharMapGO.this.table;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            short free = this.free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = this.removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                short key = (short)entry;
                if (key == free || key == removed) continue;
                this.next = new MutableEntry(mc, nextI, key, (char)(entry >>> 16));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Short, Character>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            short removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || key == removed) continue;
                action.accept(new MutableEntry(mc, i, key, (char)(entry >>> 16)));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Short, Character> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                    this.index = nextI;
                    int[] tab = this.tab;
                    short free = this.free;
                    short removed = this.removed;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        short key = (short)entry;
                        if (key == free || key == removed) continue;
                        this.next = new MutableEntry(mc, nextI, key, (char)(entry >>> 16));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
            UnsafeConstants.U.putShort(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)index << 2), this.removed);
            MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Short, Character>> {
        final int[] tab;
        final short free;
        final short removed;
        int expectedModCount;
        int index;
        short curKey;
        char curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVShortCharMapGO.this.table;
            this.index = this.tab.length;
            short free = this.free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Short, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, (char)(entry >>> 16)));
            }
            if (index != this.index || mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Short, Character> elem() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                int[] tab = this.tab;
                short free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (char)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            short free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
            UnsafeConstants.U.putShort(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)this.index << 2), this.removed);
            MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Short, Character>> {
        final int[] tab;
        final short free;
        final short removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVShortCharMapGO.this.table;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            short free = this.free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                short key = (short)entry;
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, (char)(entry >>> 16));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Short, Character>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, (char)(entry >>> 16)));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Short, Character> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                    this.index = nextI;
                    int[] tab = this.tab;
                    short free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        short key = (short)entry;
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, (char)(entry >>> 16));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
            UnsafeConstants.U.putShort(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)index << 2), this.removed);
            MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractCharValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return MutableQHashParallelKVShortCharMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashParallelKVShortCharMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableQHashParallelKVShortCharMapGO.this.containsValue(o);
        }

        public boolean contains(char v) {
            return MutableQHashParallelKVShortCharMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Character> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((short)entry == free) continue;
                    action.accept(Character.valueOf((char)(entry >>> 16)));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed) continue;
                    action.accept(Character.valueOf((char)(entry >>> 16)));
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((short)entry == free) continue;
                    action.accept((char)(entry >>> 16));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed) continue;
                    action.accept((char)(entry >>> 16));
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(CharPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((short)entry == free || predicate.test((char)(entry >>> 16))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed || predicate.test((char)(entry >>> 16))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(CharCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((short)entry == free || c.contains((char)(entry >>> 16))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed || c.contains((char)(entry >>> 16))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(CharCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((short)entry == free) continue;
                    changed |= c.add((char)(entry >>> 16));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed) continue;
                    changed |= c.add((char)(entry >>> 16));
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(CharSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((short)entry == free) continue;
                    changed |= s.removeChar((char)(entry >>> 16));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed) continue;
                    changed |= s.removeChar((char)(entry >>> 16));
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public CharIterator iterator() {
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            if (!MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public CharCursor cursor() {
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            if (!MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((short)entry == free) continue;
                    result[resultIndex++] = Character.valueOf((char)(entry >>> 16));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = Character.valueOf((char)(entry >>> 16));
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((short)entry == free) continue;
                    a[resultIndex++] = Character.valueOf((char)(entry >>> 16));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = Character.valueOf((char)(entry >>> 16));
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public char[] toCharArray() {
            int size = this.size();
            char[] result = new char[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((short)entry == free) continue;
                    result[resultIndex++] = (char)(entry >>> 16);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = (char)(entry >>> 16);
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public char[] toArray(char[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new char[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = '\u0000';
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((short)entry == free) continue;
                    a[resultIndex++] = (char)(entry >>> 16);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = (char)(entry >>> 16);
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = '\u0000';
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((short)entry == free) continue;
                    sb.append(' ').append((char)(entry >>> 16)).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed) continue;
                    sb.append(' ').append((char)(entry >>> 16)).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeChar(((Character)o).charValue());
        }

        public boolean removeChar(char v) {
            return MutableQHashParallelKVShortCharMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            MutableQHashParallelKVShortCharMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Character> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((short)entry == free || !filter.test(Character.valueOf((char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed || !filter.test(Character.valueOf((char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(CharPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((short)entry == free || !filter.test((char)(entry >>> 16))) continue;
                    MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed || !filter.test((char)(entry >>> 16))) continue;
                    MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof CharCollection) {
                return this.removeAll((CharCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((short)entry == free || !c.contains(Character.valueOf((char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed || !c.contains(Character.valueOf((char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(CharCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((short)entry == free || !c.contains((char)(entry >>> 16))) continue;
                    MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed || !c.contains((char)(entry >>> 16))) continue;
                    MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof CharCollection) {
                return this.retainAll((CharCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((short)entry == free || c.contains(Character.valueOf((char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed || c.contains(Character.valueOf((char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(CharCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((short)entry == free || c.contains((char)(entry >>> 16))) continue;
                    MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed || c.contains((char)(entry >>> 16))) continue;
                    MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends ShortCharEntry {
        private short key;
        private char value;

        ReusableEntry() {
        }

        ReusableEntry with(short key, char value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ShortCharEntry {
        int modCount;
        private final int index;
        final short key;
        private char value;

        MutableEntry(int modCount, int index, short key, char value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }

        @Override
        public Character setValue(Character newValue) {
            char unwrappedNewValue;
            if (this.modCount != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            char oldValue = this.value;
            this.value = unwrappedNewValue = newValue.charValue();
            this.updateValueInTable(unwrappedNewValue);
            return Character.valueOf(oldValue);
        }

        void updateValueInTable(char newValue) {
            UnsafeConstants.U.putChar(MutableQHashParallelKVShortCharMapGO.this.table, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_VALUE_OFFSET + ((long)this.index << 2), newValue);
        }
    }

    abstract class ShortCharEntry
    extends AbstractEntry<Short, Character> {
        ShortCharEntry() {
        }

        abstract short key();

        @Override
        public final Short getKey() {
            return this.key();
        }

        abstract char value();

        @Override
        public final Character getValue() {
            return Character.valueOf(this.value());
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                short k2 = (Short)e2.getKey();
                char v2 = ((Character)e2.getValue()).charValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Short, Character>>
    implements HashObjSet<Map.Entry<Short, Character>>,
    InternalObjCollectionOps<Map.Entry<Short, Character>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Short, Character>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashParallelKVShortCharMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableQHashParallelKVShortCharMapGO.this.size();
        }

        public double currentLoad() {
            return MutableQHashParallelKVShortCharMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashParallelKVShortCharMapGO.this.containsEntry((Short)e.getKey(), ((Character)e.getValue()).charValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, (char)(entry >>> 16));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, (char)(entry >>> 16));
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, (char)(entry >>> 16));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, (char)(entry >>> 16));
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Short, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free) continue;
                    action.accept(new MutableEntry(mc, i, key, (char)(entry >>> 16)));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed) continue;
                    action.accept(new MutableEntry(mc, i, key, (char)(entry >>> 16)));
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Short, Character>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || predicate.test(new MutableEntry(mc, i, key, (char)(entry >>> 16)))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed || predicate.test(new MutableEntry(mc, i, key, (char)(entry >>> 16)))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Short, Character>> iterator() {
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            if (!MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Short, Character>> cursor() {
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            if (!MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || c.contains((Object)e.with(key, (char)(entry >>> 16)))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed || c.contains((Object)e.with(key, (char)(entry >>> 16)))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free) continue;
                    changed |= s.remove((Object)e.with(key, (char)(entry >>> 16)));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed) continue;
                    changed |= s.remove((Object)e.with(key, (char)(entry >>> 16)));
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Short, Character>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, (char)(entry >>> 16)));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, (char)(entry >>> 16)));
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableQHashParallelKVShortCharMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append((char)(entry >>> 16));
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append((char)(entry >>> 16));
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashParallelKVShortCharMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                short key = (Short)e.getKey();
                char value = ((Character)e.getValue()).charValue();
                return MutableQHashParallelKVShortCharMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Short, Character>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || !filter.test(new MutableEntry(mc, i, key, (char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed || !filter.test(new MutableEntry(mc, i, key, (char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || !c.contains(e.with(key, (char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed || !c.contains(e.with(key, (char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVShortCharMapGO.this.modCount();
            short free = MutableQHashParallelKVShortCharMapGO.this.freeValue;
            short removed = MutableQHashParallelKVShortCharMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVShortCharMapGO.this.table;
            if (MutableQHashParallelKVShortCharMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || c.contains(e.with(key, (char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free || key == removed || c.contains(e.with(key, (char)(entry >>> 16)))) continue;
                    MutableQHashParallelKVShortCharMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putShort(tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVShortCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVShortCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableQHashParallelKVShortCharMapGO.this.clear();
        }
    }
}

