/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.impl.InternalFloatObjMapOps;
import net.openhft.collect.impl.hash.MutableQHashSeparateKVFloatKeyMap;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.SeparateKVFloatObjQHash;
import net.openhft.collect.map.hash.HashFloatObjMap;

public abstract class MutableQHashSeparateKVFloatObjMapSO<V>
extends MutableQHashSeparateKVFloatKeyMap
implements HashFloatObjMap<V>,
InternalFloatObjMapOps<V>,
SeparateKVFloatObjQHash {
    V[] values;

    void copy(SeparateKVFloatObjQHash hash) {
        super.copy(hash);
        this.values = (Object[])hash.valueArray().clone();
    }

    void move(SeparateKVFloatObjQHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public Object[] valueArray() {
        return this.values;
    }

    boolean nullableValueEquals(@Nullable V a, @Nullable V b) {
        return a == b || a != null && a.equals(b);
    }

    boolean valueEquals(@Nonnull V a, @Nullable V b) {
        return a.equals(b);
    }

    int nullableValueHashCode(@Nullable V value) {
        return value != null ? value.hashCode() : 0;
    }

    int valueHashCode(@Nonnull V value) {
        return value.hashCode();
    }

    int valueIndex(@Nullable Object value) {
        if (value == null) {
            return this.nullValueIndex();
        }
        if (this.isEmpty()) {
            return -1;
        }
        Object val = value;
        int index = -1;
        int mc = this.modCount();
        int[] keys = this.set;
        V[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] >= 0x7FFFFFFE || !this.valueEquals(val, vals[i])) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    private int nullValueIndex() {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        int[] keys = this.set;
        V[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] >= 0x7FFFFFFE || vals[i] != null) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(@Nullable Object value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    int insert(int key, V value) {
        block21: {
            int[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVFloatKeyMixing.mix(key) % capacity;
            int cur = keys[index];
            if (cur == key) {
                return index;
            }
            if (cur != 0x7FFFFFFE) {
                int firstRemoved;
                if (cur <= 0x7FFFFFFE) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                return bIndex;
                            }
                            if (cur == 0x7FFFFFFE) {
                                index = bIndex;
                                break block21;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                return fIndex;
                            }
                            if (cur == 0x7FFFFFFE) {
                                index = fIndex;
                                break block21;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        return bIndex;
                    }
                    if (cur == 0x7FFFFFFE) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block21;
                    }
                    if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        return fIndex;
                    }
                    if (cur == 0x7FFFFFFE) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block21;
                    }
                    if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                this.incrementModCount();
                keys[firstRemoved] = key;
                this.values[firstRemoved] = value;
                this.postRemovedSlotInsertHook();
                return -1;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postFreeSlotInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new Object[capacity];
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.values, null);
    }
}

