/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import net.openhft.collect.impl.hash.Hash;

public interface QHash
extends Hash {

    public static class ParallelKVObjKeyMixing {
        static int mix(int hash) {
            return hash << 2 >>> 1;
        }
    }

    public static class ParallelKVLongKeyMixing {
        static int mix(long key) {
            long h = key * -7046029254386353131L;
            h ^= h >> 40 ^ h >> 24;
            return (int)h << 2 >>> 1;
        }
    }

    public static class ParallelKVDoubleKeyMixing {
        static int mix(long key) {
            long h = key * -7046029254386353131L;
            h ^= h >> 40 ^ h >> 24;
            return (int)h << 2 >>> 1;
        }
    }

    public static class ParallelKVFloatKeyMixing {
        static int mix(int key) {
            return key * -1640531527 & Integer.MAX_VALUE;
        }
    }

    public static class ParallelKVIntKeyMixing {
        static int mix(int key) {
            return key * -1640531527 & Integer.MAX_VALUE;
        }
    }

    public static class ParallelKVShortKeyMixing {
        static int mix(short key) {
            return key * -1640531527 & Integer.MAX_VALUE;
        }
    }

    public static class ParallelKVCharKeyMixing {
        static int mix(char key) {
            return key * -1640531527 & Integer.MAX_VALUE;
        }
    }

    public static class ParallelKVByteKeyMixing {
        static int mix(byte key) {
            return key * -1640531527 & Integer.MAX_VALUE;
        }
    }

    public static class SeparateKVObjKeyMixing {
        static int mix(int hash) {
            return hash & Integer.MAX_VALUE;
        }
    }

    public static class SeparateKVLongKeyMixing {
        static int mix(long key) {
            long h = key * -7046029254386353131L;
            h ^= h >> 32;
            return (int)h & Integer.MAX_VALUE;
        }
    }

    public static class SeparateKVDoubleKeyMixing {
        static int mix(long key) {
            long h = key * -7046029254386353131L;
            h ^= h >> 32;
            return (int)h & Integer.MAX_VALUE;
        }
    }

    public static class SeparateKVFloatKeyMixing {
        static int mix(int key) {
            return key * -1640531527 & Integer.MAX_VALUE;
        }
    }

    public static class SeparateKVIntKeyMixing {
        static int mix(int key) {
            return key * -1640531527 & Integer.MAX_VALUE;
        }
    }

    public static class SeparateKVShortKeyMixing {
        static int mix(short key) {
            return key * -1640531527 & Integer.MAX_VALUE;
        }
    }

    public static class SeparateKVCharKeyMixing {
        static int mix(char key) {
            return key * -1640531527 & Integer.MAX_VALUE;
        }
    }

    public static class SeparateKVByteKeyMixing {
        static int mix(byte key) {
            return key * -1640531527 & Integer.MAX_VALUE;
        }
    }
}

