/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.hash.LHashByteSetFactoryImpl;
import net.openhft.collect.impl.hash.QHashByteSetFactoryGO;
import net.openhft.collect.set.hash.HashByteSetFactory;

public final class QHashByteSetFactoryImpl
extends QHashByteSetFactoryGO {
    public QHashByteSetFactoryImpl() {
        this(HashConfig.getDefault(), 10, -128, 127);
    }

    public QHashByteSetFactoryImpl(HashConfig hashConf, int defaultExpectedSize, byte lower, byte upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    @Override
    HashByteSetFactory thisWith(HashConfig hashConf, int defaultExpectedSize, byte lower, byte upper) {
        return new QHashByteSetFactoryImpl(hashConf, defaultExpectedSize, lower, upper);
    }

    @Override
    HashByteSetFactory qHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, byte lower, byte upper) {
        return new QHashByteSetFactoryImpl(hashConf, defaultExpectedSize, lower, upper);
    }

    @Override
    HashByteSetFactory lHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, byte lower, byte upper) {
        return new LHashByteSetFactoryImpl(hashConf, defaultExpectedSize, lower, upper);
    }

    HashByteSetFactory withDomain(byte lower, byte upper) {
        if (lower == this.getLowerKeyDomainBound() && upper == this.getUpperKeyDomainBound()) {
            return this;
        }
        return new QHashByteSetFactoryImpl(this.getHashConfig(), this.getDefaultExpectedSize(), lower, upper);
    }

    public HashByteSetFactory withKeysDomain(byte lower, byte upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minPossibleKey shouldn't be greater than maxPossibleKey");
        }
        return this.withDomain(lower, upper);
    }

    public HashByteSetFactory withKeysDomainComplement(byte lower, byte upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minImpossibleKey shouldn't be greater than maxImpossibleKey");
        }
        return this.withDomain((byte)(upper + 1), (byte)(lower - 1));
    }
}

