/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Set;
import net.openhft.collect.ByteCollection;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.hash.ByteQHashFactory;
import net.openhft.collect.impl.hash.ImmutableQHashByteSet;
import net.openhft.collect.impl.hash.ImmutableQHashByteSetGO;
import net.openhft.collect.impl.hash.MutableQHashByteSet;
import net.openhft.collect.impl.hash.MutableQHashByteSetGO;
import net.openhft.collect.impl.hash.SeparateKVByteQHash;
import net.openhft.collect.impl.hash.UpdatableQHashByteSet;
import net.openhft.collect.impl.hash.UpdatableQHashByteSetGO;
import net.openhft.collect.set.hash.HashByteSetFactory;

public abstract class QHashByteSetFactorySO
extends ByteQHashFactory<MutableQHashByteSetGO>
implements HashByteSetFactory {
    QHashByteSetFactorySO(HashConfig hashConf, int defaultExpectedSize, byte lower, byte upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    @Override
    MutableQHashByteSetGO createNewMutable(int expectedSize, byte free, byte removed) {
        MutableQHashByteSet set = new MutableQHashByteSet();
        set.init(this.configWrapper, expectedSize, free, removed);
        return set;
    }

    MutableQHashByteSetGO uninitializedMutableSet() {
        return new MutableQHashByteSet();
    }

    UpdatableQHashByteSetGO uninitializedUpdatableSet() {
        return new UpdatableQHashByteSet();
    }

    ImmutableQHashByteSetGO uninitializedImmutableSet() {
        return new ImmutableQHashByteSet();
    }

    public MutableQHashByteSetGO newMutableSet(int expectedSize) {
        return (MutableQHashByteSetGO)this.newMutableHash(expectedSize);
    }

    public UpdatableQHashByteSetGO newUpdatableSet(int expectedSize) {
        UpdatableQHashByteSet set = new UpdatableQHashByteSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    public UpdatableQHashByteSetGO newUpdatableSet(Iterable<Byte> elements, int expectedSize) {
        if (elements instanceof ByteCollection) {
            SeparateKVByteQHash hash;
            if (elements instanceof SeparateKVByteQHash && (hash = (SeparateKVByteQHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableQHashByteSet set = new UpdatableQHashByteSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableQHashByteSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableQHashByteSetGO set = this.newUpdatableSet(size);
        for (byte e : elements) {
            set.add(e);
        }
        return set;
    }
}

