/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Set;
import net.openhft.collect.CharCollection;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.hash.CharQHashFactory;
import net.openhft.collect.impl.hash.ImmutableQHashCharSet;
import net.openhft.collect.impl.hash.ImmutableQHashCharSetGO;
import net.openhft.collect.impl.hash.MutableQHashCharSet;
import net.openhft.collect.impl.hash.MutableQHashCharSetGO;
import net.openhft.collect.impl.hash.SeparateKVCharQHash;
import net.openhft.collect.impl.hash.UpdatableQHashCharSet;
import net.openhft.collect.impl.hash.UpdatableQHashCharSetGO;
import net.openhft.collect.set.hash.HashCharSetFactory;

public abstract class QHashCharSetFactorySO
extends CharQHashFactory<MutableQHashCharSetGO>
implements HashCharSetFactory {
    QHashCharSetFactorySO(HashConfig hashConf, int defaultExpectedSize, char lower, char upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    @Override
    MutableQHashCharSetGO createNewMutable(int expectedSize, char free, char removed) {
        MutableQHashCharSet set = new MutableQHashCharSet();
        set.init(this.configWrapper, expectedSize, free, removed);
        return set;
    }

    MutableQHashCharSetGO uninitializedMutableSet() {
        return new MutableQHashCharSet();
    }

    UpdatableQHashCharSetGO uninitializedUpdatableSet() {
        return new UpdatableQHashCharSet();
    }

    ImmutableQHashCharSetGO uninitializedImmutableSet() {
        return new ImmutableQHashCharSet();
    }

    public MutableQHashCharSetGO newMutableSet(int expectedSize) {
        return (MutableQHashCharSetGO)this.newMutableHash(expectedSize);
    }

    public UpdatableQHashCharSetGO newUpdatableSet(int expectedSize) {
        UpdatableQHashCharSet set = new UpdatableQHashCharSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    public UpdatableQHashCharSetGO newUpdatableSet(Iterable<Character> elements, int expectedSize) {
        if (elements instanceof CharCollection) {
            SeparateKVCharQHash hash;
            if (elements instanceof SeparateKVCharQHash && (hash = (SeparateKVCharQHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableQHashCharSet set = new UpdatableQHashCharSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableQHashCharSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableQHashCharSetGO set = this.newUpdatableSet(size);
        for (char e : elements) {
            set.add(e);
        }
        return set;
    }
}

