/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.IntConsumer;
import javax.annotation.Nonnull;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.hash.HashContainerFactory;
import net.openhft.collect.hash.IntHashFactory;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.hash.ImmutableQHashIntSetGO;
import net.openhft.collect.impl.hash.LHashCapacities;
import net.openhft.collect.impl.hash.MutableQHashIntSetGO;
import net.openhft.collect.impl.hash.QHashIntSetFactorySO;
import net.openhft.collect.impl.hash.SeparateKVIntQHash;
import net.openhft.collect.impl.hash.UpdatableQHashIntSetGO;
import net.openhft.collect.set.hash.HashIntSet;
import net.openhft.collect.set.hash.HashIntSetFactory;
import net.openhft.function.Consumer;
import net.openhft.function.Predicate;

public abstract class QHashIntSetFactoryGO
extends QHashIntSetFactorySO {
    public QHashIntSetFactoryGO(HashConfig hashConf, int defaultExpectedSize, int lower, int upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    abstract HashIntSetFactory thisWith(HashConfig var1, int var2, int var3, int var4);

    abstract HashIntSetFactory lHashLikeThisWith(HashConfig var1, int var2, int var3, int var4);

    abstract HashIntSetFactory qHashLikeThisWith(HashConfig var1, int var2, int var3, int var4);

    public final HashIntSetFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash(hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public final HashIntSetFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize, this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public String toString() {
        return "HashIntSetFactory[" + this.commonString() + this.keySpecialString() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashIntSetFactory) {
            HashIntSetFactory factory = (HashIntSetFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals((IntHashFactory)factory);
        }
        return false;
    }

    public int hashCode() {
        return this.keySpecialHashCode(this.commonHashCode());
    }

    private UpdatableQHashIntSetGO shrunk(UpdatableQHashIntSetGO set) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(set)) {
            set.shrink();
        }
        return set;
    }

    public UpdatableQHashIntSetGO newUpdatableSet() {
        return this.newUpdatableSet(this.getDefaultExpectedSize());
    }

    public MutableQHashIntSetGO newMutableSet() {
        return this.newMutableSet(this.getDefaultExpectedSize());
    }

    private static int sizeOr(Iterable elems, int defaultSize) {
        return elems instanceof Collection ? ((Collection)elems).size() : defaultSize;
    }

    public UpdatableQHashIntSetGO newUpdatableSet(Iterable<Integer> elements) {
        return this.newUpdatableSet((Iterable)elements, QHashIntSetFactoryGO.sizeOr(elements, this.getDefaultExpectedSize()));
    }

    public UpdatableQHashIntSetGO newUpdatableSet(Iterable<Integer> elems1, Iterable<Integer> elems2) {
        long expectedSize = QHashIntSetFactoryGO.sizeOr(elems1, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, Containers.sizeAsInt(expectedSize += (long)QHashIntSetFactoryGO.sizeOr(elems2, 0)));
    }

    public UpdatableQHashIntSetGO newUpdatableSet(Iterable<Integer> elems1, Iterable<Integer> elems2, Iterable<Integer> elems3) {
        long expectedSize = QHashIntSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)QHashIntSetFactoryGO.sizeOr(elems2, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, Containers.sizeAsInt(expectedSize += (long)QHashIntSetFactoryGO.sizeOr(elems3, 0)));
    }

    public UpdatableQHashIntSetGO newUpdatableSet(Iterable<Integer> elems1, Iterable<Integer> elems2, Iterable<Integer> elems3, Iterable<Integer> elems4) {
        long expectedSize = QHashIntSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)QHashIntSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)QHashIntSetFactoryGO.sizeOr(elems3, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, Containers.sizeAsInt(expectedSize += (long)QHashIntSetFactoryGO.sizeOr(elems4, 0)));
    }

    public UpdatableQHashIntSetGO newUpdatableSet(Iterable<Integer> elems1, Iterable<Integer> elems2, Iterable<Integer> elems3, Iterable<Integer> elems4, Iterable<Integer> elems5) {
        long expectedSize = QHashIntSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)QHashIntSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)QHashIntSetFactoryGO.sizeOr(elems3, 0);
        expectedSize += (long)QHashIntSetFactoryGO.sizeOr(elems4, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, Containers.sizeAsInt(expectedSize += (long)QHashIntSetFactoryGO.sizeOr(elems5, 0)));
    }

    @Override
    public UpdatableQHashIntSetGO newUpdatableSet(Iterable<Integer> elements, int expectedSize) {
        return this.shrunk((UpdatableQHashIntSetGO)super.newUpdatableSet((Iterable)elements, expectedSize));
    }

    private static void addAll(UpdatableQHashIntSetGO set, Iterable<? extends Integer> elems) {
        if (elems instanceof Collection) {
            set.addAll((Collection)elems);
        } else {
            Iterator<? extends Integer> iterator = elems.iterator();
            while (iterator.hasNext()) {
                int e = iterator.next();
                set.add(e);
            }
        }
    }

    public UpdatableQHashIntSetGO newUpdatableSet(Iterable<Integer> elems1, Iterable<Integer> elems2, int expectedSize) {
        UpdatableQHashIntSetGO set = this.newUpdatableSet(expectedSize);
        QHashIntSetFactoryGO.addAll(set, elems1);
        QHashIntSetFactoryGO.addAll(set, elems2);
        return this.shrunk(set);
    }

    public UpdatableQHashIntSetGO newUpdatableSet(Iterable<Integer> elems1, Iterable<Integer> elems2, Iterable<Integer> elems3, int expectedSize) {
        UpdatableQHashIntSetGO set = this.newUpdatableSet(expectedSize);
        QHashIntSetFactoryGO.addAll(set, elems1);
        QHashIntSetFactoryGO.addAll(set, elems2);
        QHashIntSetFactoryGO.addAll(set, elems3);
        return this.shrunk(set);
    }

    public UpdatableQHashIntSetGO newUpdatableSet(Iterable<Integer> elems1, Iterable<Integer> elems2, Iterable<Integer> elems3, Iterable<Integer> elems4, int expectedSize) {
        UpdatableQHashIntSetGO set = this.newUpdatableSet(expectedSize);
        QHashIntSetFactoryGO.addAll(set, elems1);
        QHashIntSetFactoryGO.addAll(set, elems2);
        QHashIntSetFactoryGO.addAll(set, elems3);
        QHashIntSetFactoryGO.addAll(set, elems4);
        return this.shrunk(set);
    }

    public UpdatableQHashIntSetGO newUpdatableSet(Iterable<Integer> elems1, Iterable<Integer> elems2, Iterable<Integer> elems3, Iterable<Integer> elems4, Iterable<Integer> elems5, int expectedSize) {
        UpdatableQHashIntSetGO set = this.newUpdatableSet(expectedSize);
        QHashIntSetFactoryGO.addAll(set, elems1);
        QHashIntSetFactoryGO.addAll(set, elems2);
        QHashIntSetFactoryGO.addAll(set, elems3);
        QHashIntSetFactoryGO.addAll(set, elems4);
        QHashIntSetFactoryGO.addAll(set, elems5);
        return this.shrunk(set);
    }

    public UpdatableQHashIntSetGO newUpdatableSet(Iterator<Integer> elements) {
        return this.newUpdatableSet((Iterator)elements, this.getDefaultExpectedSize());
    }

    public UpdatableQHashIntSetGO newUpdatableSet(Iterator<Integer> elements, int expectedSize) {
        UpdatableQHashIntSetGO set = this.newUpdatableSet(expectedSize);
        while (elements.hasNext()) {
            set.add(elements.next());
        }
        return this.shrunk(set);
    }

    public UpdatableQHashIntSetGO newUpdatableSet(Consumer<IntConsumer> elementsSupplier) {
        return this.newUpdatableSet((Consumer)elementsSupplier, this.getDefaultExpectedSize());
    }

    public UpdatableQHashIntSetGO newUpdatableSet(Consumer<IntConsumer> elementsSupplier, int expectedSize) {
        final UpdatableQHashIntSetGO set = this.newUpdatableSet(expectedSize);
        elementsSupplier.accept((Object)new IntConsumer(){

            @Override
            public void accept(int e) {
                set.add(e);
            }
        });
        return this.shrunk(set);
    }

    public UpdatableQHashIntSetGO newUpdatableSet(int[] elements) {
        return this.newUpdatableSet(elements, elements.length);
    }

    public UpdatableQHashIntSetGO newUpdatableSet(int[] elements, int expectedSize) {
        UpdatableQHashIntSetGO set = this.newUpdatableSet(expectedSize);
        for (int e : elements) {
            set.add(e);
        }
        return this.shrunk(set);
    }

    public UpdatableQHashIntSetGO newUpdatableSet(Integer[] elements) {
        return this.newUpdatableSet(elements, elements.length);
    }

    public UpdatableQHashIntSetGO newUpdatableSet(Integer[] elements, int expectedSize) {
        UpdatableQHashIntSetGO set = this.newUpdatableSet(expectedSize);
        Integer[] integerArray = elements;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int e = integerArray[i];
            set.add(e);
        }
        return this.shrunk(set);
    }

    public UpdatableQHashIntSetGO newUpdatableSetOf(int e1) {
        UpdatableQHashIntSetGO set = this.newUpdatableSet(1);
        set.add(e1);
        return set;
    }

    public UpdatableQHashIntSetGO newUpdatableSetOf(int e1, int e2) {
        UpdatableQHashIntSetGO set = this.newUpdatableSet(2);
        set.add(e1);
        set.add(e2);
        return set;
    }

    public UpdatableQHashIntSetGO newUpdatableSetOf(int e1, int e2, int e3) {
        UpdatableQHashIntSetGO set = this.newUpdatableSet(3);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        return set;
    }

    public UpdatableQHashIntSetGO newUpdatableSetOf(int e1, int e2, int e3, int e4) {
        UpdatableQHashIntSetGO set = this.newUpdatableSet(4);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        return set;
    }

    public UpdatableQHashIntSetGO newUpdatableSetOf(int e1, int e2, int e3, int e4, int e5, int ... restElements) {
        UpdatableQHashIntSetGO set = this.newUpdatableSet(5 + restElements.length);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        for (int e : restElements) {
            set.add(e);
        }
        return this.shrunk(set);
    }

    public HashIntSet newMutableSet(Iterable<Integer> elements, int expectedSize) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    public HashIntSet newMutableSet(Iterable<Integer> elems1, Iterable<Integer> elems2, int expectedSize) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    public HashIntSet newMutableSet(Iterable<Integer> elems1, Iterable<Integer> elems2, Iterable<Integer> elems3, int expectedSize) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    public HashIntSet newMutableSet(Iterable<Integer> elems1, Iterable<Integer> elems2, Iterable<Integer> elems3, Iterable<Integer> elems4, int expectedSize) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    public HashIntSet newMutableSet(Iterable<Integer> elems1, Iterable<Integer> elems2, Iterable<Integer> elems3, Iterable<Integer> elems4, Iterable<Integer> elems5, int expectedSize) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    public HashIntSet newMutableSet(Iterable<Integer> elements) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    public HashIntSet newMutableSet(Iterable<Integer> elems1, Iterable<Integer> elems2) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    public HashIntSet newMutableSet(Iterable<Integer> elems1, Iterable<Integer> elems2, Iterable<Integer> elems3) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    public HashIntSet newMutableSet(Iterable<Integer> elems1, Iterable<Integer> elems2, Iterable<Integer> elems3, Iterable<Integer> elems4) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    public HashIntSet newMutableSet(Iterable<Integer> elems1, Iterable<Integer> elems2, Iterable<Integer> elems3, Iterable<Integer> elems4, Iterable<Integer> elems5) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    public HashIntSet newMutableSet(Iterator<Integer> elements) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    public HashIntSet newMutableSet(Iterator<Integer> elements, int expectedSize) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    public HashIntSet newMutableSet(Consumer<IntConsumer> elementsSupplier) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Consumer)elementsSupplier));
        return set;
    }

    public HashIntSet newMutableSet(Consumer<IntConsumer> elementsSupplier, int expectedSize) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Consumer)elementsSupplier, expectedSize));
        return set;
    }

    public HashIntSet newMutableSet(int[] elements) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    public HashIntSet newMutableSet(int[] elements, int expectedSize) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    public HashIntSet newMutableSet(Integer[] elements) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    public HashIntSet newMutableSet(Integer[] elements, int expectedSize) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    public HashIntSet newMutableSetOf(int e1) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1));
        return set;
    }

    public HashIntSet newMutableSetOf(int e1, int e2) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2));
        return set;
    }

    public HashIntSet newMutableSetOf(int e1, int e2, int e3) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3));
        return set;
    }

    public HashIntSet newMutableSetOf(int e1, int e2, int e3, int e4) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4));
        return set;
    }

    public HashIntSet newMutableSetOf(int e1, int e2, int e3, int e4, int e5, int ... restElements) {
        MutableQHashIntSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4, e5, restElements));
        return set;
    }

    public HashIntSet newImmutableSet(Iterable<Integer> elements, int expectedSize) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    public HashIntSet newImmutableSet(Iterable<Integer> elems1, Iterable<Integer> elems2, int expectedSize) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    public HashIntSet newImmutableSet(Iterable<Integer> elems1, Iterable<Integer> elems2, Iterable<Integer> elems3, int expectedSize) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    public HashIntSet newImmutableSet(Iterable<Integer> elems1, Iterable<Integer> elems2, Iterable<Integer> elems3, Iterable<Integer> elems4, int expectedSize) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    public HashIntSet newImmutableSet(Iterable<Integer> elems1, Iterable<Integer> elems2, Iterable<Integer> elems3, Iterable<Integer> elems4, Iterable<Integer> elems5, int expectedSize) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    public HashIntSet newImmutableSet(Iterable<Integer> elements) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    public HashIntSet newImmutableSet(Iterable<Integer> elems1, Iterable<Integer> elems2) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    public HashIntSet newImmutableSet(Iterable<Integer> elems1, Iterable<Integer> elems2, Iterable<Integer> elems3) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    public HashIntSet newImmutableSet(Iterable<Integer> elems1, Iterable<Integer> elems2, Iterable<Integer> elems3, Iterable<Integer> elems4) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    public HashIntSet newImmutableSet(Iterable<Integer> elems1, Iterable<Integer> elems2, Iterable<Integer> elems3, Iterable<Integer> elems4, Iterable<Integer> elems5) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    public HashIntSet newImmutableSet(Iterator<Integer> elements) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    public HashIntSet newImmutableSet(Iterator<Integer> elements, int expectedSize) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    public HashIntSet newImmutableSet(Consumer<IntConsumer> elementsSupplier) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Consumer)elementsSupplier));
        return set;
    }

    public HashIntSet newImmutableSet(Consumer<IntConsumer> elementsSupplier, int expectedSize) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVIntQHash)this.newUpdatableSet((Consumer)elementsSupplier, expectedSize));
        return set;
    }

    public HashIntSet newImmutableSet(int[] elements) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    public HashIntSet newImmutableSet(int[] elements, int expectedSize) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    public HashIntSet newImmutableSet(Integer[] elements) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    public HashIntSet newImmutableSet(Integer[] elements, int expectedSize) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    public HashIntSet newImmutableSetOf(int e1) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1));
        return set;
    }

    public HashIntSet newImmutableSetOf(int e1, int e2) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2));
        return set;
    }

    public HashIntSet newImmutableSetOf(int e1, int e2, int e3) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3));
        return set;
    }

    public HashIntSet newImmutableSetOf(int e1, int e2, int e3, int e4) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4));
        return set;
    }

    public HashIntSet newImmutableSetOf(int e1, int e2, int e3, int e4, int e5, int ... restElements) {
        ImmutableQHashIntSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4, e5, restElements));
        return set;
    }
}

