/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Set;
import net.openhft.collect.LongCollection;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.hash.ImmutableQHashLongSet;
import net.openhft.collect.impl.hash.ImmutableQHashLongSetGO;
import net.openhft.collect.impl.hash.LongQHashFactory;
import net.openhft.collect.impl.hash.MutableQHashLongSet;
import net.openhft.collect.impl.hash.MutableQHashLongSetGO;
import net.openhft.collect.impl.hash.SeparateKVLongQHash;
import net.openhft.collect.impl.hash.UpdatableQHashLongSet;
import net.openhft.collect.impl.hash.UpdatableQHashLongSetGO;
import net.openhft.collect.set.hash.HashLongSetFactory;

public abstract class QHashLongSetFactorySO
extends LongQHashFactory<MutableQHashLongSetGO>
implements HashLongSetFactory {
    QHashLongSetFactorySO(HashConfig hashConf, int defaultExpectedSize, long lower, long upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    @Override
    MutableQHashLongSetGO createNewMutable(int expectedSize, long free, long removed) {
        MutableQHashLongSet set = new MutableQHashLongSet();
        set.init(this.configWrapper, expectedSize, free, removed);
        return set;
    }

    MutableQHashLongSetGO uninitializedMutableSet() {
        return new MutableQHashLongSet();
    }

    UpdatableQHashLongSetGO uninitializedUpdatableSet() {
        return new UpdatableQHashLongSet();
    }

    ImmutableQHashLongSetGO uninitializedImmutableSet() {
        return new ImmutableQHashLongSet();
    }

    public MutableQHashLongSetGO newMutableSet(int expectedSize) {
        return (MutableQHashLongSetGO)this.newMutableHash(expectedSize);
    }

    public UpdatableQHashLongSetGO newUpdatableSet(int expectedSize) {
        UpdatableQHashLongSet set = new UpdatableQHashLongSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    public UpdatableQHashLongSetGO newUpdatableSet(Iterable<Long> elements, int expectedSize) {
        if (elements instanceof LongCollection) {
            SeparateKVLongQHash hash;
            if (elements instanceof SeparateKVLongQHash && (hash = (SeparateKVLongQHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableQHashLongSet set = new UpdatableQHashLongSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableQHashLongSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableQHashLongSetGO set = this.newUpdatableSet(size);
        for (long e : elements) {
            set.add(e);
        }
        return set;
    }
}

