/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.hash.ImmutableQHashObjSet;
import net.openhft.collect.impl.hash.ImmutableQHashObjSetGO;
import net.openhft.collect.impl.hash.LHashObjSetFactoryImpl;
import net.openhft.collect.impl.hash.MutableQHashObjSet;
import net.openhft.collect.impl.hash.MutableQHashObjSetGO;
import net.openhft.collect.impl.hash.QHashObjSetFactoryGO;
import net.openhft.collect.impl.hash.UpdatableQHashObjSet;
import net.openhft.collect.impl.hash.UpdatableQHashObjSetGO;
import net.openhft.collect.set.hash.HashObjSetFactory;

public final class QHashObjSetFactoryImpl<E>
extends QHashObjSetFactoryGO<E> {
    public QHashObjSetFactoryImpl() {
        this(HashConfig.getDefault(), 10, false);
    }

    public QHashObjSetFactoryImpl(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
        super(hashConf, defaultExpectedSize, isNullKeyAllowed);
    }

    public <E2> HashObjSetFactory<E2> withEquivalence(@Nullable Equivalence<E2> equivalence) {
        if (equivalence == null) {
            return this;
        }
        return new WithCustomEquivalence<E2>(this.getHashConfig(), this.getDefaultExpectedSize(), this.isNullKeyAllowed(), equivalence);
    }

    public HashObjSetFactory<E> withNullKeyAllowed(boolean nullAllowed) {
        if (nullAllowed == this.isNullKeyAllowed()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), this.getDefaultExpectedSize(), nullAllowed);
    }

    @Override
    HashObjSetFactory<E> thisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
        return new QHashObjSetFactoryImpl<E>(hashConf, defaultExpectedSize, isNullKeyAllowed);
    }

    @Override
    HashObjSetFactory<E> qHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
        return new QHashObjSetFactoryImpl<E>(hashConf, defaultExpectedSize, isNullKeyAllowed);
    }

    @Override
    HashObjSetFactory<E> lHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
        return new LHashObjSetFactoryImpl(hashConf, defaultExpectedSize, isNullKeyAllowed);
    }

    static final class WithCustomEquivalence<E>
    extends QHashObjSetFactoryGO<E> {
        final Equivalence<E> equivalence;

        public WithCustomEquivalence(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed, Equivalence<E> equivalence) {
            super(hashConf, defaultExpectedSize, isNullKeyAllowed);
            this.equivalence = equivalence;
        }

        @Override
        public Equivalence<E> getEquivalence() {
            return this.equivalence;
        }

        @Override
        <E2 extends E> MutableQHashObjSetGO<E2> uninitializedMutableSet() {
            MutableQHashObjSet.WithCustomEquivalence set = new MutableQHashObjSet.WithCustomEquivalence();
            set.equivalence = this.equivalence;
            return set;
        }

        @Override
        <E2 extends E> UpdatableQHashObjSetGO<E2> uninitializedUpdatableSet() {
            UpdatableQHashObjSet.WithCustomEquivalence set = new UpdatableQHashObjSet.WithCustomEquivalence();
            set.equivalence = this.equivalence;
            return set;
        }

        @Override
        <E2 extends E> ImmutableQHashObjSetGO<E2> uninitializedImmutableSet() {
            ImmutableQHashObjSet.WithCustomEquivalence set = new ImmutableQHashObjSet.WithCustomEquivalence();
            set.equivalence = this.equivalence;
            return set;
        }

        public <E2> HashObjSetFactory<E2> withEquivalence(@Nullable Equivalence<E2> equivalence) {
            if (equivalence == null) {
                return new QHashObjSetFactoryImpl(this.getHashConfig(), this.getDefaultExpectedSize(), this.isNullKeyAllowed());
            }
            if (this.equivalence.equals(equivalence)) {
                return this;
            }
            return new WithCustomEquivalence<E2>(this.getHashConfig(), this.getDefaultExpectedSize(), this.isNullKeyAllowed(), equivalence);
        }

        public HashObjSetFactory<E> withNullKeyAllowed(boolean nullAllowed) {
            if (nullAllowed == this.isNullKeyAllowed()) {
                return this;
            }
            return this.thisWith(this.getHashConfig(), this.getDefaultExpectedSize(), nullAllowed);
        }

        @Override
        HashObjSetFactory<E> thisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
            return new WithCustomEquivalence<E>(hashConf, defaultExpectedSize, isNullKeyAllowed, this.equivalence);
        }

        @Override
        HashObjSetFactory<E> qHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
            return new WithCustomEquivalence<E>(hashConf, defaultExpectedSize, isNullKeyAllowed, this.equivalence);
        }

        @Override
        HashObjSetFactory<E> lHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
            return new LHashObjSetFactoryImpl.WithCustomEquivalence<E>(hashConf, defaultExpectedSize, isNullKeyAllowed, this.equivalence);
        }
    }
}

