/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.hash.ImmutableQHashObjSet;
import net.openhft.collect.impl.hash.ImmutableQHashObjSetGO;
import net.openhft.collect.impl.hash.MutableQHashObjSet;
import net.openhft.collect.impl.hash.MutableQHashObjSetGO;
import net.openhft.collect.impl.hash.ObjHashFactorySO;
import net.openhft.collect.impl.hash.SeparateKVObjQHash;
import net.openhft.collect.impl.hash.UpdatableQHashObjSet;
import net.openhft.collect.impl.hash.UpdatableQHashObjSetGO;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.collect.set.hash.HashObjSetFactory;

public abstract class QHashObjSetFactorySO<E>
extends ObjHashFactorySO<E>
implements HashObjSetFactory<E> {
    QHashObjSetFactorySO(HashConfig hashConf, int defaultExpectedSize, boolean isNullAllowed) {
        super(hashConf, defaultExpectedSize, isNullAllowed);
    }

    String keySpecialString() {
        return ",equivalence=" + this.getEquivalence() + ",nullKeyAllowed=" + this.isNullKeyAllowed();
    }

    boolean keySpecialEquals(HashObjSetFactory<?> other) {
        return NullableObjects.equals(this.getEquivalence(), other.getEquivalence()) && this.isNullKeyAllowed() == other.isNullKeyAllowed();
    }

    @Override
    @Nullable
    public Equivalence<E> getEquivalence() {
        return null;
    }

    <E2 extends E> MutableQHashObjSetGO<E2> uninitializedMutableSet() {
        return new MutableQHashObjSet();
    }

    <E2 extends E> UpdatableQHashObjSetGO<E2> uninitializedUpdatableSet() {
        return new UpdatableQHashObjSet();
    }

    <E2 extends E> ImmutableQHashObjSetGO<E2> uninitializedImmutableSet() {
        return new ImmutableQHashObjSet();
    }

    public <E2 extends E> MutableQHashObjSetGO<E2> newMutableSet(int expectedSize) {
        MutableQHashObjSetGO<E2> set = this.uninitializedMutableSet();
        set.init(this.configWrapper, expectedSize);
        return set;
    }

    public <E2 extends E> UpdatableQHashObjSetGO<E2> newUpdatableSet(int expectedSize) {
        UpdatableQHashObjSetGO<E2> set = this.uninitializedUpdatableSet();
        set.init(this.configWrapper, expectedSize);
        return set;
    }

    public <E2 extends E> UpdatableQHashObjSetGO<E2> newUpdatableSet(Iterable<? extends E2> elements, int expectedSize) {
        if (elements instanceof ObjCollection) {
            int size;
            if (elements instanceof ObjSet) {
                SeparateKVObjQHash hash;
                ObjSet elemSet = (ObjSet)elements;
                if (elements instanceof SeparateKVObjQHash && (hash = (SeparateKVObjQHash)((Object)elements)).hashConfig().equals(this.hashConf) && NullableObjects.equals(elemSet.equivalence(), this.getEquivalence())) {
                    UpdatableQHashObjSetGO<E2> set = this.uninitializedUpdatableSet();
                    set.copy(hash);
                    return set;
                }
                size = NullableObjects.equals(elemSet.equivalence(), this.getEquivalence()) ? elemSet.size() : expectedSize;
            } else {
                size = expectedSize;
            }
            HashObjSet set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = this.getEquivalence() == null && elements instanceof Set ? ((Set)elements).size() : expectedSize;
        HashObjSet set = this.newUpdatableSet(size);
        for (E2 e : elements) {
            set.add(e);
        }
        return set;
    }
}

