/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.collect.hash.ByteHashFactory;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.hash.HashContainerFactory;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ImmutableQHashParallelKVByteByteMapGO;
import net.openhft.collect.impl.hash.LHashCapacities;
import net.openhft.collect.impl.hash.MutableQHashParallelKVByteByteMapGO;
import net.openhft.collect.impl.hash.ParallelKVByteByteQHash;
import net.openhft.collect.impl.hash.QHashParallelKVByteByteMapFactorySO;
import net.openhft.collect.impl.hash.UpdatableQHashParallelKVByteByteMapGO;
import net.openhft.collect.map.hash.HashByteByteMap;
import net.openhft.collect.map.hash.HashByteByteMapFactory;
import net.openhft.function.ByteByteConsumer;
import net.openhft.function.Consumer;
import net.openhft.function.Predicate;

public abstract class QHashParallelKVByteByteMapFactoryGO
extends QHashParallelKVByteByteMapFactorySO {
    QHashParallelKVByteByteMapFactoryGO(HashConfig hashConf, int defaultExpectedSize, byte lower, byte upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    abstract HashByteByteMapFactory thisWith(HashConfig var1, int var2, byte var3, byte var4);

    abstract HashByteByteMapFactory lHashLikeThisWith(HashConfig var1, int var2, byte var3, byte var4);

    abstract HashByteByteMapFactory qHashLikeThisWith(HashConfig var1, int var2, byte var3, byte var4);

    public final HashByteByteMapFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash(hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public final HashByteByteMapFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize, this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    final HashByteByteMapFactory withDomain(byte lower, byte upper) {
        if (lower == this.getLowerKeyDomainBound() && upper == this.getUpperKeyDomainBound()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), this.getDefaultExpectedSize(), lower, upper);
    }

    public final HashByteByteMapFactory withKeysDomain(byte lower, byte upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minPossibleKey shouldn't be greater than maxPossibleKey");
        }
        return this.withDomain(lower, upper);
    }

    public final HashByteByteMapFactory withKeysDomainComplement(byte lower, byte upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minImpossibleKey shouldn't be greater than maxImpossibleKey");
        }
        return this.withDomain((byte)(upper + 1), (byte)(lower - 1));
    }

    public String toString() {
        return "HashByteByteMapFactory[" + this.commonString() + this.keySpecialString() + ",defaultValue=" + this.getDefaultValue() + "]";
    }

    public int hashCode() {
        int hashCode = this.keySpecialHashCode(this.commonHashCode());
        hashCode = hashCode * 31 + Primitives.hashCode(this.getDefaultValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashByteByteMapFactory) {
            HashByteByteMapFactory factory = (HashByteByteMapFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals((ByteHashFactory)factory) && Byte.valueOf(this.getDefaultValue()).equals(factory.getDefaultValue());
        }
        return false;
    }

    public byte getDefaultValue() {
        return 0;
    }

    private UpdatableQHashParallelKVByteByteMapGO shrunk(UpdatableQHashParallelKVByteByteMapGO map) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(map)) {
            map.shrink();
        }
        return map;
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMap() {
        return this.newUpdatableMap(this.getDefaultExpectedSize());
    }

    public MutableQHashParallelKVByteByteMapGO newMutableMap() {
        return this.newMutableMap(this.getDefaultExpectedSize());
    }

    @Override
    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMap(Map<Byte, Byte> map) {
        return this.shrunk((UpdatableQHashParallelKVByteByteMapGO)super.newUpdatableMap((Map)map));
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2) {
        long expectedSize = map1.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, Containers.sizeAsInt(expectedSize += (long)map2.size()));
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2, Map<Byte, Byte> map3) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, Containers.sizeAsInt(expectedSize += (long)map3.size()));
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2, Map<Byte, Byte> map3, Map<Byte, Byte> map4) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, Containers.sizeAsInt(expectedSize += (long)map4.size()));
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2, Map<Byte, Byte> map3, Map<Byte, Byte> map4, Map<Byte, Byte> map5) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        expectedSize += (long)map4.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, Containers.sizeAsInt(expectedSize += (long)map5.size()));
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2, int expectedSize) {
        UpdatableQHashParallelKVByteByteMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Byte, ? extends Byte>)map1);
        map.putAll((Map<? extends Byte, ? extends Byte>)map2);
        return this.shrunk(map);
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2, Map<Byte, Byte> map3, int expectedSize) {
        UpdatableQHashParallelKVByteByteMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Byte, ? extends Byte>)map1);
        map.putAll((Map<? extends Byte, ? extends Byte>)map2);
        map.putAll((Map<? extends Byte, ? extends Byte>)map3);
        return this.shrunk(map);
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2, Map<Byte, Byte> map3, Map<Byte, Byte> map4, int expectedSize) {
        UpdatableQHashParallelKVByteByteMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Byte, ? extends Byte>)map1);
        map.putAll((Map<? extends Byte, ? extends Byte>)map2);
        map.putAll((Map<? extends Byte, ? extends Byte>)map3);
        map.putAll((Map<? extends Byte, ? extends Byte>)map4);
        return this.shrunk(map);
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2, Map<Byte, Byte> map3, Map<Byte, Byte> map4, Map<Byte, Byte> map5, int expectedSize) {
        UpdatableQHashParallelKVByteByteMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Byte, ? extends Byte>)map1);
        map.putAll((Map<? extends Byte, ? extends Byte>)map2);
        map.putAll((Map<? extends Byte, ? extends Byte>)map3);
        map.putAll((Map<? extends Byte, ? extends Byte>)map4);
        map.putAll((Map<? extends Byte, ? extends Byte>)map5);
        return this.shrunk(map);
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMap(Consumer<ByteByteConsumer> entriesSupplier) {
        return this.newUpdatableMap((Consumer)entriesSupplier, this.getDefaultExpectedSize());
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMap(Consumer<ByteByteConsumer> entriesSupplier, int expectedSize) {
        final UpdatableQHashParallelKVByteByteMapGO map = this.newUpdatableMap(expectedSize);
        entriesSupplier.accept((Object)new ByteByteConsumer(){

            public void accept(byte k, byte v) {
                map.put(k, v);
            }
        });
        return this.shrunk(map);
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMap(byte[] keys, byte[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMap(byte[] keys, byte[] values, int expectedSize) {
        UpdatableQHashParallelKVByteByteMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMap(Byte[] keys, Byte[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMap(Byte[] keys, Byte[] values, int expectedSize) {
        UpdatableQHashParallelKVByteByteMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMap(Iterable<Byte> keys, Iterable<Byte> values) {
        int expectedSize = keys instanceof Collection ? ((Collection)keys).size() : this.getDefaultExpectedSize();
        return this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize);
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMap(Iterable<Byte> keys, Iterable<Byte> values, int expectedSize) {
        UpdatableQHashParallelKVByteByteMapGO map = this.newUpdatableMap(expectedSize);
        Iterator<Byte> keysIt = keys.iterator();
        Iterator<Byte> valuesIt = values.iterator();
        try {
            while (keysIt.hasNext()) {
                map.put(keysIt.next(), valuesIt.next());
            }
            return this.shrunk(map);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("keys and values iterables must have the same size", e);
        }
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMapOf(byte k1, byte v1) {
        UpdatableQHashParallelKVByteByteMapGO map = this.newUpdatableMap(1);
        map.put(k1, v1);
        return map;
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMapOf(byte k1, byte v1, byte k2, byte v2) {
        UpdatableQHashParallelKVByteByteMapGO map = this.newUpdatableMap(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMapOf(byte k1, byte v1, byte k2, byte v2, byte k3, byte v3) {
        UpdatableQHashParallelKVByteByteMapGO map = this.newUpdatableMap(3);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMapOf(byte k1, byte v1, byte k2, byte v2, byte k3, byte v3, byte k4, byte v4) {
        UpdatableQHashParallelKVByteByteMapGO map = this.newUpdatableMap(4);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public UpdatableQHashParallelKVByteByteMapGO newUpdatableMapOf(byte k1, byte v1, byte k2, byte v2, byte k3, byte v3, byte k4, byte v4, byte k5, byte v5) {
        UpdatableQHashParallelKVByteByteMapGO map = this.newUpdatableMap(5);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public HashByteByteMap newMutableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2, int expectedSize) {
        MutableQHashParallelKVByteByteMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVByteByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashByteByteMap newMutableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2, Map<Byte, Byte> map3, int expectedSize) {
        MutableQHashParallelKVByteByteMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVByteByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashByteByteMap newMutableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2, Map<Byte, Byte> map3, Map<Byte, Byte> map4, int expectedSize) {
        MutableQHashParallelKVByteByteMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVByteByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashByteByteMap newMutableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2, Map<Byte, Byte> map3, Map<Byte, Byte> map4, Map<Byte, Byte> map5, int expectedSize) {
        MutableQHashParallelKVByteByteMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVByteByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashByteByteMap newMutableMap(Map<Byte, Byte> map) {
        MutableQHashParallelKVByteByteMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVByteByteQHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashByteByteMap newMutableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2) {
        MutableQHashParallelKVByteByteMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVByteByteQHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashByteByteMap newMutableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2, Map<Byte, Byte> map3) {
        MutableQHashParallelKVByteByteMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVByteByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashByteByteMap newMutableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2, Map<Byte, Byte> map3, Map<Byte, Byte> map4) {
        MutableQHashParallelKVByteByteMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVByteByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashByteByteMap newMutableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2, Map<Byte, Byte> map3, Map<Byte, Byte> map4, Map<Byte, Byte> map5) {
        MutableQHashParallelKVByteByteMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVByteByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashByteByteMap newMutableMap(Consumer<ByteByteConsumer> entriesSupplier) {
        MutableQHashParallelKVByteByteMapGO map = this.uninitializedMutableMap();
        map.move((ParallelKVByteByteQHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashByteByteMap newMutableMap(Consumer<ByteByteConsumer> entriesSupplier, int expectedSize) {
        MutableQHashParallelKVByteByteMapGO map = this.uninitializedMutableMap();
        map.move((ParallelKVByteByteQHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashByteByteMap newMutableMap(byte[] keys, byte[] values) {
        MutableQHashParallelKVByteByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashByteByteMap newMutableMap(byte[] keys, byte[] values, int expectedSize) {
        MutableQHashParallelKVByteByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashByteByteMap newMutableMap(Byte[] keys, Byte[] values) {
        MutableQHashParallelKVByteByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashByteByteMap newMutableMap(Byte[] keys, Byte[] values, int expectedSize) {
        MutableQHashParallelKVByteByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashByteByteMap newMutableMap(Iterable<Byte> keys, Iterable<Byte> values) {
        MutableQHashParallelKVByteByteMapGO map = this.uninitializedMutableMap();
        map.move((ParallelKVByteByteQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashByteByteMap newMutableMap(Iterable<Byte> keys, Iterable<Byte> values, int expectedSize) {
        MutableQHashParallelKVByteByteMapGO map = this.uninitializedMutableMap();
        map.move((ParallelKVByteByteQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashByteByteMap newMutableMapOf(byte k1, byte v1) {
        MutableQHashParallelKVByteByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashByteByteMap newMutableMapOf(byte k1, byte v1, byte k2, byte v2) {
        MutableQHashParallelKVByteByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashByteByteMap newMutableMapOf(byte k1, byte v1, byte k2, byte v2, byte k3, byte v3) {
        MutableQHashParallelKVByteByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashByteByteMap newMutableMapOf(byte k1, byte v1, byte k2, byte v2, byte k3, byte v3, byte k4, byte v4) {
        MutableQHashParallelKVByteByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashByteByteMap newMutableMapOf(byte k1, byte v1, byte k2, byte v2, byte k3, byte v3, byte k4, byte v4, byte k5, byte v5) {
        MutableQHashParallelKVByteByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }

    public HashByteByteMap newImmutableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2, int expectedSize) {
        ImmutableQHashParallelKVByteByteMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVByteByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashByteByteMap newImmutableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2, Map<Byte, Byte> map3, int expectedSize) {
        ImmutableQHashParallelKVByteByteMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVByteByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashByteByteMap newImmutableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2, Map<Byte, Byte> map3, Map<Byte, Byte> map4, int expectedSize) {
        ImmutableQHashParallelKVByteByteMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVByteByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashByteByteMap newImmutableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2, Map<Byte, Byte> map3, Map<Byte, Byte> map4, Map<Byte, Byte> map5, int expectedSize) {
        ImmutableQHashParallelKVByteByteMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVByteByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashByteByteMap newImmutableMap(Map<Byte, Byte> map) {
        ImmutableQHashParallelKVByteByteMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVByteByteQHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashByteByteMap newImmutableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2) {
        ImmutableQHashParallelKVByteByteMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVByteByteQHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashByteByteMap newImmutableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2, Map<Byte, Byte> map3) {
        ImmutableQHashParallelKVByteByteMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVByteByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashByteByteMap newImmutableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2, Map<Byte, Byte> map3, Map<Byte, Byte> map4) {
        ImmutableQHashParallelKVByteByteMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVByteByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashByteByteMap newImmutableMap(Map<Byte, Byte> map1, Map<Byte, Byte> map2, Map<Byte, Byte> map3, Map<Byte, Byte> map4, Map<Byte, Byte> map5) {
        ImmutableQHashParallelKVByteByteMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVByteByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashByteByteMap newImmutableMap(Consumer<ByteByteConsumer> entriesSupplier) {
        ImmutableQHashParallelKVByteByteMapGO map = this.uninitializedImmutableMap();
        map.move((ParallelKVByteByteQHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashByteByteMap newImmutableMap(Consumer<ByteByteConsumer> entriesSupplier, int expectedSize) {
        ImmutableQHashParallelKVByteByteMapGO map = this.uninitializedImmutableMap();
        map.move((ParallelKVByteByteQHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashByteByteMap newImmutableMap(byte[] keys, byte[] values) {
        ImmutableQHashParallelKVByteByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashByteByteMap newImmutableMap(byte[] keys, byte[] values, int expectedSize) {
        ImmutableQHashParallelKVByteByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashByteByteMap newImmutableMap(Byte[] keys, Byte[] values) {
        ImmutableQHashParallelKVByteByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashByteByteMap newImmutableMap(Byte[] keys, Byte[] values, int expectedSize) {
        ImmutableQHashParallelKVByteByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashByteByteMap newImmutableMap(Iterable<Byte> keys, Iterable<Byte> values) {
        ImmutableQHashParallelKVByteByteMapGO map = this.uninitializedImmutableMap();
        map.move((ParallelKVByteByteQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashByteByteMap newImmutableMap(Iterable<Byte> keys, Iterable<Byte> values, int expectedSize) {
        ImmutableQHashParallelKVByteByteMapGO map = this.uninitializedImmutableMap();
        map.move((ParallelKVByteByteQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashByteByteMap newImmutableMapOf(byte k1, byte v1) {
        ImmutableQHashParallelKVByteByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashByteByteMap newImmutableMapOf(byte k1, byte v1, byte k2, byte v2) {
        ImmutableQHashParallelKVByteByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashByteByteMap newImmutableMapOf(byte k1, byte v1, byte k2, byte v2, byte k3, byte v3) {
        ImmutableQHashParallelKVByteByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashByteByteMap newImmutableMapOf(byte k1, byte v1, byte k2, byte v2, byte k3, byte v3, byte k4, byte v4) {
        ImmutableQHashParallelKVByteByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashByteByteMap newImmutableMapOf(byte k1, byte v1, byte k2, byte v2, byte k3, byte v3, byte k4, byte v4, byte k5, byte v5) {
        ImmutableQHashParallelKVByteByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }
}

