/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.hash.HashContainerFactory;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ImmutableQHashParallelKVDoubleLongMapGO;
import net.openhft.collect.impl.hash.LHashCapacities;
import net.openhft.collect.impl.hash.MutableQHashParallelKVDoubleLongMapGO;
import net.openhft.collect.impl.hash.ParallelKVDoubleLongQHash;
import net.openhft.collect.impl.hash.QHashParallelKVDoubleLongMapFactorySO;
import net.openhft.collect.impl.hash.UpdatableQHashParallelKVDoubleLongMapGO;
import net.openhft.collect.map.hash.HashDoubleLongMap;
import net.openhft.collect.map.hash.HashDoubleLongMapFactory;
import net.openhft.function.Consumer;
import net.openhft.function.DoubleLongConsumer;
import net.openhft.function.Predicate;

public abstract class QHashParallelKVDoubleLongMapFactoryGO
extends QHashParallelKVDoubleLongMapFactorySO {
    QHashParallelKVDoubleLongMapFactoryGO(HashConfig hashConf, int defaultExpectedSize) {
        super(hashConf, defaultExpectedSize);
    }

    abstract HashDoubleLongMapFactory thisWith(HashConfig var1, int var2);

    abstract HashDoubleLongMapFactory lHashLikeThisWith(HashConfig var1, int var2);

    abstract HashDoubleLongMapFactory qHashLikeThisWith(HashConfig var1, int var2);

    public final HashDoubleLongMapFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash(hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize());
    }

    public final HashDoubleLongMapFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize);
    }

    public String toString() {
        return "HashDoubleLongMapFactory[" + this.commonString() + this.keySpecialString() + ",defaultValue=" + this.getDefaultValue() + "]";
    }

    public int hashCode() {
        int hashCode = this.keySpecialHashCode(this.commonHashCode());
        hashCode = hashCode * 31 + Primitives.hashCode(this.getDefaultValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashDoubleLongMapFactory) {
            HashDoubleLongMapFactory factory = (HashDoubleLongMapFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals(factory) && Long.valueOf(this.getDefaultValue()).equals(factory.getDefaultValue());
        }
        return false;
    }

    public long getDefaultValue() {
        return 0L;
    }

    private UpdatableQHashParallelKVDoubleLongMapGO shrunk(UpdatableQHashParallelKVDoubleLongMapGO map) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(map)) {
            map.shrink();
        }
        return map;
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMap() {
        return this.newUpdatableMap(this.getDefaultExpectedSize());
    }

    public MutableQHashParallelKVDoubleLongMapGO newMutableMap() {
        return this.newMutableMap(this.getDefaultExpectedSize());
    }

    @Override
    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMap(Map<Double, Long> map) {
        return this.shrunk((UpdatableQHashParallelKVDoubleLongMapGO)super.newUpdatableMap((Map)map));
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMap(Map<Double, Long> map1, Map<Double, Long> map2) {
        long expectedSize = map1.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, Containers.sizeAsInt(expectedSize += (long)map2.size()));
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMap(Map<Double, Long> map1, Map<Double, Long> map2, Map<Double, Long> map3) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, Containers.sizeAsInt(expectedSize += (long)map3.size()));
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMap(Map<Double, Long> map1, Map<Double, Long> map2, Map<Double, Long> map3, Map<Double, Long> map4) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, Containers.sizeAsInt(expectedSize += (long)map4.size()));
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMap(Map<Double, Long> map1, Map<Double, Long> map2, Map<Double, Long> map3, Map<Double, Long> map4, Map<Double, Long> map5) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        expectedSize += (long)map4.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, Containers.sizeAsInt(expectedSize += (long)map5.size()));
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMap(Map<Double, Long> map1, Map<Double, Long> map2, int expectedSize) {
        UpdatableQHashParallelKVDoubleLongMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Double, ? extends Long>)map1);
        map.putAll((Map<? extends Double, ? extends Long>)map2);
        return this.shrunk(map);
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMap(Map<Double, Long> map1, Map<Double, Long> map2, Map<Double, Long> map3, int expectedSize) {
        UpdatableQHashParallelKVDoubleLongMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Double, ? extends Long>)map1);
        map.putAll((Map<? extends Double, ? extends Long>)map2);
        map.putAll((Map<? extends Double, ? extends Long>)map3);
        return this.shrunk(map);
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMap(Map<Double, Long> map1, Map<Double, Long> map2, Map<Double, Long> map3, Map<Double, Long> map4, int expectedSize) {
        UpdatableQHashParallelKVDoubleLongMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Double, ? extends Long>)map1);
        map.putAll((Map<? extends Double, ? extends Long>)map2);
        map.putAll((Map<? extends Double, ? extends Long>)map3);
        map.putAll((Map<? extends Double, ? extends Long>)map4);
        return this.shrunk(map);
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMap(Map<Double, Long> map1, Map<Double, Long> map2, Map<Double, Long> map3, Map<Double, Long> map4, Map<Double, Long> map5, int expectedSize) {
        UpdatableQHashParallelKVDoubleLongMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Double, ? extends Long>)map1);
        map.putAll((Map<? extends Double, ? extends Long>)map2);
        map.putAll((Map<? extends Double, ? extends Long>)map3);
        map.putAll((Map<? extends Double, ? extends Long>)map4);
        map.putAll((Map<? extends Double, ? extends Long>)map5);
        return this.shrunk(map);
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMap(Consumer<DoubleLongConsumer> entriesSupplier) {
        return this.newUpdatableMap((Consumer)entriesSupplier, this.getDefaultExpectedSize());
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMap(Consumer<DoubleLongConsumer> entriesSupplier, int expectedSize) {
        final UpdatableQHashParallelKVDoubleLongMapGO map = this.newUpdatableMap(expectedSize);
        entriesSupplier.accept((Object)new DoubleLongConsumer(){

            public void accept(double k, long v) {
                map.put(k, v);
            }
        });
        return this.shrunk(map);
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMap(double[] keys, long[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMap(double[] keys, long[] values, int expectedSize) {
        UpdatableQHashParallelKVDoubleLongMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMap(Double[] keys, Long[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMap(Double[] keys, Long[] values, int expectedSize) {
        UpdatableQHashParallelKVDoubleLongMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMap(Iterable<Double> keys, Iterable<Long> values) {
        int expectedSize = keys instanceof Collection ? ((Collection)keys).size() : this.getDefaultExpectedSize();
        return this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize);
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMap(Iterable<Double> keys, Iterable<Long> values, int expectedSize) {
        UpdatableQHashParallelKVDoubleLongMapGO map = this.newUpdatableMap(expectedSize);
        Iterator<Double> keysIt = keys.iterator();
        Iterator<Long> valuesIt = values.iterator();
        try {
            while (keysIt.hasNext()) {
                map.put(keysIt.next(), valuesIt.next());
            }
            return this.shrunk(map);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("keys and values iterables must have the same size", e);
        }
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMapOf(double k1, long v1) {
        UpdatableQHashParallelKVDoubleLongMapGO map = this.newUpdatableMap(1);
        map.put(k1, v1);
        return map;
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMapOf(double k1, long v1, double k2, long v2) {
        UpdatableQHashParallelKVDoubleLongMapGO map = this.newUpdatableMap(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMapOf(double k1, long v1, double k2, long v2, double k3, long v3) {
        UpdatableQHashParallelKVDoubleLongMapGO map = this.newUpdatableMap(3);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMapOf(double k1, long v1, double k2, long v2, double k3, long v3, double k4, long v4) {
        UpdatableQHashParallelKVDoubleLongMapGO map = this.newUpdatableMap(4);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public UpdatableQHashParallelKVDoubleLongMapGO newUpdatableMapOf(double k1, long v1, double k2, long v2, double k3, long v3, double k4, long v4, double k5, long v5) {
        UpdatableQHashParallelKVDoubleLongMapGO map = this.newUpdatableMap(5);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public HashDoubleLongMap newMutableMap(Map<Double, Long> map1, Map<Double, Long> map2, int expectedSize) {
        MutableQHashParallelKVDoubleLongMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashDoubleLongMap newMutableMap(Map<Double, Long> map1, Map<Double, Long> map2, Map<Double, Long> map3, int expectedSize) {
        MutableQHashParallelKVDoubleLongMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashDoubleLongMap newMutableMap(Map<Double, Long> map1, Map<Double, Long> map2, Map<Double, Long> map3, Map<Double, Long> map4, int expectedSize) {
        MutableQHashParallelKVDoubleLongMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashDoubleLongMap newMutableMap(Map<Double, Long> map1, Map<Double, Long> map2, Map<Double, Long> map3, Map<Double, Long> map4, Map<Double, Long> map5, int expectedSize) {
        MutableQHashParallelKVDoubleLongMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashDoubleLongMap newMutableMap(Map<Double, Long> map) {
        MutableQHashParallelKVDoubleLongMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashDoubleLongMap newMutableMap(Map<Double, Long> map1, Map<Double, Long> map2) {
        MutableQHashParallelKVDoubleLongMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashDoubleLongMap newMutableMap(Map<Double, Long> map1, Map<Double, Long> map2, Map<Double, Long> map3) {
        MutableQHashParallelKVDoubleLongMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashDoubleLongMap newMutableMap(Map<Double, Long> map1, Map<Double, Long> map2, Map<Double, Long> map3, Map<Double, Long> map4) {
        MutableQHashParallelKVDoubleLongMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashDoubleLongMap newMutableMap(Map<Double, Long> map1, Map<Double, Long> map2, Map<Double, Long> map3, Map<Double, Long> map4, Map<Double, Long> map5) {
        MutableQHashParallelKVDoubleLongMapGO res = this.uninitializedMutableMap();
        res.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashDoubleLongMap newMutableMap(Consumer<DoubleLongConsumer> entriesSupplier) {
        MutableQHashParallelKVDoubleLongMapGO map = this.uninitializedMutableMap();
        map.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashDoubleLongMap newMutableMap(Consumer<DoubleLongConsumer> entriesSupplier, int expectedSize) {
        MutableQHashParallelKVDoubleLongMapGO map = this.uninitializedMutableMap();
        map.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashDoubleLongMap newMutableMap(double[] keys, long[] values) {
        MutableQHashParallelKVDoubleLongMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashDoubleLongMap newMutableMap(double[] keys, long[] values, int expectedSize) {
        MutableQHashParallelKVDoubleLongMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashDoubleLongMap newMutableMap(Double[] keys, Long[] values) {
        MutableQHashParallelKVDoubleLongMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashDoubleLongMap newMutableMap(Double[] keys, Long[] values, int expectedSize) {
        MutableQHashParallelKVDoubleLongMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashDoubleLongMap newMutableMap(Iterable<Double> keys, Iterable<Long> values) {
        MutableQHashParallelKVDoubleLongMapGO map = this.uninitializedMutableMap();
        map.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashDoubleLongMap newMutableMap(Iterable<Double> keys, Iterable<Long> values, int expectedSize) {
        MutableQHashParallelKVDoubleLongMapGO map = this.uninitializedMutableMap();
        map.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashDoubleLongMap newMutableMapOf(double k1, long v1) {
        MutableQHashParallelKVDoubleLongMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashDoubleLongMap newMutableMapOf(double k1, long v1, double k2, long v2) {
        MutableQHashParallelKVDoubleLongMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashDoubleLongMap newMutableMapOf(double k1, long v1, double k2, long v2, double k3, long v3) {
        MutableQHashParallelKVDoubleLongMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashDoubleLongMap newMutableMapOf(double k1, long v1, double k2, long v2, double k3, long v3, double k4, long v4) {
        MutableQHashParallelKVDoubleLongMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashDoubleLongMap newMutableMapOf(double k1, long v1, double k2, long v2, double k3, long v3, double k4, long v4, double k5, long v5) {
        MutableQHashParallelKVDoubleLongMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }

    public HashDoubleLongMap newImmutableMap(Map<Double, Long> map1, Map<Double, Long> map2, int expectedSize) {
        ImmutableQHashParallelKVDoubleLongMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashDoubleLongMap newImmutableMap(Map<Double, Long> map1, Map<Double, Long> map2, Map<Double, Long> map3, int expectedSize) {
        ImmutableQHashParallelKVDoubleLongMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashDoubleLongMap newImmutableMap(Map<Double, Long> map1, Map<Double, Long> map2, Map<Double, Long> map3, Map<Double, Long> map4, int expectedSize) {
        ImmutableQHashParallelKVDoubleLongMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashDoubleLongMap newImmutableMap(Map<Double, Long> map1, Map<Double, Long> map2, Map<Double, Long> map3, Map<Double, Long> map4, Map<Double, Long> map5, int expectedSize) {
        ImmutableQHashParallelKVDoubleLongMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashDoubleLongMap newImmutableMap(Map<Double, Long> map) {
        ImmutableQHashParallelKVDoubleLongMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashDoubleLongMap newImmutableMap(Map<Double, Long> map1, Map<Double, Long> map2) {
        ImmutableQHashParallelKVDoubleLongMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashDoubleLongMap newImmutableMap(Map<Double, Long> map1, Map<Double, Long> map2, Map<Double, Long> map3) {
        ImmutableQHashParallelKVDoubleLongMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashDoubleLongMap newImmutableMap(Map<Double, Long> map1, Map<Double, Long> map2, Map<Double, Long> map3, Map<Double, Long> map4) {
        ImmutableQHashParallelKVDoubleLongMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashDoubleLongMap newImmutableMap(Map<Double, Long> map1, Map<Double, Long> map2, Map<Double, Long> map3, Map<Double, Long> map4, Map<Double, Long> map5) {
        ImmutableQHashParallelKVDoubleLongMapGO res = this.uninitializedImmutableMap();
        res.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashDoubleLongMap newImmutableMap(Consumer<DoubleLongConsumer> entriesSupplier) {
        ImmutableQHashParallelKVDoubleLongMapGO map = this.uninitializedImmutableMap();
        map.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashDoubleLongMap newImmutableMap(Consumer<DoubleLongConsumer> entriesSupplier, int expectedSize) {
        ImmutableQHashParallelKVDoubleLongMapGO map = this.uninitializedImmutableMap();
        map.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashDoubleLongMap newImmutableMap(double[] keys, long[] values) {
        ImmutableQHashParallelKVDoubleLongMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashDoubleLongMap newImmutableMap(double[] keys, long[] values, int expectedSize) {
        ImmutableQHashParallelKVDoubleLongMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashDoubleLongMap newImmutableMap(Double[] keys, Long[] values) {
        ImmutableQHashParallelKVDoubleLongMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashDoubleLongMap newImmutableMap(Double[] keys, Long[] values, int expectedSize) {
        ImmutableQHashParallelKVDoubleLongMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashDoubleLongMap newImmutableMap(Iterable<Double> keys, Iterable<Long> values) {
        ImmutableQHashParallelKVDoubleLongMapGO map = this.uninitializedImmutableMap();
        map.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashDoubleLongMap newImmutableMap(Iterable<Double> keys, Iterable<Long> values, int expectedSize) {
        ImmutableQHashParallelKVDoubleLongMapGO map = this.uninitializedImmutableMap();
        map.move((ParallelKVDoubleLongQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashDoubleLongMap newImmutableMapOf(double k1, long v1) {
        ImmutableQHashParallelKVDoubleLongMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashDoubleLongMap newImmutableMapOf(double k1, long v1, double k2, long v2) {
        ImmutableQHashParallelKVDoubleLongMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashDoubleLongMap newImmutableMapOf(double k1, long v1, double k2, long v2, double k3, long v3) {
        ImmutableQHashParallelKVDoubleLongMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashDoubleLongMap newImmutableMapOf(double k1, long v1, double k2, long v2, double k3, long v3, double k4, long v4) {
        ImmutableQHashParallelKVDoubleLongMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashDoubleLongMap newImmutableMapOf(double k1, long v1, double k2, long v2, double k3, long v3, double k4, long v4, double k5, long v5) {
        ImmutableQHashParallelKVDoubleLongMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }
}

