/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.hash.HashContainerFactory;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ImmutableQHashSeparateKVDoubleIntMapGO;
import net.openhft.collect.impl.hash.LHashCapacities;
import net.openhft.collect.impl.hash.MutableQHashSeparateKVDoubleIntMapGO;
import net.openhft.collect.impl.hash.QHashSeparateKVDoubleIntMapFactorySO;
import net.openhft.collect.impl.hash.SeparateKVDoubleIntQHash;
import net.openhft.collect.impl.hash.UpdatableQHashSeparateKVDoubleIntMapGO;
import net.openhft.collect.map.hash.HashDoubleIntMap;
import net.openhft.collect.map.hash.HashDoubleIntMapFactory;
import net.openhft.function.Consumer;
import net.openhft.function.DoubleIntConsumer;
import net.openhft.function.Predicate;

public abstract class QHashSeparateKVDoubleIntMapFactoryGO
extends QHashSeparateKVDoubleIntMapFactorySO {
    QHashSeparateKVDoubleIntMapFactoryGO(HashConfig hashConf, int defaultExpectedSize) {
        super(hashConf, defaultExpectedSize);
    }

    abstract HashDoubleIntMapFactory thisWith(HashConfig var1, int var2);

    abstract HashDoubleIntMapFactory lHashLikeThisWith(HashConfig var1, int var2);

    abstract HashDoubleIntMapFactory qHashLikeThisWith(HashConfig var1, int var2);

    public final HashDoubleIntMapFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash(hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize());
    }

    public final HashDoubleIntMapFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize);
    }

    public String toString() {
        return "HashDoubleIntMapFactory[" + this.commonString() + this.keySpecialString() + ",defaultValue=" + this.getDefaultValue() + "]";
    }

    public int hashCode() {
        int hashCode = this.keySpecialHashCode(this.commonHashCode());
        hashCode = hashCode * 31 + Primitives.hashCode(this.getDefaultValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashDoubleIntMapFactory) {
            HashDoubleIntMapFactory factory = (HashDoubleIntMapFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals(factory) && Integer.valueOf(this.getDefaultValue()).equals(factory.getDefaultValue());
        }
        return false;
    }

    public int getDefaultValue() {
        return 0;
    }

    private UpdatableQHashSeparateKVDoubleIntMapGO shrunk(UpdatableQHashSeparateKVDoubleIntMapGO map) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(map)) {
            map.shrink();
        }
        return map;
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMap() {
        return this.newUpdatableMap(this.getDefaultExpectedSize());
    }

    public MutableQHashSeparateKVDoubleIntMapGO newMutableMap() {
        return this.newMutableMap(this.getDefaultExpectedSize());
    }

    @Override
    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMap(Map<Double, Integer> map) {
        return this.shrunk((UpdatableQHashSeparateKVDoubleIntMapGO)super.newUpdatableMap((Map)map));
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMap(Map<Double, Integer> map1, Map<Double, Integer> map2) {
        long expectedSize = map1.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, Containers.sizeAsInt(expectedSize += (long)map2.size()));
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMap(Map<Double, Integer> map1, Map<Double, Integer> map2, Map<Double, Integer> map3) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, Containers.sizeAsInt(expectedSize += (long)map3.size()));
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMap(Map<Double, Integer> map1, Map<Double, Integer> map2, Map<Double, Integer> map3, Map<Double, Integer> map4) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, Containers.sizeAsInt(expectedSize += (long)map4.size()));
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMap(Map<Double, Integer> map1, Map<Double, Integer> map2, Map<Double, Integer> map3, Map<Double, Integer> map4, Map<Double, Integer> map5) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        expectedSize += (long)map4.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, Containers.sizeAsInt(expectedSize += (long)map5.size()));
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMap(Map<Double, Integer> map1, Map<Double, Integer> map2, int expectedSize) {
        UpdatableQHashSeparateKVDoubleIntMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Double, ? extends Integer>)map1);
        map.putAll((Map<? extends Double, ? extends Integer>)map2);
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMap(Map<Double, Integer> map1, Map<Double, Integer> map2, Map<Double, Integer> map3, int expectedSize) {
        UpdatableQHashSeparateKVDoubleIntMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Double, ? extends Integer>)map1);
        map.putAll((Map<? extends Double, ? extends Integer>)map2);
        map.putAll((Map<? extends Double, ? extends Integer>)map3);
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMap(Map<Double, Integer> map1, Map<Double, Integer> map2, Map<Double, Integer> map3, Map<Double, Integer> map4, int expectedSize) {
        UpdatableQHashSeparateKVDoubleIntMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Double, ? extends Integer>)map1);
        map.putAll((Map<? extends Double, ? extends Integer>)map2);
        map.putAll((Map<? extends Double, ? extends Integer>)map3);
        map.putAll((Map<? extends Double, ? extends Integer>)map4);
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMap(Map<Double, Integer> map1, Map<Double, Integer> map2, Map<Double, Integer> map3, Map<Double, Integer> map4, Map<Double, Integer> map5, int expectedSize) {
        UpdatableQHashSeparateKVDoubleIntMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Double, ? extends Integer>)map1);
        map.putAll((Map<? extends Double, ? extends Integer>)map2);
        map.putAll((Map<? extends Double, ? extends Integer>)map3);
        map.putAll((Map<? extends Double, ? extends Integer>)map4);
        map.putAll((Map<? extends Double, ? extends Integer>)map5);
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMap(Consumer<DoubleIntConsumer> entriesSupplier) {
        return this.newUpdatableMap((Consumer)entriesSupplier, this.getDefaultExpectedSize());
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMap(Consumer<DoubleIntConsumer> entriesSupplier, int expectedSize) {
        final UpdatableQHashSeparateKVDoubleIntMapGO map = this.newUpdatableMap(expectedSize);
        entriesSupplier.accept((Object)new DoubleIntConsumer(){

            public void accept(double k, int v) {
                map.put(k, v);
            }
        });
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMap(double[] keys, int[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMap(double[] keys, int[] values, int expectedSize) {
        UpdatableQHashSeparateKVDoubleIntMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMap(Double[] keys, Integer[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMap(Double[] keys, Integer[] values, int expectedSize) {
        UpdatableQHashSeparateKVDoubleIntMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMap(Iterable<Double> keys, Iterable<Integer> values) {
        int expectedSize = keys instanceof Collection ? ((Collection)keys).size() : this.getDefaultExpectedSize();
        return this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize);
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMap(Iterable<Double> keys, Iterable<Integer> values, int expectedSize) {
        UpdatableQHashSeparateKVDoubleIntMapGO map = this.newUpdatableMap(expectedSize);
        Iterator<Double> keysIt = keys.iterator();
        Iterator<Integer> valuesIt = values.iterator();
        try {
            while (keysIt.hasNext()) {
                map.put(keysIt.next(), valuesIt.next());
            }
            return this.shrunk(map);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("keys and values iterables must have the same size", e);
        }
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMapOf(double k1, int v1) {
        UpdatableQHashSeparateKVDoubleIntMapGO map = this.newUpdatableMap(1);
        map.put(k1, v1);
        return map;
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMapOf(double k1, int v1, double k2, int v2) {
        UpdatableQHashSeparateKVDoubleIntMapGO map = this.newUpdatableMap(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMapOf(double k1, int v1, double k2, int v2, double k3, int v3) {
        UpdatableQHashSeparateKVDoubleIntMapGO map = this.newUpdatableMap(3);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMapOf(double k1, int v1, double k2, int v2, double k3, int v3, double k4, int v4) {
        UpdatableQHashSeparateKVDoubleIntMapGO map = this.newUpdatableMap(4);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public UpdatableQHashSeparateKVDoubleIntMapGO newUpdatableMapOf(double k1, int v1, double k2, int v2, double k3, int v3, double k4, int v4, double k5, int v5) {
        UpdatableQHashSeparateKVDoubleIntMapGO map = this.newUpdatableMap(5);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public HashDoubleIntMap newMutableMap(Map<Double, Integer> map1, Map<Double, Integer> map2, int expectedSize) {
        MutableQHashSeparateKVDoubleIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashDoubleIntMap newMutableMap(Map<Double, Integer> map1, Map<Double, Integer> map2, Map<Double, Integer> map3, int expectedSize) {
        MutableQHashSeparateKVDoubleIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashDoubleIntMap newMutableMap(Map<Double, Integer> map1, Map<Double, Integer> map2, Map<Double, Integer> map3, Map<Double, Integer> map4, int expectedSize) {
        MutableQHashSeparateKVDoubleIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashDoubleIntMap newMutableMap(Map<Double, Integer> map1, Map<Double, Integer> map2, Map<Double, Integer> map3, Map<Double, Integer> map4, Map<Double, Integer> map5, int expectedSize) {
        MutableQHashSeparateKVDoubleIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashDoubleIntMap newMutableMap(Map<Double, Integer> map) {
        MutableQHashSeparateKVDoubleIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashDoubleIntMap newMutableMap(Map<Double, Integer> map1, Map<Double, Integer> map2) {
        MutableQHashSeparateKVDoubleIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashDoubleIntMap newMutableMap(Map<Double, Integer> map1, Map<Double, Integer> map2, Map<Double, Integer> map3) {
        MutableQHashSeparateKVDoubleIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashDoubleIntMap newMutableMap(Map<Double, Integer> map1, Map<Double, Integer> map2, Map<Double, Integer> map3, Map<Double, Integer> map4) {
        MutableQHashSeparateKVDoubleIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashDoubleIntMap newMutableMap(Map<Double, Integer> map1, Map<Double, Integer> map2, Map<Double, Integer> map3, Map<Double, Integer> map4, Map<Double, Integer> map5) {
        MutableQHashSeparateKVDoubleIntMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashDoubleIntMap newMutableMap(Consumer<DoubleIntConsumer> entriesSupplier) {
        MutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashDoubleIntMap newMutableMap(Consumer<DoubleIntConsumer> entriesSupplier, int expectedSize) {
        MutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashDoubleIntMap newMutableMap(double[] keys, int[] values) {
        MutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashDoubleIntMap newMutableMap(double[] keys, int[] values, int expectedSize) {
        MutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashDoubleIntMap newMutableMap(Double[] keys, Integer[] values) {
        MutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashDoubleIntMap newMutableMap(Double[] keys, Integer[] values, int expectedSize) {
        MutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashDoubleIntMap newMutableMap(Iterable<Double> keys, Iterable<Integer> values) {
        MutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashDoubleIntMap newMutableMap(Iterable<Double> keys, Iterable<Integer> values, int expectedSize) {
        MutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashDoubleIntMap newMutableMapOf(double k1, int v1) {
        MutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashDoubleIntMap newMutableMapOf(double k1, int v1, double k2, int v2) {
        MutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashDoubleIntMap newMutableMapOf(double k1, int v1, double k2, int v2, double k3, int v3) {
        MutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashDoubleIntMap newMutableMapOf(double k1, int v1, double k2, int v2, double k3, int v3, double k4, int v4) {
        MutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashDoubleIntMap newMutableMapOf(double k1, int v1, double k2, int v2, double k3, int v3, double k4, int v4, double k5, int v5) {
        MutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }

    public HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1, Map<Double, Integer> map2, int expectedSize) {
        ImmutableQHashSeparateKVDoubleIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1, Map<Double, Integer> map2, Map<Double, Integer> map3, int expectedSize) {
        ImmutableQHashSeparateKVDoubleIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1, Map<Double, Integer> map2, Map<Double, Integer> map3, Map<Double, Integer> map4, int expectedSize) {
        ImmutableQHashSeparateKVDoubleIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1, Map<Double, Integer> map2, Map<Double, Integer> map3, Map<Double, Integer> map4, Map<Double, Integer> map5, int expectedSize) {
        ImmutableQHashSeparateKVDoubleIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashDoubleIntMap newImmutableMap(Map<Double, Integer> map) {
        ImmutableQHashSeparateKVDoubleIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1, Map<Double, Integer> map2) {
        ImmutableQHashSeparateKVDoubleIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1, Map<Double, Integer> map2, Map<Double, Integer> map3) {
        ImmutableQHashSeparateKVDoubleIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1, Map<Double, Integer> map2, Map<Double, Integer> map3, Map<Double, Integer> map4) {
        ImmutableQHashSeparateKVDoubleIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashDoubleIntMap newImmutableMap(Map<Double, Integer> map1, Map<Double, Integer> map2, Map<Double, Integer> map3, Map<Double, Integer> map4, Map<Double, Integer> map5) {
        ImmutableQHashSeparateKVDoubleIntMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashDoubleIntMap newImmutableMap(Consumer<DoubleIntConsumer> entriesSupplier) {
        ImmutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashDoubleIntMap newImmutableMap(Consumer<DoubleIntConsumer> entriesSupplier, int expectedSize) {
        ImmutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashDoubleIntMap newImmutableMap(double[] keys, int[] values) {
        ImmutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashDoubleIntMap newImmutableMap(double[] keys, int[] values, int expectedSize) {
        ImmutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashDoubleIntMap newImmutableMap(Double[] keys, Integer[] values) {
        ImmutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashDoubleIntMap newImmutableMap(Double[] keys, Integer[] values, int expectedSize) {
        ImmutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashDoubleIntMap newImmutableMap(Iterable<Double> keys, Iterable<Integer> values) {
        ImmutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashDoubleIntMap newImmutableMap(Iterable<Double> keys, Iterable<Integer> values, int expectedSize) {
        ImmutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVDoubleIntQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashDoubleIntMap newImmutableMapOf(double k1, int v1) {
        ImmutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashDoubleIntMap newImmutableMapOf(double k1, int v1, double k2, int v2) {
        ImmutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashDoubleIntMap newImmutableMapOf(double k1, int v1, double k2, int v2, double k3, int v3) {
        ImmutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashDoubleIntMap newImmutableMapOf(double k1, int v1, double k2, int v2, double k3, int v3, double k4, int v4) {
        ImmutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashDoubleIntMap newImmutableMapOf(double k1, int v1, double k2, int v2, double k3, int v3, double k4, int v4, double k5, int v5) {
        ImmutableQHashSeparateKVDoubleIntMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }
}

