/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.hash.HashContainerFactory;
import net.openhft.collect.hash.LongHashFactory;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ImmutableQHashSeparateKVLongByteMapGO;
import net.openhft.collect.impl.hash.LHashCapacities;
import net.openhft.collect.impl.hash.MutableQHashSeparateKVLongByteMapGO;
import net.openhft.collect.impl.hash.QHashSeparateKVLongByteMapFactorySO;
import net.openhft.collect.impl.hash.SeparateKVLongByteQHash;
import net.openhft.collect.impl.hash.UpdatableQHashSeparateKVLongByteMapGO;
import net.openhft.collect.map.hash.HashLongByteMap;
import net.openhft.collect.map.hash.HashLongByteMapFactory;
import net.openhft.function.Consumer;
import net.openhft.function.LongByteConsumer;
import net.openhft.function.Predicate;

public abstract class QHashSeparateKVLongByteMapFactoryGO
extends QHashSeparateKVLongByteMapFactorySO {
    QHashSeparateKVLongByteMapFactoryGO(HashConfig hashConf, int defaultExpectedSize, long lower, long upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    abstract HashLongByteMapFactory thisWith(HashConfig var1, int var2, long var3, long var5);

    abstract HashLongByteMapFactory lHashLikeThisWith(HashConfig var1, int var2, long var3, long var5);

    abstract HashLongByteMapFactory qHashLikeThisWith(HashConfig var1, int var2, long var3, long var5);

    public final HashLongByteMapFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash(hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public final HashLongByteMapFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize, this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    final HashLongByteMapFactory withDomain(long lower, long upper) {
        if (lower == this.getLowerKeyDomainBound() && upper == this.getUpperKeyDomainBound()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), this.getDefaultExpectedSize(), lower, upper);
    }

    public final HashLongByteMapFactory withKeysDomain(long lower, long upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minPossibleKey shouldn't be greater than maxPossibleKey");
        }
        return this.withDomain(lower, upper);
    }

    public final HashLongByteMapFactory withKeysDomainComplement(long lower, long upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minImpossibleKey shouldn't be greater than maxImpossibleKey");
        }
        return this.withDomain(upper + 1L, lower - 1L);
    }

    public String toString() {
        return "HashLongByteMapFactory[" + this.commonString() + this.keySpecialString() + ",defaultValue=" + this.getDefaultValue() + "]";
    }

    public int hashCode() {
        int hashCode = this.keySpecialHashCode(this.commonHashCode());
        hashCode = hashCode * 31 + Primitives.hashCode(this.getDefaultValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashLongByteMapFactory) {
            HashLongByteMapFactory factory = (HashLongByteMapFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals((LongHashFactory)factory) && Byte.valueOf(this.getDefaultValue()).equals(factory.getDefaultValue());
        }
        return false;
    }

    public byte getDefaultValue() {
        return 0;
    }

    private UpdatableQHashSeparateKVLongByteMapGO shrunk(UpdatableQHashSeparateKVLongByteMapGO map) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(map)) {
            map.shrink();
        }
        return map;
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMap() {
        return this.newUpdatableMap(this.getDefaultExpectedSize());
    }

    public MutableQHashSeparateKVLongByteMapGO newMutableMap() {
        return this.newMutableMap(this.getDefaultExpectedSize());
    }

    @Override
    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMap(Map<Long, Byte> map) {
        return this.shrunk((UpdatableQHashSeparateKVLongByteMapGO)super.newUpdatableMap((Map)map));
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMap(Map<Long, Byte> map1, Map<Long, Byte> map2) {
        long expectedSize = map1.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, Containers.sizeAsInt(expectedSize += (long)map2.size()));
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMap(Map<Long, Byte> map1, Map<Long, Byte> map2, Map<Long, Byte> map3) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, Containers.sizeAsInt(expectedSize += (long)map3.size()));
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMap(Map<Long, Byte> map1, Map<Long, Byte> map2, Map<Long, Byte> map3, Map<Long, Byte> map4) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, Containers.sizeAsInt(expectedSize += (long)map4.size()));
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMap(Map<Long, Byte> map1, Map<Long, Byte> map2, Map<Long, Byte> map3, Map<Long, Byte> map4, Map<Long, Byte> map5) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        expectedSize += (long)map4.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, Containers.sizeAsInt(expectedSize += (long)map5.size()));
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMap(Map<Long, Byte> map1, Map<Long, Byte> map2, int expectedSize) {
        UpdatableQHashSeparateKVLongByteMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Long, ? extends Byte>)map1);
        map.putAll((Map<? extends Long, ? extends Byte>)map2);
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMap(Map<Long, Byte> map1, Map<Long, Byte> map2, Map<Long, Byte> map3, int expectedSize) {
        UpdatableQHashSeparateKVLongByteMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Long, ? extends Byte>)map1);
        map.putAll((Map<? extends Long, ? extends Byte>)map2);
        map.putAll((Map<? extends Long, ? extends Byte>)map3);
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMap(Map<Long, Byte> map1, Map<Long, Byte> map2, Map<Long, Byte> map3, Map<Long, Byte> map4, int expectedSize) {
        UpdatableQHashSeparateKVLongByteMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Long, ? extends Byte>)map1);
        map.putAll((Map<? extends Long, ? extends Byte>)map2);
        map.putAll((Map<? extends Long, ? extends Byte>)map3);
        map.putAll((Map<? extends Long, ? extends Byte>)map4);
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMap(Map<Long, Byte> map1, Map<Long, Byte> map2, Map<Long, Byte> map3, Map<Long, Byte> map4, Map<Long, Byte> map5, int expectedSize) {
        UpdatableQHashSeparateKVLongByteMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Long, ? extends Byte>)map1);
        map.putAll((Map<? extends Long, ? extends Byte>)map2);
        map.putAll((Map<? extends Long, ? extends Byte>)map3);
        map.putAll((Map<? extends Long, ? extends Byte>)map4);
        map.putAll((Map<? extends Long, ? extends Byte>)map5);
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMap(Consumer<LongByteConsumer> entriesSupplier) {
        return this.newUpdatableMap((Consumer)entriesSupplier, this.getDefaultExpectedSize());
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMap(Consumer<LongByteConsumer> entriesSupplier, int expectedSize) {
        final UpdatableQHashSeparateKVLongByteMapGO map = this.newUpdatableMap(expectedSize);
        entriesSupplier.accept((Object)new LongByteConsumer(){

            public void accept(long k, byte v) {
                map.put(k, v);
            }
        });
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMap(long[] keys, byte[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMap(long[] keys, byte[] values, int expectedSize) {
        UpdatableQHashSeparateKVLongByteMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMap(Long[] keys, Byte[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMap(Long[] keys, Byte[] values, int expectedSize) {
        UpdatableQHashSeparateKVLongByteMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMap(Iterable<Long> keys, Iterable<Byte> values) {
        int expectedSize = keys instanceof Collection ? ((Collection)keys).size() : this.getDefaultExpectedSize();
        return this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize);
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMap(Iterable<Long> keys, Iterable<Byte> values, int expectedSize) {
        UpdatableQHashSeparateKVLongByteMapGO map = this.newUpdatableMap(expectedSize);
        Iterator<Long> keysIt = keys.iterator();
        Iterator<Byte> valuesIt = values.iterator();
        try {
            while (keysIt.hasNext()) {
                map.put(keysIt.next(), valuesIt.next());
            }
            return this.shrunk(map);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("keys and values iterables must have the same size", e);
        }
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMapOf(long k1, byte v1) {
        UpdatableQHashSeparateKVLongByteMapGO map = this.newUpdatableMap(1);
        map.put(k1, v1);
        return map;
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMapOf(long k1, byte v1, long k2, byte v2) {
        UpdatableQHashSeparateKVLongByteMapGO map = this.newUpdatableMap(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMapOf(long k1, byte v1, long k2, byte v2, long k3, byte v3) {
        UpdatableQHashSeparateKVLongByteMapGO map = this.newUpdatableMap(3);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMapOf(long k1, byte v1, long k2, byte v2, long k3, byte v3, long k4, byte v4) {
        UpdatableQHashSeparateKVLongByteMapGO map = this.newUpdatableMap(4);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public UpdatableQHashSeparateKVLongByteMapGO newUpdatableMapOf(long k1, byte v1, long k2, byte v2, long k3, byte v3, long k4, byte v4, long k5, byte v5) {
        UpdatableQHashSeparateKVLongByteMapGO map = this.newUpdatableMap(5);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public HashLongByteMap newMutableMap(Map<Long, Byte> map1, Map<Long, Byte> map2, int expectedSize) {
        MutableQHashSeparateKVLongByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVLongByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashLongByteMap newMutableMap(Map<Long, Byte> map1, Map<Long, Byte> map2, Map<Long, Byte> map3, int expectedSize) {
        MutableQHashSeparateKVLongByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVLongByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashLongByteMap newMutableMap(Map<Long, Byte> map1, Map<Long, Byte> map2, Map<Long, Byte> map3, Map<Long, Byte> map4, int expectedSize) {
        MutableQHashSeparateKVLongByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVLongByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashLongByteMap newMutableMap(Map<Long, Byte> map1, Map<Long, Byte> map2, Map<Long, Byte> map3, Map<Long, Byte> map4, Map<Long, Byte> map5, int expectedSize) {
        MutableQHashSeparateKVLongByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVLongByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashLongByteMap newMutableMap(Map<Long, Byte> map) {
        MutableQHashSeparateKVLongByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVLongByteQHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashLongByteMap newMutableMap(Map<Long, Byte> map1, Map<Long, Byte> map2) {
        MutableQHashSeparateKVLongByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVLongByteQHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashLongByteMap newMutableMap(Map<Long, Byte> map1, Map<Long, Byte> map2, Map<Long, Byte> map3) {
        MutableQHashSeparateKVLongByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVLongByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashLongByteMap newMutableMap(Map<Long, Byte> map1, Map<Long, Byte> map2, Map<Long, Byte> map3, Map<Long, Byte> map4) {
        MutableQHashSeparateKVLongByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVLongByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashLongByteMap newMutableMap(Map<Long, Byte> map1, Map<Long, Byte> map2, Map<Long, Byte> map3, Map<Long, Byte> map4, Map<Long, Byte> map5) {
        MutableQHashSeparateKVLongByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVLongByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashLongByteMap newMutableMap(Consumer<LongByteConsumer> entriesSupplier) {
        MutableQHashSeparateKVLongByteMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVLongByteQHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashLongByteMap newMutableMap(Consumer<LongByteConsumer> entriesSupplier, int expectedSize) {
        MutableQHashSeparateKVLongByteMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVLongByteQHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashLongByteMap newMutableMap(long[] keys, byte[] values) {
        MutableQHashSeparateKVLongByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashLongByteMap newMutableMap(long[] keys, byte[] values, int expectedSize) {
        MutableQHashSeparateKVLongByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashLongByteMap newMutableMap(Long[] keys, Byte[] values) {
        MutableQHashSeparateKVLongByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashLongByteMap newMutableMap(Long[] keys, Byte[] values, int expectedSize) {
        MutableQHashSeparateKVLongByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashLongByteMap newMutableMap(Iterable<Long> keys, Iterable<Byte> values) {
        MutableQHashSeparateKVLongByteMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVLongByteQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashLongByteMap newMutableMap(Iterable<Long> keys, Iterable<Byte> values, int expectedSize) {
        MutableQHashSeparateKVLongByteMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVLongByteQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashLongByteMap newMutableMapOf(long k1, byte v1) {
        MutableQHashSeparateKVLongByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashLongByteMap newMutableMapOf(long k1, byte v1, long k2, byte v2) {
        MutableQHashSeparateKVLongByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashLongByteMap newMutableMapOf(long k1, byte v1, long k2, byte v2, long k3, byte v3) {
        MutableQHashSeparateKVLongByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashLongByteMap newMutableMapOf(long k1, byte v1, long k2, byte v2, long k3, byte v3, long k4, byte v4) {
        MutableQHashSeparateKVLongByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashLongByteMap newMutableMapOf(long k1, byte v1, long k2, byte v2, long k3, byte v3, long k4, byte v4, long k5, byte v5) {
        MutableQHashSeparateKVLongByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }

    public HashLongByteMap newImmutableMap(Map<Long, Byte> map1, Map<Long, Byte> map2, int expectedSize) {
        ImmutableQHashSeparateKVLongByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVLongByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashLongByteMap newImmutableMap(Map<Long, Byte> map1, Map<Long, Byte> map2, Map<Long, Byte> map3, int expectedSize) {
        ImmutableQHashSeparateKVLongByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVLongByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashLongByteMap newImmutableMap(Map<Long, Byte> map1, Map<Long, Byte> map2, Map<Long, Byte> map3, Map<Long, Byte> map4, int expectedSize) {
        ImmutableQHashSeparateKVLongByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVLongByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashLongByteMap newImmutableMap(Map<Long, Byte> map1, Map<Long, Byte> map2, Map<Long, Byte> map3, Map<Long, Byte> map4, Map<Long, Byte> map5, int expectedSize) {
        ImmutableQHashSeparateKVLongByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVLongByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashLongByteMap newImmutableMap(Map<Long, Byte> map) {
        ImmutableQHashSeparateKVLongByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVLongByteQHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashLongByteMap newImmutableMap(Map<Long, Byte> map1, Map<Long, Byte> map2) {
        ImmutableQHashSeparateKVLongByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVLongByteQHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashLongByteMap newImmutableMap(Map<Long, Byte> map1, Map<Long, Byte> map2, Map<Long, Byte> map3) {
        ImmutableQHashSeparateKVLongByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVLongByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashLongByteMap newImmutableMap(Map<Long, Byte> map1, Map<Long, Byte> map2, Map<Long, Byte> map3, Map<Long, Byte> map4) {
        ImmutableQHashSeparateKVLongByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVLongByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashLongByteMap newImmutableMap(Map<Long, Byte> map1, Map<Long, Byte> map2, Map<Long, Byte> map3, Map<Long, Byte> map4, Map<Long, Byte> map5) {
        ImmutableQHashSeparateKVLongByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVLongByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashLongByteMap newImmutableMap(Consumer<LongByteConsumer> entriesSupplier) {
        ImmutableQHashSeparateKVLongByteMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVLongByteQHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashLongByteMap newImmutableMap(Consumer<LongByteConsumer> entriesSupplier, int expectedSize) {
        ImmutableQHashSeparateKVLongByteMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVLongByteQHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashLongByteMap newImmutableMap(long[] keys, byte[] values) {
        ImmutableQHashSeparateKVLongByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashLongByteMap newImmutableMap(long[] keys, byte[] values, int expectedSize) {
        ImmutableQHashSeparateKVLongByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashLongByteMap newImmutableMap(Long[] keys, Byte[] values) {
        ImmutableQHashSeparateKVLongByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashLongByteMap newImmutableMap(Long[] keys, Byte[] values, int expectedSize) {
        ImmutableQHashSeparateKVLongByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashLongByteMap newImmutableMap(Iterable<Long> keys, Iterable<Byte> values) {
        ImmutableQHashSeparateKVLongByteMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVLongByteQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashLongByteMap newImmutableMap(Iterable<Long> keys, Iterable<Byte> values, int expectedSize) {
        ImmutableQHashSeparateKVLongByteMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVLongByteQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashLongByteMap newImmutableMapOf(long k1, byte v1) {
        ImmutableQHashSeparateKVLongByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashLongByteMap newImmutableMapOf(long k1, byte v1, long k2, byte v2) {
        ImmutableQHashSeparateKVLongByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashLongByteMap newImmutableMapOf(long k1, byte v1, long k2, byte v2, long k3, byte v3) {
        ImmutableQHashSeparateKVLongByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashLongByteMap newImmutableMapOf(long k1, byte v1, long k2, byte v2, long k3, byte v3, long k4, byte v4) {
        ImmutableQHashSeparateKVLongByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashLongByteMap newImmutableMapOf(long k1, byte v1, long k2, byte v2, long k3, byte v3, long k4, byte v4, long k5, byte v5) {
        ImmutableQHashSeparateKVLongByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }
}

