/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.collect.DoubleCursor;
import net.openhft.collect.impl.CommonDoubleCollectionOps;
import net.openhft.collect.impl.CommonSetOps;
import net.openhft.collect.impl.InternalDoubleCollectionOps;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.SeparateKVDoubleLHash;
import net.openhft.collect.impl.hash.UpdatableDoubleLHashSetSO;
import net.openhft.collect.set.hash.HashDoubleSet;

public class UpdatableLHashDoubleSetGO
extends UpdatableDoubleLHashSetSO
implements HashDoubleSet,
InternalDoubleCollectionOps {
    @Override
    final void copy(SeparateKVDoubleLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVDoubleLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals(this, obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonDoubleCollectionOps.containsAll(this, c);
    }

    @Nonnull
    public DoubleCursor cursor() {
        return this.setCursor();
    }

    public boolean add(Double e) {
        return this.add((double)e);
    }

    @Override
    public boolean add(long key) {
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVDoubleKeyMixing.mix(key) & capacityMask;
        long cur = keys[index];
        if (cur != 0x7FFFFFFFFFFFFFFEL) {
            if (cur == key) {
                return false;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                if (cur != key) continue;
                return false;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.postInsertHook();
        return true;
    }

    public boolean add(double key) {
        return this.add(Double.doubleToLongBits(key));
    }

    public boolean addAll(@Nonnull Collection<? extends Double> c) {
        return CommonDoubleCollectionOps.addAll(this, c);
    }

    public boolean remove(Object key) {
        return this.removeDouble((Double)key);
    }

    @Override
    boolean justRemove(long key) {
        return this.removeDouble(key);
    }

    @Override
    public boolean removeDouble(long key) {
        throw new UnsupportedOperationException();
    }

    public boolean removeDouble(double key) {
        return this.removeDouble(Double.doubleToLongBits(key));
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

