/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.CommonSetOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.SeparateKVObjLHash;
import net.openhft.collect.impl.hash.UpdatableObjLHashSetSO;
import net.openhft.collect.set.hash.HashObjSet;

public class UpdatableLHashObjSetGO<E>
extends UpdatableObjLHashSetSO<E>
implements HashObjSet<E>,
InternalObjCollectionOps<E> {
    @Override
    final void copy(SeparateKVObjLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVObjLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals(this, obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonObjCollectionOps.containsAll(this, c);
    }

    @Nonnull
    public ObjCursor<E> cursor() {
        return this.setCursor();
    }

    public boolean add(E key) {
        if (key != null) {
            Object[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) & capacityMask;
            Object cur = keys[index];
            if (cur != FREE) {
                if (cur == key || this.keyEquals(key, cur)) {
                    return false;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != FREE) {
                    if (cur != key && !this.keyEquals(key, cur)) continue;
                    return false;
                }
            }
            this.incrementModCount();
            keys[index] = key;
            this.postInsertHook();
            return true;
        }
        return this.addNullKey();
    }

    private boolean addNullKey() {
        Object[] keys = this.set;
        int index = 0;
        Object cur = keys[0];
        if (cur != FREE) {
            if (cur == null) {
                return false;
            }
            int capacityMask = keys.length - 1;
            while ((cur = keys[index = index - 1 & capacityMask]) != FREE) {
                if (cur != null) continue;
                return false;
            }
        }
        this.incrementModCount();
        keys[index] = null;
        this.postInsertHook();
        return true;
    }

    public boolean addAll(@Nonnull Collection<? extends E> c) {
        return CommonObjCollectionOps.addAll(this, c);
    }

    public boolean remove(Object key) {
        throw new UnsupportedOperationException();
    }

    private boolean removeNullKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean justRemove(E key) {
        return this.remove(key);
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

