/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.collect.impl.InternalFloatCharMapOps;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.SeparateKVFloatCharLHash;
import net.openhft.collect.impl.hash.UpdatableLHashSeparateKVFloatKeyMap;
import net.openhft.collect.map.hash.HashFloatCharMap;

public abstract class UpdatableLHashSeparateKVFloatCharMapSO
extends UpdatableLHashSeparateKVFloatKeyMap
implements HashFloatCharMap,
InternalFloatCharMapOps,
SeparateKVFloatCharLHash {
    char[] values;

    void copy(SeparateKVFloatCharLHash hash) {
        super.copy(hash);
        this.values = (char[])hash.valueArray().clone();
    }

    void move(SeparateKVFloatCharLHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public char[] valueArray() {
        return this.values;
    }

    int valueIndex(char value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] >= 0x7FFFFFFE || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(char value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(char value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(((Character)value).charValue());
    }

    int insert(int key, char value) {
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVFloatKeyMixing.mix(key) & capacityMask;
        int cur = keys[index];
        if (cur == key) {
            return index;
        }
        if (cur != 0x7FFFFFFE) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return index;
            } while (cur != 0x7FFFFFFE);
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new char[capacity];
    }
}

