/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.collect.impl.InternalFloatDoubleMapOps;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.SeparateKVFloatDoubleLHash;
import net.openhft.collect.impl.hash.UpdatableLHashSeparateKVFloatKeyMap;
import net.openhft.collect.map.hash.HashFloatDoubleMap;

public abstract class UpdatableLHashSeparateKVFloatDoubleMapSO
extends UpdatableLHashSeparateKVFloatKeyMap
implements HashFloatDoubleMap,
InternalFloatDoubleMapOps,
SeparateKVFloatDoubleLHash {
    long[] values;

    void copy(SeparateKVFloatDoubleLHash hash) {
        super.copy(hash);
        this.values = (long[])hash.valueArray().clone();
    }

    void move(SeparateKVFloatDoubleLHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public long[] valueArray() {
        return this.values;
    }

    int valueIndex(long value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] >= 0x7FFFFFFE || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    boolean containsValue(long value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(long value) {
        throw new UnsupportedOperationException();
    }

    int valueIndex(double value) {
        if (this.isEmpty()) {
            return -1;
        }
        long val = Double.doubleToLongBits(value);
        int index = -1;
        int mc = this.modCount();
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] >= 0x7FFFFFFE || val != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(double value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Double)value);
    }

    int insert(int key, long value) {
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVFloatKeyMixing.mix(key) & capacityMask;
        int cur = keys[index];
        if (cur == key) {
            return index;
        }
        if (cur != 0x7FFFFFFE) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return index;
            } while (cur != 0x7FFFFFFE);
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new long[capacity];
    }
}

