/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.collect.impl.InternalLongCharMapOps;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.SeparateKVLongCharLHash;
import net.openhft.collect.impl.hash.UpdatableLHashSeparateKVLongKeyMap;
import net.openhft.collect.map.hash.HashLongCharMap;

public abstract class UpdatableLHashSeparateKVLongCharMapSO
extends UpdatableLHashSeparateKVLongKeyMap
implements HashLongCharMap,
InternalLongCharMapOps,
SeparateKVLongCharLHash {
    char[] values;

    void copy(SeparateKVLongCharLHash hash) {
        super.copy(hash);
        this.values = (char[])hash.valueArray().clone();
    }

    void move(SeparateKVLongCharLHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public char[] valueArray() {
        return this.values;
    }

    int valueIndex(char value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == free || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(char value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(char value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(((Character)value).charValue());
    }

    int insert(long key, char value) {
        long free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVLongKeyMixing.mix(key) & capacityMask;
        long cur = keys[index];
        if (cur == key) {
            return index;
        }
        if (cur != free) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return index;
            } while (cur != free);
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new char[capacity];
    }
}

