/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.openhft.collect.hash.HashOverflowException;
import net.openhft.collect.impl.ByteArrays;
import net.openhft.collect.impl.PrimitiveConstants;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.HashConfigWrapper;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.ParallelKVByteLHash;
import net.openhft.collect.impl.hash.UpdatableLHash;

public abstract class UpdatableParallelKVByteLHashSO
extends UpdatableLHash
implements ParallelKVByteLHash,
PrimitiveConstants,
UnsafeConstants {
    byte freeValue;
    char[] table;

    void copy(ParallelKVByteLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = (char[])hash.table().clone();
    }

    void move(ParallelKVByteLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = hash.table();
    }

    final void init(HashConfigWrapper configWrapper, int size, byte freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public byte freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public byte removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains((Byte)key);
    }

    public boolean contains(byte key) {
        return this.index(key) >= 0;
    }

    int index(byte key) {
        byte free = this.freeValue;
        if (key != free) {
            char[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVByteKeyMixing.mix(key) & capacityMask;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            do {
                if ((cur = (byte)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return index;
            } while (cur != free);
            return -1;
        }
        return -1;
    }

    private byte findNewFreeOrRemoved() {
        byte newFree;
        block6: {
            int mc = this.modCount();
            int size = this.size();
            if (size >= 255) {
                throw new HashOverflowException();
            }
            byte free = this.freeValue;
            char[] tab = this.table;
            int capacity = this.capacity();
            ThreadLocalRandom random = ThreadLocalRandom.current();
            if (size > 192) {
                int nf = ((Random)random).nextInt(256) * 97;
                for (int i = 0; i < 256; ++i) {
                    newFree = (byte)(nf += 97);
                    if (newFree == free || this.index(newFree) >= 0) {
                        continue;
                    }
                    break block6;
                }
                if (mc != this.modCount()) {
                    throw new ConcurrentModificationException();
                }
                throw new AssertionError((Object)"Impossible state");
            }
            while ((newFree = (byte)((Random)random).nextInt()) == free || this.index(newFree) >= 0) {
            }
        }
        return newFree;
    }

    byte changeFree() {
        int mc = this.modCount();
        byte newFree = this.findNewFreeOrRemoved();
        this.incrementModCount();
        ByteArrays.replaceAllKeys(this.table, this.freeValue, newFree);
        this.freeValue = newFree;
        if (++mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newFree;
    }

    @Override
    void allocateArrays(int capacity) {
        this.table = new char[capacity];
        if (this.freeValue != 0) {
            ByteArrays.fillKeys(this.table, this.freeValue);
        }
    }

    @Override
    public void clear() {
        super.clear();
        ByteArrays.fillKeys(this.table, this.freeValue);
    }
}

