/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import net.openhft.collect.impl.IntArrays;
import net.openhft.collect.impl.PrimitiveConstants;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.ParallelKVFloatQHash;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.UpdatableQHash;

public abstract class UpdatableParallelKVFloatQHashSO
extends UpdatableQHash
implements ParallelKVFloatQHash,
PrimitiveConstants,
UnsafeConstants {
    long[] table;

    void copy(ParallelKVFloatQHash hash) {
        super.copy(hash);
        this.table = (long[])hash.table().clone();
    }

    void move(ParallelKVFloatQHash hash) {
        super.copy(hash);
        this.table = hash.table();
    }

    public boolean contains(Object key) {
        return this.contains(((Float)key).floatValue());
    }

    public boolean contains(float key) {
        return this.index(Float.floatToIntBits(key)) >= 0;
    }

    public boolean contains(int key) {
        return this.index(key) >= 0;
    }

    int index(int key) {
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix(key) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == key) {
            return index;
        }
        if (cur == 0x7FFFFFFE) {
            return -1;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == key) {
                return bIndex;
            }
            if (cur == 0x7FFFFFFE) {
                return -1;
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == key) {
                return fIndex;
            }
            if (cur == 0x7FFFFFFE) {
                return -1;
            }
            step += 2;
        }
    }

    @Override
    void allocateArrays(int capacity) {
        this.table = new long[capacity];
        IntArrays.fillKeys(this.table, 0x7FFFFFFE);
    }

    @Override
    public void clear() {
        super.clear();
        IntArrays.fillKeys(this.table, 0x7FFFFFFE);
    }
}

