/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.openhft.collect.impl.LongArrays;
import net.openhft.collect.impl.PrimitiveConstants;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.HashConfigWrapper;
import net.openhft.collect.impl.hash.ParallelKVLongQHash;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.UpdatableQHash;

public abstract class UpdatableParallelKVLongQHashSO
extends UpdatableQHash
implements ParallelKVLongQHash,
PrimitiveConstants,
UnsafeConstants {
    long freeValue;
    long[] table;

    void copy(ParallelKVLongQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = (long[])hash.table().clone();
    }

    void move(ParallelKVLongQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = hash.table();
    }

    final void init(HashConfigWrapper configWrapper, int size, long freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public long freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public long removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains((Long)key);
    }

    public boolean contains(long key) {
        return this.index(key) >= 0;
    }

    int index(long key) {
        long free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVLongKeyMixing.mix(key) % capacity;
            long cur = tab[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 2;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = tab[bIndex]) == key) {
                    return bIndex;
                }
                if (cur == free) {
                    return -1;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = tab[fIndex]) == key) {
                    return fIndex;
                }
                if (cur == free) {
                    return -1;
                }
                step += 4;
            }
        }
        return -1;
    }

    private long findNewFreeOrRemoved() {
        long newFree;
        long free = this.freeValue;
        long[] tab = this.table;
        int capacity = this.capacity();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while ((newFree = ((Random)random).nextLong()) == free || this.index(newFree) >= 0) {
        }
        return newFree;
    }

    long changeFree() {
        int mc = this.modCount();
        long newFree = this.findNewFreeOrRemoved();
        this.incrementModCount();
        LongArrays.replaceAllKeys(this.table, this.freeValue, newFree);
        this.freeValue = newFree;
        if (++mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newFree;
    }

    @Override
    void allocateArrays(int capacity) {
        this.table = new long[capacity * 2];
        if (this.freeValue != 0L) {
            LongArrays.fillKeys(this.table, this.freeValue);
        }
    }

    @Override
    public void clear() {
        super.clear();
        LongArrays.fillKeys(this.table, this.freeValue);
    }
}

