/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import net.openhft.collect.impl.InternalIntFloatMapOps;
import net.openhft.collect.impl.hash.ParallelKVIntFloatQHash;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.UpdatableQHashParallelKVIntKeyMap;
import net.openhft.collect.map.hash.HashIntFloatMap;

public abstract class UpdatableQHashParallelKVIntFloatMapSO
extends UpdatableQHashParallelKVIntKeyMap
implements HashIntFloatMap,
InternalIntFloatMapOps,
ParallelKVIntFloatQHash {
    int valueIndex(int value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            if ((int)entry == free || value != (int)(entry >>> 32)) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    boolean containsValue(int value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(int value) {
        throw new UnsupportedOperationException();
    }

    int valueIndex(float value) {
        if (this.isEmpty()) {
            return -1;
        }
        int val = Float.floatToIntBits(value);
        int index = -1;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            if ((int)entry == free || val != (int)(entry >>> 32)) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(float value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(((Float)value).floatValue());
    }

    int insert(int key, int value) {
        int free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == key) {
            return index;
        }
        if (cur != free) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == key) {
                    return bIndex;
                }
                if (cur == free) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == key) {
                    return fIndex;
                }
                if (cur == free) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        tab[index] = (long)key & 0xFFFFFFFFL | (long)value << 32;
        this.postInsertHook();
        return -1;
    }
}

