/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import net.openhft.collect.impl.InternalShortCharMapOps;
import net.openhft.collect.impl.hash.ParallelKVShortCharQHash;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.UpdatableQHashParallelKVShortKeyMap;
import net.openhft.collect.map.hash.HashShortCharMap;

public abstract class UpdatableQHashParallelKVShortCharMapSO
extends UpdatableQHashParallelKVShortKeyMap
implements HashShortCharMap,
InternalShortCharMapOps,
ParallelKVShortCharQHash {
    int valueIndex(char value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            if ((short)entry == free || value != (char)(entry >>> 16)) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(char value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(char value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(((Character)value).charValue());
    }

    int insert(short key, char value) {
        short free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur == key) {
            return index;
        }
        if (cur != free) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == key) {
                    return bIndex;
                }
                if (cur == free) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == key) {
                    return fIndex;
                }
                if (cur == free) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        tab[index] = key & 0xFFFF | value << 16;
        this.postInsertHook();
        return -1;
    }
}

