/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.collect.impl.InternalCharByteMapOps;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.SeparateKVCharByteQHash;
import net.openhft.collect.impl.hash.UpdatableQHashSeparateKVCharKeyMap;
import net.openhft.collect.map.hash.HashCharByteMap;

public abstract class UpdatableQHashSeparateKVCharByteMapSO
extends UpdatableQHashSeparateKVCharKeyMap
implements HashCharByteMap,
InternalCharByteMapOps,
SeparateKVCharByteQHash {
    byte[] values;

    void copy(SeparateKVCharByteQHash hash) {
        super.copy(hash);
        this.values = (byte[])hash.valueArray().clone();
    }

    void move(SeparateKVCharByteQHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public byte[] valueArray() {
        return this.values;
    }

    int valueIndex(byte value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == free || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(byte value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Byte)value);
    }

    int insert(char key, byte value) {
        char free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        char[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVCharKeyMixing.mix(key) % capacity;
        char cur = keys[index];
        if (cur == key) {
            return index;
        }
        if (cur != free) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == key) {
                    return bIndex;
                }
                if (cur == free) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == key) {
                    return fIndex;
                }
                if (cur == free) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new byte[capacity];
    }
}

