/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.impl.InternalCharObjMapOps;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.SeparateKVCharObjQHash;
import net.openhft.collect.impl.hash.UpdatableQHashSeparateKVCharKeyMap;
import net.openhft.collect.map.hash.HashCharObjMap;

public abstract class UpdatableQHashSeparateKVCharObjMapSO<V>
extends UpdatableQHashSeparateKVCharKeyMap
implements HashCharObjMap<V>,
InternalCharObjMapOps<V>,
SeparateKVCharObjQHash {
    V[] values;

    void copy(SeparateKVCharObjQHash hash) {
        super.copy(hash);
        this.values = (Object[])hash.valueArray().clone();
    }

    void move(SeparateKVCharObjQHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public Object[] valueArray() {
        return this.values;
    }

    boolean nullableValueEquals(@Nullable V a, @Nullable V b) {
        return a == b || a != null && a.equals(b);
    }

    boolean valueEquals(@Nonnull V a, @Nullable V b) {
        return a.equals(b);
    }

    int nullableValueHashCode(@Nullable V value) {
        return value != null ? value.hashCode() : 0;
    }

    int valueHashCode(@Nonnull V value) {
        return value.hashCode();
    }

    int valueIndex(@Nullable Object value) {
        if (value == null) {
            return this.nullValueIndex();
        }
        if (this.isEmpty()) {
            return -1;
        }
        Object val = value;
        int index = -1;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        V[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == free || !this.valueEquals(val, vals[i])) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    private int nullValueIndex() {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        V[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == free || vals[i] != null) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(@Nullable Object value) {
        throw new UnsupportedOperationException();
    }

    int insert(char key, V value) {
        char free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        char[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVCharKeyMixing.mix(key) % capacity;
        char cur = keys[index];
        if (cur == key) {
            return index;
        }
        if (cur != free) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == key) {
                    return bIndex;
                }
                if (cur == free) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == key) {
                    return fIndex;
                }
                if (cur == free) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new Object[capacity];
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.values, null);
    }
}

