/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.CharCollection;
import net.openhft.collect.CharCursor;
import net.openhft.collect.CharIterator;
import net.openhft.collect.Equivalence;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractCharValueView;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonIntCharMapOps;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.InternalIntCharMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.SeparateKVIntCharQHash;
import net.openhft.collect.impl.hash.UpdatableQHashSeparateKVIntCharMapSO;
import net.openhft.collect.map.IntCharCursor;
import net.openhft.collect.set.CharSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.CharBinaryOperator;
import net.openhft.function.CharConsumer;
import net.openhft.function.CharPredicate;
import net.openhft.function.IntCharConsumer;
import net.openhft.function.IntCharPredicate;
import net.openhft.function.IntCharToCharFunction;
import net.openhft.function.IntToCharFunction;

public class UpdatableQHashSeparateKVIntCharMapGO
extends UpdatableQHashSeparateKVIntCharMapSO {
    @Override
    final void copy(SeparateKVIntCharQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVIntCharQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public char defaultValue() {
        return '\u0000';
    }

    @Override
    public boolean containsEntry(int key, char value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Character get(Object key) {
        int index = this.index((Integer)key);
        if (index >= 0) {
            return Character.valueOf(this.values[index]);
        }
        return null;
    }

    public char get(int key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Character getOrDefault(Object key, Character defaultValue) {
        int index = this.index((Integer)key);
        if (index >= 0) {
            return Character.valueOf(this.values[index]);
        }
        return defaultValue;
    }

    public char getOrDefault(int key, char defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Integer, ? super Character> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            action.accept((Integer)key, Character.valueOf(vals[i]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(IntCharConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(IntCharPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public IntCharCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonIntCharMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalIntCharMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalIntCharMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Integer, Character>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public CharCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            hashCode += key ^ vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        char[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        int[] newKeys = this.set;
        int capacity = newKeys.length;
        char[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            int index = QHash.SeparateKVIntKeyMixing.mix(key) % capacity;
            if (newKeys[index] != free) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if (newKeys[bIndex] == free) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if (newKeys[fIndex] == free) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Character put(Integer key, Character value) {
        int index = this.insert(key, value.charValue());
        if (index < 0) {
            return null;
        }
        char[] vals = this.values;
        char prevValue = vals[index];
        vals[index] = value.charValue();
        return Character.valueOf(prevValue);
    }

    @Override
    public char put(int key, char value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        char[] vals = this.values;
        char prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public Character putIfAbsent(Integer key, Character value) {
        int index = this.insert(key, value.charValue());
        if (index < 0) {
            return null;
        }
        return Character.valueOf(this.values[index]);
    }

    @Override
    public char putIfAbsent(int key, char value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    @Override
    public void justPut(int key, char value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    @Override
    public Character compute(Integer key, BiFunction<? super Integer, ? super Character, ? extends Character> remappingFunction) {
        Character newValue;
        int index;
        char[] vals;
        int k;
        block13: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVIntKeyMixing.mix(k) % capacity;
            int cur = keys[index];
            if (cur != k) {
                Character newValue2;
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == k) {
                            index = bIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == k) {
                            index = fIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                if ((newValue2 = remappingFunction.apply((Integer)k, null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue2.charValue();
                    this.postInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Integer)k, Character.valueOf(vals[index]))) != null) {
            vals[index] = newValue.charValue();
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    public char compute(int key, IntCharToCharFunction remappingFunction) {
        char newValue;
        int index;
        char[] vals;
        block11: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVIntKeyMixing.mix(key) % capacity;
            int cur = keys[index];
            if (cur != key) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newValue = remappingFunction.applyAsChar(key, this.defaultValue());
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsChar(key, vals[index]);
        return newValue;
    }

    @Override
    public Character computeIfAbsent(Integer key, Function<? super Integer, ? extends Character> mappingFunction) {
        Character value;
        int k = key;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        int free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        int[] keys = this.set;
        char[] vals = this.values;
        int capacity = keys.length;
        int index = QHash.SeparateKVIntKeyMixing.mix(k) % capacity;
        int cur = keys[index];
        if (cur != free) {
            if (cur == k) {
                return Character.valueOf(vals[index]);
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == free) {
                    index = bIndex;
                    break;
                }
                if (cur == k) {
                    return Character.valueOf(vals[bIndex]);
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == free) {
                    index = fIndex;
                    break;
                }
                if (cur == k) {
                    return Character.valueOf(vals[fIndex]);
                }
                step += 2;
            }
        }
        if ((value = mappingFunction.apply((Integer)k)) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = value.charValue();
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public char computeIfAbsent(int key, IntToCharFunction mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        int free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] keys = this.set;
        char[] vals = this.values;
        int capacity = keys.length;
        int index = QHash.SeparateKVIntKeyMixing.mix(key) % capacity;
        int cur = keys[index];
        if (cur != free) {
            if (cur == key) {
                return vals[index];
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == free) {
                    index = bIndex;
                    break;
                }
                if (cur == key) {
                    return vals[bIndex];
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == free) {
                    index = fIndex;
                    break;
                }
                if (cur == key) {
                    return vals[fIndex];
                }
                step += 2;
            }
        }
        char value = mappingFunction.applyAsChar(key);
        this.incrementModCount();
        keys[index] = key;
        vals[index] = value;
        this.postInsertHook();
        return value;
    }

    @Override
    public Character computeIfPresent(Integer key, BiFunction<? super Integer, ? super Character, ? extends Character> remappingFunction) {
        int k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            char[] vals = this.values;
            Character newValue = remappingFunction.apply((Integer)k, Character.valueOf(vals[index]));
            if (newValue != null) {
                vals[index] = newValue.charValue();
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public char computeIfPresent(int key, IntCharToCharFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            char newValue;
            char[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsChar(key, vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    @Override
    public Character merge(Integer key, Character value, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        Character newValue;
        int index;
        char[] vals;
        block13: {
            int k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVIntKeyMixing.mix(k) % capacity;
            int cur = keys[index];
            if (cur != k) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == k) {
                            index = bIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == k) {
                            index = fIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = value.charValue();
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply(Character.valueOf(vals[index]), value)) != null) {
            vals[index] = newValue.charValue();
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    public char merge(int key, char value, CharBinaryOperator remappingFunction) {
        char newValue;
        int index;
        char[] vals;
        block11: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVIntKeyMixing.mix(key) % capacity;
            int cur = keys[index];
            if (cur != key) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsChar(vals[index], value);
        return newValue;
    }

    public char addValue(int key, char value) {
        char newValue;
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        char[] vals = this.values;
        vals[index] = newValue = (char)(vals[index] + value);
        return newValue;
    }

    public char addValue(int key, char addition, char defaultValue) {
        char newValue;
        char value = (char)(defaultValue + addition);
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        char[] vals = this.values;
        vals[index] = newValue = (char)(vals[index] + addition);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Integer, ? extends Character> m) {
        CommonIntCharMapOps.putAll(this, m);
    }

    @Override
    public Character replace(Integer key, Character value) {
        int index = this.index(key);
        if (index >= 0) {
            char[] vals = this.values;
            char oldValue = vals[index];
            vals[index] = value.charValue();
            return Character.valueOf(oldValue);
        }
        return null;
    }

    @Override
    public char replace(int key, char value) {
        int index = this.index(key);
        if (index >= 0) {
            char[] vals = this.values;
            char oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Integer key, Character oldValue, Character newValue) {
        return this.replace((int)key, oldValue.charValue(), newValue.charValue());
    }

    @Override
    public boolean replace(int key, char oldValue, char newValue) {
        int index = this.index(key);
        if (index >= 0) {
            char[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Integer, ? super Character, ? extends Character> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            vals[i] = function.apply((Integer)key, Character.valueOf(vals[i])).charValue();
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(IntCharToCharFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            vals[i] = function.applyAsChar(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Character remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(int key) {
        throw new UnsupportedOperationException();
    }

    public char remove(int key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Integer)key, ((Character)value).charValue());
    }

    public boolean remove(int key, char value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(IntCharPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements IntCharCursor {
        final int[] keys;
        final char[] vals;
        final int free;
        int expectedModCount;
        int index;
        int curKey;
        char curValue;

        NoRemovedMapCursor(int mc) {
            int free;
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            this.curKey = free = (this.free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue);
        }

        public void forEachForward(IntCharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            char[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int key() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public char value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(char value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements CharCursor {
        final int[] keys;
        final char[] vals;
        final int free;
        int expectedModCount;
        int index;
        int curKey;
        char curValue;

        NoRemovedValueCursor(int mc) {
            int free;
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            this.curKey = free = (this.free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue);
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            char[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements CharIterator {
        final int[] keys;
        final char[] vals;
        final int free;
        int expectedModCount;
        int nextIndex;
        char next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            int[] keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            this.vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            char[] vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            int free = this.free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                    int[] keys = this.keys;
                    int free = this.free;
                    char prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == free) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            char[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Character.valueOf(vals[i]));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            char[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Integer, Character>> {
        final int[] keys;
        final char[] vals;
        final int free;
        int expectedModCount;
        int index;
        int curKey;
        char curValue;

        NoRemovedEntryCursor(int mc) {
            int free;
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            this.curKey = free = (this.free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Integer, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            char[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Integer, Character> elem() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Integer, Character>> {
        final int[] keys;
        final char[] vals;
        final int free;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            int[] keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            this.vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            char[] vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            int free = this.free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                int key = keys[nextI];
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Integer, Character>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            char[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Integer, Character> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                    int[] keys = this.keys;
                    int free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int key = keys[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractCharValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return UpdatableQHashSeparateKVIntCharMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableQHashSeparateKVIntCharMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return UpdatableQHashSeparateKVIntCharMapGO.this.containsValue(o);
        }

        public boolean contains(char v) {
            return UpdatableQHashSeparateKVIntCharMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Character> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            int free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue;
            int[] keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Character.valueOf(vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            int free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue;
            int[] keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(CharPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            int free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue;
            int[] keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(CharCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            int free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue;
            int[] keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(CharCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            int free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue;
            int[] keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(CharSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            int free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue;
            int[] keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeChar(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public CharIterator iterator() {
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public CharCursor cursor() {
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            int free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue;
            int[] keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = Character.valueOf(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            int free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue;
            int[] keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = Character.valueOf(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public char[] toCharArray() {
            int size = this.size();
            char[] result = new char[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            int free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue;
            int[] keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public char[] toArray(char[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new char[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = '\u0000';
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            int free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue;
            int[] keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = '\u0000';
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            int free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue;
            int[] keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeChar(((Character)o).charValue());
        }

        public boolean removeChar(char v) {
            return UpdatableQHashSeparateKVIntCharMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            UpdatableQHashSeparateKVIntCharMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Character> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(CharPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends IntCharEntry {
        private int key;
        private char value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, char value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }
    }

    class MutableEntry
    extends IntCharEntry {
        int modCount;
        private final int index;
        final int key;
        private char value;

        MutableEntry(int modCount, int index, int key, char value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }

        @Override
        public Character setValue(Character newValue) {
            char unwrappedNewValue;
            if (this.modCount != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            char oldValue = this.value;
            this.value = unwrappedNewValue = newValue.charValue();
            this.updateValueInTable(unwrappedNewValue);
            return Character.valueOf(oldValue);
        }

        void updateValueInTable(char newValue) {
            UpdatableQHashSeparateKVIntCharMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class IntCharEntry
    extends AbstractEntry<Integer, Character> {
        IntCharEntry() {
        }

        abstract int key();

        @Override
        public final Integer getKey() {
            return this.key();
        }

        abstract char value();

        @Override
        public final Character getValue() {
            return Character.valueOf(this.value());
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = (Integer)e2.getKey();
                char v2 = ((Character)e2.getValue()).charValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Integer, Character>>
    implements HashObjSet<Map.Entry<Integer, Character>>,
    InternalObjCollectionOps<Map.Entry<Integer, Character>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Integer, Character>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableQHashSeparateKVIntCharMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return UpdatableQHashSeparateKVIntCharMapGO.this.size();
        }

        public double currentLoad() {
            return UpdatableQHashSeparateKVIntCharMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableQHashSeparateKVIntCharMapGO.this.containsEntry((Integer)e.getKey(), ((Character)e.getValue()).charValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            int free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue;
            int[] keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            int free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue;
            int[] keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Integer, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            int free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue;
            int[] keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Integer, Character>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            int free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue;
            int[] keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || predicate.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Integer, Character>> iterator() {
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Integer, Character>> cursor() {
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            int free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue;
            int[] keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            int free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue;
            int[] keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Integer, Character>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            int free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue;
            int[] keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return UpdatableQHashSeparateKVIntCharMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashSeparateKVIntCharMapGO.this.modCount();
            int free = UpdatableQHashSeparateKVIntCharMapGO.this.freeValue;
            int[] keys = UpdatableQHashSeparateKVIntCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVIntCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashSeparateKVIntCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableQHashSeparateKVIntCharMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                int key = (Integer)e.getKey();
                char value = ((Character)e.getValue()).charValue();
                return UpdatableQHashSeparateKVIntCharMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Integer, Character>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            UpdatableQHashSeparateKVIntCharMapGO.this.clear();
        }
    }
}

