/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.collect.impl.InternalLongShortMapOps;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.SeparateKVLongShortQHash;
import net.openhft.collect.impl.hash.UpdatableQHashSeparateKVLongKeyMap;
import net.openhft.collect.map.hash.HashLongShortMap;

public abstract class UpdatableQHashSeparateKVLongShortMapSO
extends UpdatableQHashSeparateKVLongKeyMap
implements HashLongShortMap,
InternalLongShortMapOps,
SeparateKVLongShortQHash {
    short[] values;

    void copy(SeparateKVLongShortQHash hash) {
        super.copy(hash);
        this.values = (short[])hash.valueArray().clone();
    }

    void move(SeparateKVLongShortQHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public short[] valueArray() {
        return this.values;
    }

    int valueIndex(short value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == free || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(short value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Short)value);
    }

    int insert(long key, short value) {
        long free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVLongKeyMixing.mix(key) % capacity;
        long cur = keys[index];
        if (cur == key) {
            return index;
        }
        if (cur != free) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == key) {
                    return bIndex;
                }
                if (cur == free) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == key) {
                    return fIndex;
                }
                if (cur == free) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new short[capacity];
    }
}

