/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.ShortCollection;
import net.openhft.collect.ShortCursor;
import net.openhft.collect.ShortIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.AbstractShortValueView;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.CommonObjShortMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.InternalObjShortMapOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ObjHash;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.SeparateKVObjShortQHash;
import net.openhft.collect.impl.hash.UpdatableQHashSeparateKVObjShortMapSO;
import net.openhft.collect.map.ObjShortCursor;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.ShortSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.ObjShortConsumer;
import net.openhft.function.ObjShortPredicate;
import net.openhft.function.ObjShortToShortFunction;
import net.openhft.function.ShortBinaryOperator;
import net.openhft.function.ShortConsumer;
import net.openhft.function.ShortPredicate;
import net.openhft.function.ToShortFunction;

public class UpdatableQHashSeparateKVObjShortMapGO<K>
extends UpdatableQHashSeparateKVObjShortMapSO<K> {
    @Override
    final void copy(SeparateKVObjShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVObjShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public short defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(Object key, short value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Short get(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public short getShort(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Short getOrDefault(Object key, Short defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public short getOrDefault(Object key, short defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super Short> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void forEach(ObjShortConsumer<? super K> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean forEachWhile(ObjShortPredicate<? super K> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ObjShortCursor<K> cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonObjShortMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalObjShortMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        Object[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalObjShortMapOps<? super K> m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<K, Short>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ShortCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            hashCode += this.nullableKeyHashCode(key) ^ vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            sb.append(' ');
            sb.append(key != this ? key : "(this Map)");
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        Object[] keys = this.set;
        short[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        Object[] newKeys = this.set;
        int capacity = newKeys.length;
        short[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            int index = QHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(key)) % capacity;
            if (newKeys[index] != FREE) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if (newKeys[bIndex] == FREE) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if (newKeys[fIndex] == FREE) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Short put(K key, Short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        short[] vals = this.values;
        short prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public short put(K key, short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        short[] vals = this.values;
        short prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public Short putIfAbsent(K key, Short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    @Override
    public short putIfAbsent(K key, short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    @Override
    public void justPut(K key, short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Short compute(K key, BiFunction<? super K, ? super Short, ? extends Short> remappingFunction) {
        if (key != null) {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacity = keys.length;
            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            cur = keys[index];
            if (cur != key) {
                if (cur != UpdatableQHashSeparateKVObjShortMapGO.FREE) {
                    if (!this.keyEquals(key, cur)) {
                        bIndex = index;
                        fIndex = index;
                        step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjShortMapGO.FREE) {
                                index = bIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break;
                            }
                            t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjShortMapGO.FREE) {
                                index = fIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    if ((newValue = remappingFunction.apply(key, null)) != null) {
                        this.incrementModCount();
                        keys[index] = key;
                        vals[index] = newValue;
                        this.postInsertHook();
                        return newValue;
                    }
                    return null;
                }
            }
            if ((newValue = remappingFunction.apply(key, vals[index])) != null) {
                vals[index] = newValue;
                return newValue;
            }
            throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
        }
        return this.computeNullKey(remappingFunction);
    }

    Short computeNullKey(BiFunction<? super K, ? super Short, ? extends Short> remappingFunction) {
        Short newValue;
        int index;
        short[] vals;
        block12: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                Short newValue2;
                if (cur != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == null) {
                            index = bIndex;
                            break block12;
                        }
                        if (cur == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == null) {
                            index = fIndex;
                            break block12;
                        }
                        if (cur == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                if ((newValue2 = remappingFunction.apply(null, null)) != null) {
                    this.incrementModCount();
                    keys[index] = null;
                    vals[index] = newValue2;
                    this.postInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(null, vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public short compute(K key, ObjShortToShortFunction<? super K> remappingFunction) {
        if (key != null) {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacity = keys.length;
            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            cur = keys[index];
            if (cur != key) {
                if (cur != UpdatableQHashSeparateKVObjShortMapGO.FREE) {
                    if (!this.keyEquals(key, cur)) {
                        bIndex = index;
                        fIndex = index;
                        step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjShortMapGO.FREE) {
                                index = bIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break;
                            }
                            t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjShortMapGO.FREE) {
                                index = fIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    newValue = remappingFunction.applyAsShort(key, this.defaultValue());
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = newValue;
                    this.postInsertHook();
                    return newValue;
                }
            }
            vals[index] = newValue = remappingFunction.applyAsShort(key, vals[index]);
            return newValue;
        }
        return this.computeNullKey(remappingFunction);
    }

    short computeNullKey(ObjShortToShortFunction<? super K> remappingFunction) {
        short newValue;
        int index;
        short[] vals;
        block10: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                if (cur != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == null) {
                            index = bIndex;
                            break block10;
                        }
                        if (cur == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == null) {
                            index = fIndex;
                            break block10;
                        }
                        if (cur == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newValue = remappingFunction.applyAsShort(null, this.defaultValue());
                this.incrementModCount();
                keys[index] = null;
                vals[index] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsShort(null, vals[index]);
        return newValue;
    }

    @Override
    public Short computeIfAbsent(K key, Function<? super K, ? extends Short> mappingFunction) {
        if (key != null) {
            Short value;
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            short[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            Object cur = keys[index];
            if (cur != FREE) {
                if (cur == key || this.keyEquals(key, cur)) {
                    return vals[index];
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == FREE) {
                        index = bIndex;
                        break;
                    }
                    if (cur == key || this.keyEquals(key, cur)) {
                        return vals[bIndex];
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == FREE) {
                        index = fIndex;
                        break;
                    }
                    if (cur == key || this.keyEquals(key, cur)) {
                        return vals[fIndex];
                    }
                    step += 2;
                }
            }
            if ((value = mappingFunction.apply(key)) != null) {
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
            return null;
        }
        return this.computeIfAbsentNullKey(mappingFunction);
    }

    Short computeIfAbsentNullKey(Function<? super K, ? extends Short> mappingFunction) {
        Short value;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        Object[] keys = this.set;
        short[] vals = this.values;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != FREE) {
            if (cur == null) {
                return vals[index];
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == FREE) {
                    index = bIndex;
                    break;
                }
                if (cur == null) {
                    return vals[bIndex];
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == FREE) {
                    index = fIndex;
                    break;
                }
                if (cur == null) {
                    return vals[fIndex];
                }
                step += 2;
            }
        }
        if ((value = mappingFunction.apply(null)) != null) {
            this.incrementModCount();
            keys[index] = null;
            vals[index] = value;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public short computeIfAbsent(K key, ToShortFunction<? super K> mappingFunction) {
        if (key != null) {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            short[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            Object cur = keys[index];
            if (cur != FREE) {
                if (cur == key || this.keyEquals(key, cur)) {
                    return vals[index];
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == FREE) {
                        index = bIndex;
                        break;
                    }
                    if (cur == key || this.keyEquals(key, cur)) {
                        return vals[bIndex];
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == FREE) {
                        index = fIndex;
                        break;
                    }
                    if (cur == key || this.keyEquals(key, cur)) {
                        return vals[fIndex];
                    }
                    step += 2;
                }
            }
            short value = mappingFunction.applyAsShort(key);
            this.incrementModCount();
            keys[index] = key;
            vals[index] = value;
            this.postInsertHook();
            return value;
        }
        return this.computeIfAbsentNullKey(mappingFunction);
    }

    short computeIfAbsentNullKey(ToShortFunction<? super K> mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        Object[] keys = this.set;
        short[] vals = this.values;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != FREE) {
            if (cur == null) {
                return vals[index];
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == FREE) {
                    index = bIndex;
                    break;
                }
                if (cur == null) {
                    return vals[bIndex];
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == FREE) {
                    index = fIndex;
                    break;
                }
                if (cur == null) {
                    return vals[fIndex];
                }
                step += 2;
            }
        }
        short value = mappingFunction.applyAsShort(null);
        this.incrementModCount();
        keys[index] = null;
        vals[index] = value;
        this.postInsertHook();
        return value;
    }

    @Override
    public Short computeIfPresent(K key, BiFunction<? super K, ? super Short, ? extends Short> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            short[] vals = this.values;
            Short newValue = remappingFunction.apply(key, vals[index]);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public short computeIfPresent(K key, ObjShortToShortFunction<? super K> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            short newValue;
            short[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsShort(key, vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Short merge(K key, Short value, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        if (key != null) {
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacity = keys.length;
            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            cur = keys[index];
            if (cur != key) {
                if (cur != UpdatableQHashSeparateKVObjShortMapGO.FREE) {
                    if (!this.keyEquals(key, cur)) {
                        bIndex = index;
                        fIndex = index;
                        step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjShortMapGO.FREE) {
                                index = bIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break;
                            }
                            t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjShortMapGO.FREE) {
                                index = fIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = value;
                    this.postInsertHook();
                    return value;
                }
            }
            if ((newValue = remappingFunction.apply((Short)vals[index], value)) != null) {
                vals[index] = newValue;
                return newValue;
            }
            throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
        }
        return this.mergeNullKey(value, remappingFunction);
    }

    Short mergeNullKey(Short value, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        Short newValue;
        int index;
        short[] vals;
        block12: {
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                if (cur != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == null) {
                            index = bIndex;
                            break block12;
                        }
                        if (cur == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == null) {
                            index = fIndex;
                            break block12;
                        }
                        if (cur == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                keys[index] = null;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Short)vals[index], value)) != null) {
            vals[index] = newValue;
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public short merge(K key, short value, ShortBinaryOperator remappingFunction) {
        if (key != null) {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacity = keys.length;
            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            cur = keys[index];
            if (cur != key) {
                if (cur != UpdatableQHashSeparateKVObjShortMapGO.FREE) {
                    if (!this.keyEquals(key, cur)) {
                        bIndex = index;
                        fIndex = index;
                        step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjShortMapGO.FREE) {
                                index = bIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break;
                            }
                            t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjShortMapGO.FREE) {
                                index = fIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = value;
                    this.postInsertHook();
                    return value;
                }
            }
            vals[index] = newValue = remappingFunction.applyAsShort(vals[index], value);
            return newValue;
        }
        return this.mergeNullKey(value, remappingFunction);
    }

    short mergeNullKey(short value, ShortBinaryOperator remappingFunction) {
        short newValue;
        int index;
        short[] vals;
        block10: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                if (cur != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == null) {
                            index = bIndex;
                            break block10;
                        }
                        if (cur == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == null) {
                            index = fIndex;
                            break block10;
                        }
                        if (cur == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                keys[index] = null;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsShort(vals[index], value);
        return newValue;
    }

    public short addValue(K key, short value) {
        short newValue;
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        short[] vals = this.values;
        vals[index] = newValue = (short)(vals[index] + value);
        return newValue;
    }

    public short addValue(K key, short addition, short defaultValue) {
        short newValue;
        short value = (short)(defaultValue + addition);
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        short[] vals = this.values;
        vals[index] = newValue = (short)(vals[index] + addition);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends Short> m) {
        CommonObjShortMapOps.putAll(this, m);
    }

    @Override
    public Short replace(K key, Short value) {
        int index = this.index(key);
        if (index >= 0) {
            short[] vals = this.values;
            short oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return null;
    }

    @Override
    public short replace(K key, short value) {
        int index = this.index(key);
        if (index >= 0) {
            short[] vals = this.values;
            short oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(K key, Short oldValue, Short newValue) {
        return this.replace(key, (short)oldValue, (short)newValue);
    }

    @Override
    public boolean replace(K key, short oldValue, short newValue) {
        int index = this.index(key);
        if (index >= 0) {
            short[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super Short, ? extends Short> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            vals[i] = function.apply(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ObjShortToShortFunction<? super K> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            vals[i] = function.applyAsShort(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Short remove(Object key) {
        throw new UnsupportedOperationException();
    }

    Short removeNullKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(Object key) {
        throw new UnsupportedOperationException();
    }

    boolean justRemoveNullKey() {
        throw new UnsupportedOperationException();
    }

    public short removeAsShort(Object key) {
        throw new UnsupportedOperationException();
    }

    short removeAsShortNullKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(key, (Short)value);
    }

    public boolean remove(Object key, short value) {
        throw new UnsupportedOperationException();
    }

    boolean removeEntryNullKey(short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(ObjShortPredicate<? super K> filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ObjShortCursor<K> {
        final K[] keys;
        final short[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        short curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ObjShortConsumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            short[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public K key() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public short value() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(short value) {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements ShortCursor {
        final K[] keys;
        final short[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        short curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            short[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public short elem() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements ShortIterator {
        final K[] keys;
        final short[] vals;
        int expectedModCount;
        int nextIndex;
        short next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            Object[] keys = this.keys;
            this.vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            short[] vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == ObjHash.FREE) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                    K[] keys = this.keys;
                    short prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == ObjHash.FREE) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            short[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept((Short)vals[i]);
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            short[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, Short>> {
        final K[] keys;
        final short[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        short curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            short[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public Map.Entry<K, Short> elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, Short>> {
        final K[] keys;
        final short[] vals;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            Object[] keys = this.keys;
            this.vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            short[] vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, Short>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            short[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, Short> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                    K[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        Object key = keys[nextI];
                        if (key == ObjHash.FREE) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractShortValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return UpdatableQHashSeparateKVObjShortMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableQHashSeparateKVObjShortMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return UpdatableQHashSeparateKVObjShortMapGO.this.containsValue(o);
        }

        public boolean contains(short v) {
            return UpdatableQHashSeparateKVObjShortMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Short> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            short[] vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept((Short)vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            short[] vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(ShortPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            short[] vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(ShortCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            short[] vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(ShortCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            short[] vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(ShortSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            short[] vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= s.removeShort(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ShortIterator iterator() {
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ShortCursor cursor() {
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            short[] vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            short[] vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public short[] toShortArray() {
            int size = this.size();
            short[] result = new short[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            short[] vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public short[] toArray(short[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new short[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            short[] vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            short[] vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeShort((Short)o);
        }

        public boolean removeShort(short v) {
            return UpdatableQHashSeparateKVObjShortMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            UpdatableQHashSeparateKVObjShortMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Short> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(ShortPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ObjShortEntry {
        private K key;
        private short value;

        ReusableEntry() {
        }

        ReusableEntry with(K key, short value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ObjShortEntry {
        int modCount;
        private final int index;
        final K key;
        private short value;

        MutableEntry(int modCount, int index, K key, short value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }

        @Override
        public Short setValue(Short newValue) {
            short unwrappedNewValue;
            if (this.modCount != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            short oldValue = this.value;
            this.value = unwrappedNewValue = newValue.shortValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(short newValue) {
            UpdatableQHashSeparateKVObjShortMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class ObjShortEntry
    extends AbstractEntry<K, Short> {
        ObjShortEntry() {
        }

        abstract K key();

        @Override
        public final K getKey() {
            return this.key();
        }

        abstract short value();

        @Override
        public final Short getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                Object k2 = e2.getKey();
                short v2 = (Short)e2.getValue();
                return UpdatableQHashSeparateKVObjShortMapGO.this.nullableKeyEquals(this.key(), k2) && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return UpdatableQHashSeparateKVObjShortMapGO.this.nullableKeyHashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<K, Short>>
    implements HashObjSet<Map.Entry<K, Short>>,
    InternalObjCollectionOps<Map.Entry<K, Short>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<K, Short>> equivalence() {
            return Equivalence.entryEquivalence(UpdatableQHashSeparateKVObjShortMapGO.this.keyEquivalence(), null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableQHashSeparateKVObjShortMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return UpdatableQHashSeparateKVObjShortMapGO.this.size();
        }

        public double currentLoad() {
            return UpdatableQHashSeparateKVObjShortMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableQHashSeparateKVObjShortMapGO.this.containsEntry(e.getKey(), (Short)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            short[] vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            short[] vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<K, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            short[] vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<K, Short>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            short[] vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || predicate.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<K, Short>> iterator() {
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<K, Short>> cursor() {
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            short[] vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            short[] vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<K, Short>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            short[] vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return UpdatableQHashSeparateKVObjShortMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashSeparateKVObjShortMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjShortMapGO.this.set;
            short[] vals = UpdatableQHashSeparateKVObjShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Collection)");
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashSeparateKVObjShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableQHashSeparateKVObjShortMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                short value = (Short)e.getValue();
                return UpdatableQHashSeparateKVObjShortMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<K, Short>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            UpdatableQHashSeparateKVObjShortMapGO.this.clear();
        }
    }
}

