/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashByteLongMap}s.
 *
 * @see HashByteLongMap
 * @see HashByteLongMaps#getDefaultFactory()
 */
public interface HashByteLongMapFactory
        extends ByteLongMapFactory<HashByteLongMapFactory>
        , ByteHashFactory<HashByteLongMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashByteLongMap newMutableMap();

    @Override
    @Nonnull
     HashByteLongMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashByteLongMap newMutableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2, int expectedSize);

    @Override
    @Nonnull
     HashByteLongMap newMutableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2,
            @Nonnull Map<Byte, Long> map3, int expectedSize);

    @Override
    @Nonnull
     HashByteLongMap newMutableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2,
            @Nonnull Map<Byte, Long> map3,
            @Nonnull Map<Byte, Long> map4, int expectedSize);

    @Override
    @Nonnull
     HashByteLongMap newMutableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2,
            @Nonnull Map<Byte, Long> map3,
            @Nonnull Map<Byte, Long> map4,
            @Nonnull Map<Byte, Long> map5, int expectedSize);



    @Override
    @Nonnull
     HashByteLongMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ByteLongConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashByteLongMap newMutableMap(
            @Nonnull byte[] keys, @Nonnull long[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteLongMap newMutableMap(
            @Nonnull Byte[] keys, @Nonnull Long[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteLongMap newMutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Long> values, int expectedSize);

    

    @Override
    @Nonnull
     HashByteLongMap newMutableMap(
            @Nonnull Map<Byte, Long> map);

    @Override
    @Nonnull
     HashByteLongMap newMutableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2);

    @Override
    @Nonnull
     HashByteLongMap newMutableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2,
            @Nonnull Map<Byte, Long> map3);

    @Override
    @Nonnull
     HashByteLongMap newMutableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2,
            @Nonnull Map<Byte, Long> map3,
            @Nonnull Map<Byte, Long> map4);

    @Override
    @Nonnull
     HashByteLongMap newMutableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2,
            @Nonnull Map<Byte, Long> map3,
            @Nonnull Map<Byte, Long> map4,
            @Nonnull Map<Byte, Long> map5);



    @Override
    @Nonnull
     HashByteLongMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ByteLongConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashByteLongMap newMutableMap(
            @Nonnull byte[] keys, @Nonnull long[] values);

    @Override
    @Nonnull
     HashByteLongMap newMutableMap(
            @Nonnull Byte[] keys, @Nonnull Long[] values);

    @Override
    @Nonnull
     HashByteLongMap newMutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Long> values);


    @Override
    @Nonnull
     HashByteLongMap newMutableMapOf(byte k1, long v1);

    @Override
    @Nonnull
     HashByteLongMap newMutableMapOf(byte k1, long v1,
            byte k2, long v2);

    @Override
    @Nonnull
     HashByteLongMap newMutableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3);

    @Override
    @Nonnull
     HashByteLongMap newMutableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3,
            byte k4, long v4);

    @Override
    @Nonnull
     HashByteLongMap newMutableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3,
            byte k4, long v4, byte k5, long v5);
    @Override
    @Nonnull
     HashByteLongMap newUpdatableMap();

    @Override
    @Nonnull
     HashByteLongMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashByteLongMap newUpdatableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2, int expectedSize);

    @Override
    @Nonnull
     HashByteLongMap newUpdatableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2,
            @Nonnull Map<Byte, Long> map3, int expectedSize);

    @Override
    @Nonnull
     HashByteLongMap newUpdatableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2,
            @Nonnull Map<Byte, Long> map3,
            @Nonnull Map<Byte, Long> map4, int expectedSize);

    @Override
    @Nonnull
     HashByteLongMap newUpdatableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2,
            @Nonnull Map<Byte, Long> map3,
            @Nonnull Map<Byte, Long> map4,
            @Nonnull Map<Byte, Long> map5, int expectedSize);



    @Override
    @Nonnull
     HashByteLongMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ByteLongConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashByteLongMap newUpdatableMap(
            @Nonnull byte[] keys, @Nonnull long[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteLongMap newUpdatableMap(
            @Nonnull Byte[] keys, @Nonnull Long[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteLongMap newUpdatableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Long> values, int expectedSize);

    

    @Override
    @Nonnull
     HashByteLongMap newUpdatableMap(
            @Nonnull Map<Byte, Long> map);

    @Override
    @Nonnull
     HashByteLongMap newUpdatableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2);

    @Override
    @Nonnull
     HashByteLongMap newUpdatableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2,
            @Nonnull Map<Byte, Long> map3);

    @Override
    @Nonnull
     HashByteLongMap newUpdatableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2,
            @Nonnull Map<Byte, Long> map3,
            @Nonnull Map<Byte, Long> map4);

    @Override
    @Nonnull
     HashByteLongMap newUpdatableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2,
            @Nonnull Map<Byte, Long> map3,
            @Nonnull Map<Byte, Long> map4,
            @Nonnull Map<Byte, Long> map5);



    @Override
    @Nonnull
     HashByteLongMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ByteLongConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashByteLongMap newUpdatableMap(
            @Nonnull byte[] keys, @Nonnull long[] values);

    @Override
    @Nonnull
     HashByteLongMap newUpdatableMap(
            @Nonnull Byte[] keys, @Nonnull Long[] values);

    @Override
    @Nonnull
     HashByteLongMap newUpdatableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Long> values);


    @Override
    @Nonnull
     HashByteLongMap newUpdatableMapOf(byte k1, long v1);

    @Override
    @Nonnull
     HashByteLongMap newUpdatableMapOf(byte k1, long v1,
            byte k2, long v2);

    @Override
    @Nonnull
     HashByteLongMap newUpdatableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3);

    @Override
    @Nonnull
     HashByteLongMap newUpdatableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3,
            byte k4, long v4);

    @Override
    @Nonnull
     HashByteLongMap newUpdatableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3,
            byte k4, long v4, byte k5, long v5);

    


    @Override
    @Nonnull
     HashByteLongMap newImmutableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2, int expectedSize);

    @Override
    @Nonnull
     HashByteLongMap newImmutableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2,
            @Nonnull Map<Byte, Long> map3, int expectedSize);

    @Override
    @Nonnull
     HashByteLongMap newImmutableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2,
            @Nonnull Map<Byte, Long> map3,
            @Nonnull Map<Byte, Long> map4, int expectedSize);

    @Override
    @Nonnull
     HashByteLongMap newImmutableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2,
            @Nonnull Map<Byte, Long> map3,
            @Nonnull Map<Byte, Long> map4,
            @Nonnull Map<Byte, Long> map5, int expectedSize);



    @Override
    @Nonnull
     HashByteLongMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ByteLongConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashByteLongMap newImmutableMap(
            @Nonnull byte[] keys, @Nonnull long[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteLongMap newImmutableMap(
            @Nonnull Byte[] keys, @Nonnull Long[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteLongMap newImmutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Long> values, int expectedSize);

    

    @Override
    @Nonnull
     HashByteLongMap newImmutableMap(
            @Nonnull Map<Byte, Long> map);

    @Override
    @Nonnull
     HashByteLongMap newImmutableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2);

    @Override
    @Nonnull
     HashByteLongMap newImmutableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2,
            @Nonnull Map<Byte, Long> map3);

    @Override
    @Nonnull
     HashByteLongMap newImmutableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2,
            @Nonnull Map<Byte, Long> map3,
            @Nonnull Map<Byte, Long> map4);

    @Override
    @Nonnull
     HashByteLongMap newImmutableMap(@Nonnull Map<Byte, Long> map1,
            @Nonnull Map<Byte, Long> map2,
            @Nonnull Map<Byte, Long> map3,
            @Nonnull Map<Byte, Long> map4,
            @Nonnull Map<Byte, Long> map5);



    @Override
    @Nonnull
     HashByteLongMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ByteLongConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashByteLongMap newImmutableMap(
            @Nonnull byte[] keys, @Nonnull long[] values);

    @Override
    @Nonnull
     HashByteLongMap newImmutableMap(
            @Nonnull Byte[] keys, @Nonnull Long[] values);

    @Override
    @Nonnull
     HashByteLongMap newImmutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Long> values);


    @Override
    @Nonnull
     HashByteLongMap newImmutableMapOf(byte k1, long v1);

    @Override
    @Nonnull
     HashByteLongMap newImmutableMapOf(byte k1, long v1,
            byte k2, long v2);

    @Override
    @Nonnull
     HashByteLongMap newImmutableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3);

    @Override
    @Nonnull
     HashByteLongMap newImmutableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3,
            byte k4, long v4);

    @Override
    @Nonnull
     HashByteLongMap newImmutableMapOf(byte k1, long v1,
            byte k2, long v2, byte k3, long v3,
            byte k4, long v4, byte k5, long v5);
}

