/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashIntCharMap}s.
 *
 * @see HashIntCharMap
 * @see HashIntCharMaps#getDefaultFactory()
 */
public interface HashIntCharMapFactory
        extends IntCharMapFactory<HashIntCharMapFactory>
        , IntHashFactory<HashIntCharMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashIntCharMap newMutableMap();

    @Override
    @Nonnull
     HashIntCharMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashIntCharMap newMutableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2, int expectedSize);

    @Override
    @Nonnull
     HashIntCharMap newMutableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2,
            @Nonnull Map<Integer, Character> map3, int expectedSize);

    @Override
    @Nonnull
     HashIntCharMap newMutableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2,
            @Nonnull Map<Integer, Character> map3,
            @Nonnull Map<Integer, Character> map4, int expectedSize);

    @Override
    @Nonnull
     HashIntCharMap newMutableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2,
            @Nonnull Map<Integer, Character> map3,
            @Nonnull Map<Integer, Character> map4,
            @Nonnull Map<Integer, Character> map5, int expectedSize);



    @Override
    @Nonnull
     HashIntCharMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntCharConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashIntCharMap newMutableMap(
            @Nonnull int[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntCharMap newMutableMap(
            @Nonnull Integer[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntCharMap newMutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
     HashIntCharMap newMutableMap(
            @Nonnull Map<Integer, Character> map);

    @Override
    @Nonnull
     HashIntCharMap newMutableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2);

    @Override
    @Nonnull
     HashIntCharMap newMutableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2,
            @Nonnull Map<Integer, Character> map3);

    @Override
    @Nonnull
     HashIntCharMap newMutableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2,
            @Nonnull Map<Integer, Character> map3,
            @Nonnull Map<Integer, Character> map4);

    @Override
    @Nonnull
     HashIntCharMap newMutableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2,
            @Nonnull Map<Integer, Character> map3,
            @Nonnull Map<Integer, Character> map4,
            @Nonnull Map<Integer, Character> map5);



    @Override
    @Nonnull
     HashIntCharMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntCharConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashIntCharMap newMutableMap(
            @Nonnull int[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
     HashIntCharMap newMutableMap(
            @Nonnull Integer[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
     HashIntCharMap newMutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
     HashIntCharMap newMutableMapOf(int k1, char v1);

    @Override
    @Nonnull
     HashIntCharMap newMutableMapOf(int k1, char v1,
            int k2, char v2);

    @Override
    @Nonnull
     HashIntCharMap newMutableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3);

    @Override
    @Nonnull
     HashIntCharMap newMutableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3,
            int k4, char v4);

    @Override
    @Nonnull
     HashIntCharMap newMutableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3,
            int k4, char v4, int k5, char v5);
    @Override
    @Nonnull
     HashIntCharMap newUpdatableMap();

    @Override
    @Nonnull
     HashIntCharMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashIntCharMap newUpdatableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2, int expectedSize);

    @Override
    @Nonnull
     HashIntCharMap newUpdatableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2,
            @Nonnull Map<Integer, Character> map3, int expectedSize);

    @Override
    @Nonnull
     HashIntCharMap newUpdatableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2,
            @Nonnull Map<Integer, Character> map3,
            @Nonnull Map<Integer, Character> map4, int expectedSize);

    @Override
    @Nonnull
     HashIntCharMap newUpdatableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2,
            @Nonnull Map<Integer, Character> map3,
            @Nonnull Map<Integer, Character> map4,
            @Nonnull Map<Integer, Character> map5, int expectedSize);



    @Override
    @Nonnull
     HashIntCharMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntCharConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashIntCharMap newUpdatableMap(
            @Nonnull int[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntCharMap newUpdatableMap(
            @Nonnull Integer[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntCharMap newUpdatableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
     HashIntCharMap newUpdatableMap(
            @Nonnull Map<Integer, Character> map);

    @Override
    @Nonnull
     HashIntCharMap newUpdatableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2);

    @Override
    @Nonnull
     HashIntCharMap newUpdatableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2,
            @Nonnull Map<Integer, Character> map3);

    @Override
    @Nonnull
     HashIntCharMap newUpdatableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2,
            @Nonnull Map<Integer, Character> map3,
            @Nonnull Map<Integer, Character> map4);

    @Override
    @Nonnull
     HashIntCharMap newUpdatableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2,
            @Nonnull Map<Integer, Character> map3,
            @Nonnull Map<Integer, Character> map4,
            @Nonnull Map<Integer, Character> map5);



    @Override
    @Nonnull
     HashIntCharMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntCharConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashIntCharMap newUpdatableMap(
            @Nonnull int[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
     HashIntCharMap newUpdatableMap(
            @Nonnull Integer[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
     HashIntCharMap newUpdatableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
     HashIntCharMap newUpdatableMapOf(int k1, char v1);

    @Override
    @Nonnull
     HashIntCharMap newUpdatableMapOf(int k1, char v1,
            int k2, char v2);

    @Override
    @Nonnull
     HashIntCharMap newUpdatableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3);

    @Override
    @Nonnull
     HashIntCharMap newUpdatableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3,
            int k4, char v4);

    @Override
    @Nonnull
     HashIntCharMap newUpdatableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3,
            int k4, char v4, int k5, char v5);

    


    @Override
    @Nonnull
     HashIntCharMap newImmutableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2, int expectedSize);

    @Override
    @Nonnull
     HashIntCharMap newImmutableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2,
            @Nonnull Map<Integer, Character> map3, int expectedSize);

    @Override
    @Nonnull
     HashIntCharMap newImmutableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2,
            @Nonnull Map<Integer, Character> map3,
            @Nonnull Map<Integer, Character> map4, int expectedSize);

    @Override
    @Nonnull
     HashIntCharMap newImmutableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2,
            @Nonnull Map<Integer, Character> map3,
            @Nonnull Map<Integer, Character> map4,
            @Nonnull Map<Integer, Character> map5, int expectedSize);



    @Override
    @Nonnull
     HashIntCharMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntCharConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashIntCharMap newImmutableMap(
            @Nonnull int[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntCharMap newImmutableMap(
            @Nonnull Integer[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntCharMap newImmutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
     HashIntCharMap newImmutableMap(
            @Nonnull Map<Integer, Character> map);

    @Override
    @Nonnull
     HashIntCharMap newImmutableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2);

    @Override
    @Nonnull
     HashIntCharMap newImmutableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2,
            @Nonnull Map<Integer, Character> map3);

    @Override
    @Nonnull
     HashIntCharMap newImmutableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2,
            @Nonnull Map<Integer, Character> map3,
            @Nonnull Map<Integer, Character> map4);

    @Override
    @Nonnull
     HashIntCharMap newImmutableMap(@Nonnull Map<Integer, Character> map1,
            @Nonnull Map<Integer, Character> map2,
            @Nonnull Map<Integer, Character> map3,
            @Nonnull Map<Integer, Character> map4,
            @Nonnull Map<Integer, Character> map5);



    @Override
    @Nonnull
     HashIntCharMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntCharConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashIntCharMap newImmutableMap(
            @Nonnull int[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
     HashIntCharMap newImmutableMap(
            @Nonnull Integer[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
     HashIntCharMap newImmutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
     HashIntCharMap newImmutableMapOf(int k1, char v1);

    @Override
    @Nonnull
     HashIntCharMap newImmutableMapOf(int k1, char v1,
            int k2, char v2);

    @Override
    @Nonnull
     HashIntCharMap newImmutableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3);

    @Override
    @Nonnull
     HashIntCharMap newImmutableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3,
            int k4, char v4);

    @Override
    @Nonnull
     HashIntCharMap newImmutableMapOf(int k1, char v1,
            int k2, char v2, int k3, char v3,
            int k4, char v4, int k5, char v5);
}

