/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.hash.HashContainer;
import net.openhft.koloboke.collect.map.LongDoubleMap;
import net.openhft.koloboke.collect.set.hash.HashLongSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import javax.annotation.Nonnull;


/**
 * An interface for {@code LongDoubleMap}s, based on hash tables.
 *
 * <p>This interface doesn't carry own specific behaviour, just combines it's superinterfaces.
 *
 * <p>Looking for a way to instantiate a {@code HashLongDoubleMap}? See static factory methods
 * in {@link HashLongDoubleMaps} class.
 *
 * @see HashLongDoubleMapFactory
 * @see HashLongDoubleMaps
 */
public interface HashLongDoubleMap extends LongDoubleMap, HashContainer {

    @Override
    @Nonnull
    HashLongSet keySet();

    @Override
    @Nonnull
    HashObjSet<Entry<Long, Double>> entrySet();
}

