/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashLongObjMap}s.
 *
 * @see HashLongObjMap
 * @see HashLongObjMaps#getDefaultFactory()
 */
public interface HashLongObjMapFactory<V>
        extends LongObjMapFactory<V, HashLongObjMapFactory<V>>
        , LongHashFactory<HashLongObjMapFactory<V>>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMap();

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2,
            @Nonnull Map<Long, ? extends V2> map3, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2,
            @Nonnull Map<Long, ? extends V2> map3,
            @Nonnull Map<Long, ? extends V2> map4, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2,
            @Nonnull Map<Long, ? extends V2> map3,
            @Nonnull Map<Long, ? extends V2> map4,
            @Nonnull Map<Long, ? extends V2> map5, int expectedSize);



    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.LongObjConsumer<V2>> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMap(
            @Nonnull long[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMap(
            @Nonnull Long[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<? extends V2> values, int expectedSize);

    

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMap(
            @Nonnull Map<Long, ? extends V2> map);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2,
            @Nonnull Map<Long, ? extends V2> map3);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2,
            @Nonnull Map<Long, ? extends V2> map3,
            @Nonnull Map<Long, ? extends V2> map4);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2,
            @Nonnull Map<Long, ? extends V2> map3,
            @Nonnull Map<Long, ? extends V2> map4,
            @Nonnull Map<Long, ? extends V2> map5);



    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.LongObjConsumer<V2>> entriesSupplier
            );

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMap(
            @Nonnull long[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMap(
            @Nonnull Long[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<? extends V2> values);


    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMapOf(long k1, V2 v1);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMapOf(long k1, V2 v1,
            long k2, V2 v2);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMapOf(long k1, V2 v1,
            long k2, V2 v2, long k3, V2 v3);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMapOf(long k1, V2 v1,
            long k2, V2 v2, long k3, V2 v3,
            long k4, V2 v4);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newMutableMapOf(long k1, V2 v1,
            long k2, V2 v2, long k3, V2 v3,
            long k4, V2 v4, long k5, V2 v5);
    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMap();

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2,
            @Nonnull Map<Long, ? extends V2> map3, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2,
            @Nonnull Map<Long, ? extends V2> map3,
            @Nonnull Map<Long, ? extends V2> map4, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2,
            @Nonnull Map<Long, ? extends V2> map3,
            @Nonnull Map<Long, ? extends V2> map4,
            @Nonnull Map<Long, ? extends V2> map5, int expectedSize);



    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.LongObjConsumer<V2>> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMap(
            @Nonnull long[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMap(
            @Nonnull Long[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<? extends V2> values, int expectedSize);

    

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMap(
            @Nonnull Map<Long, ? extends V2> map);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2,
            @Nonnull Map<Long, ? extends V2> map3);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2,
            @Nonnull Map<Long, ? extends V2> map3,
            @Nonnull Map<Long, ? extends V2> map4);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2,
            @Nonnull Map<Long, ? extends V2> map3,
            @Nonnull Map<Long, ? extends V2> map4,
            @Nonnull Map<Long, ? extends V2> map5);



    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.LongObjConsumer<V2>> entriesSupplier
            );

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMap(
            @Nonnull long[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMap(
            @Nonnull Long[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<? extends V2> values);


    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMapOf(long k1, V2 v1);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMapOf(long k1, V2 v1,
            long k2, V2 v2);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMapOf(long k1, V2 v1,
            long k2, V2 v2, long k3, V2 v3);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMapOf(long k1, V2 v1,
            long k2, V2 v2, long k3, V2 v3,
            long k4, V2 v4);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newUpdatableMapOf(long k1, V2 v1,
            long k2, V2 v2, long k3, V2 v3,
            long k4, V2 v4, long k5, V2 v5);

    


    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2,
            @Nonnull Map<Long, ? extends V2> map3, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2,
            @Nonnull Map<Long, ? extends V2> map3,
            @Nonnull Map<Long, ? extends V2> map4, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2,
            @Nonnull Map<Long, ? extends V2> map3,
            @Nonnull Map<Long, ? extends V2> map4,
            @Nonnull Map<Long, ? extends V2> map5, int expectedSize);



    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.LongObjConsumer<V2>> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMap(
            @Nonnull long[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMap(
            @Nonnull Long[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<? extends V2> values, int expectedSize);

    

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMap(
            @Nonnull Map<Long, ? extends V2> map);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2,
            @Nonnull Map<Long, ? extends V2> map3);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2,
            @Nonnull Map<Long, ? extends V2> map3,
            @Nonnull Map<Long, ? extends V2> map4);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMap(@Nonnull Map<Long, ? extends V2> map1,
            @Nonnull Map<Long, ? extends V2> map2,
            @Nonnull Map<Long, ? extends V2> map3,
            @Nonnull Map<Long, ? extends V2> map4,
            @Nonnull Map<Long, ? extends V2> map5);



    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.LongObjConsumer<V2>> entriesSupplier
            );

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMap(
            @Nonnull long[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMap(
            @Nonnull Long[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<? extends V2> values);


    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMapOf(long k1, V2 v1);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMapOf(long k1, V2 v1,
            long k2, V2 v2);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMapOf(long k1, V2 v1,
            long k2, V2 v2, long k3, V2 v3);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMapOf(long k1, V2 v1,
            long k2, V2 v2, long k3, V2 v3,
            long k4, V2 v4);

    @Override
    @Nonnull
    <V2 extends V> HashLongObjMap<V2> newImmutableMapOf(long k1, V2 v1,
            long k2, V2 v2, long k3, V2 v3,
            long k4, V2 v4, long k5, V2 v5);
}

