/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashShortLongMap}s.
 *
 * @see HashShortLongMap
 * @see HashShortLongMaps#getDefaultFactory()
 */
public interface HashShortLongMapFactory
        extends ShortLongMapFactory<HashShortLongMapFactory>
        , ShortHashFactory<HashShortLongMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashShortLongMap newMutableMap();

    @Override
    @Nonnull
     HashShortLongMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashShortLongMap newMutableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2, int expectedSize);

    @Override
    @Nonnull
     HashShortLongMap newMutableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2,
            @Nonnull Map<Short, Long> map3, int expectedSize);

    @Override
    @Nonnull
     HashShortLongMap newMutableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2,
            @Nonnull Map<Short, Long> map3,
            @Nonnull Map<Short, Long> map4, int expectedSize);

    @Override
    @Nonnull
     HashShortLongMap newMutableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2,
            @Nonnull Map<Short, Long> map3,
            @Nonnull Map<Short, Long> map4,
            @Nonnull Map<Short, Long> map5, int expectedSize);



    @Override
    @Nonnull
     HashShortLongMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortLongConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashShortLongMap newMutableMap(
            @Nonnull short[] keys, @Nonnull long[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortLongMap newMutableMap(
            @Nonnull Short[] keys, @Nonnull Long[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortLongMap newMutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Long> values, int expectedSize);

    

    @Override
    @Nonnull
     HashShortLongMap newMutableMap(
            @Nonnull Map<Short, Long> map);

    @Override
    @Nonnull
     HashShortLongMap newMutableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2);

    @Override
    @Nonnull
     HashShortLongMap newMutableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2,
            @Nonnull Map<Short, Long> map3);

    @Override
    @Nonnull
     HashShortLongMap newMutableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2,
            @Nonnull Map<Short, Long> map3,
            @Nonnull Map<Short, Long> map4);

    @Override
    @Nonnull
     HashShortLongMap newMutableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2,
            @Nonnull Map<Short, Long> map3,
            @Nonnull Map<Short, Long> map4,
            @Nonnull Map<Short, Long> map5);



    @Override
    @Nonnull
     HashShortLongMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortLongConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashShortLongMap newMutableMap(
            @Nonnull short[] keys, @Nonnull long[] values);

    @Override
    @Nonnull
     HashShortLongMap newMutableMap(
            @Nonnull Short[] keys, @Nonnull Long[] values);

    @Override
    @Nonnull
     HashShortLongMap newMutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Long> values);


    @Override
    @Nonnull
     HashShortLongMap newMutableMapOf(short k1, long v1);

    @Override
    @Nonnull
     HashShortLongMap newMutableMapOf(short k1, long v1,
            short k2, long v2);

    @Override
    @Nonnull
     HashShortLongMap newMutableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3);

    @Override
    @Nonnull
     HashShortLongMap newMutableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3,
            short k4, long v4);

    @Override
    @Nonnull
     HashShortLongMap newMutableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3,
            short k4, long v4, short k5, long v5);
    @Override
    @Nonnull
     HashShortLongMap newUpdatableMap();

    @Override
    @Nonnull
     HashShortLongMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashShortLongMap newUpdatableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2, int expectedSize);

    @Override
    @Nonnull
     HashShortLongMap newUpdatableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2,
            @Nonnull Map<Short, Long> map3, int expectedSize);

    @Override
    @Nonnull
     HashShortLongMap newUpdatableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2,
            @Nonnull Map<Short, Long> map3,
            @Nonnull Map<Short, Long> map4, int expectedSize);

    @Override
    @Nonnull
     HashShortLongMap newUpdatableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2,
            @Nonnull Map<Short, Long> map3,
            @Nonnull Map<Short, Long> map4,
            @Nonnull Map<Short, Long> map5, int expectedSize);



    @Override
    @Nonnull
     HashShortLongMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortLongConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashShortLongMap newUpdatableMap(
            @Nonnull short[] keys, @Nonnull long[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortLongMap newUpdatableMap(
            @Nonnull Short[] keys, @Nonnull Long[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortLongMap newUpdatableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Long> values, int expectedSize);

    

    @Override
    @Nonnull
     HashShortLongMap newUpdatableMap(
            @Nonnull Map<Short, Long> map);

    @Override
    @Nonnull
     HashShortLongMap newUpdatableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2);

    @Override
    @Nonnull
     HashShortLongMap newUpdatableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2,
            @Nonnull Map<Short, Long> map3);

    @Override
    @Nonnull
     HashShortLongMap newUpdatableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2,
            @Nonnull Map<Short, Long> map3,
            @Nonnull Map<Short, Long> map4);

    @Override
    @Nonnull
     HashShortLongMap newUpdatableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2,
            @Nonnull Map<Short, Long> map3,
            @Nonnull Map<Short, Long> map4,
            @Nonnull Map<Short, Long> map5);



    @Override
    @Nonnull
     HashShortLongMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortLongConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashShortLongMap newUpdatableMap(
            @Nonnull short[] keys, @Nonnull long[] values);

    @Override
    @Nonnull
     HashShortLongMap newUpdatableMap(
            @Nonnull Short[] keys, @Nonnull Long[] values);

    @Override
    @Nonnull
     HashShortLongMap newUpdatableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Long> values);


    @Override
    @Nonnull
     HashShortLongMap newUpdatableMapOf(short k1, long v1);

    @Override
    @Nonnull
     HashShortLongMap newUpdatableMapOf(short k1, long v1,
            short k2, long v2);

    @Override
    @Nonnull
     HashShortLongMap newUpdatableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3);

    @Override
    @Nonnull
     HashShortLongMap newUpdatableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3,
            short k4, long v4);

    @Override
    @Nonnull
     HashShortLongMap newUpdatableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3,
            short k4, long v4, short k5, long v5);

    


    @Override
    @Nonnull
     HashShortLongMap newImmutableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2, int expectedSize);

    @Override
    @Nonnull
     HashShortLongMap newImmutableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2,
            @Nonnull Map<Short, Long> map3, int expectedSize);

    @Override
    @Nonnull
     HashShortLongMap newImmutableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2,
            @Nonnull Map<Short, Long> map3,
            @Nonnull Map<Short, Long> map4, int expectedSize);

    @Override
    @Nonnull
     HashShortLongMap newImmutableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2,
            @Nonnull Map<Short, Long> map3,
            @Nonnull Map<Short, Long> map4,
            @Nonnull Map<Short, Long> map5, int expectedSize);



    @Override
    @Nonnull
     HashShortLongMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortLongConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashShortLongMap newImmutableMap(
            @Nonnull short[] keys, @Nonnull long[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortLongMap newImmutableMap(
            @Nonnull Short[] keys, @Nonnull Long[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortLongMap newImmutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Long> values, int expectedSize);

    

    @Override
    @Nonnull
     HashShortLongMap newImmutableMap(
            @Nonnull Map<Short, Long> map);

    @Override
    @Nonnull
     HashShortLongMap newImmutableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2);

    @Override
    @Nonnull
     HashShortLongMap newImmutableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2,
            @Nonnull Map<Short, Long> map3);

    @Override
    @Nonnull
     HashShortLongMap newImmutableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2,
            @Nonnull Map<Short, Long> map3,
            @Nonnull Map<Short, Long> map4);

    @Override
    @Nonnull
     HashShortLongMap newImmutableMap(@Nonnull Map<Short, Long> map1,
            @Nonnull Map<Short, Long> map2,
            @Nonnull Map<Short, Long> map3,
            @Nonnull Map<Short, Long> map4,
            @Nonnull Map<Short, Long> map5);



    @Override
    @Nonnull
     HashShortLongMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.ShortLongConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashShortLongMap newImmutableMap(
            @Nonnull short[] keys, @Nonnull long[] values);

    @Override
    @Nonnull
     HashShortLongMap newImmutableMap(
            @Nonnull Short[] keys, @Nonnull Long[] values);

    @Override
    @Nonnull
     HashShortLongMap newImmutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Long> values);


    @Override
    @Nonnull
     HashShortLongMap newImmutableMapOf(short k1, long v1);

    @Override
    @Nonnull
     HashShortLongMap newImmutableMapOf(short k1, long v1,
            short k2, long v2);

    @Override
    @Nonnull
     HashShortLongMap newImmutableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3);

    @Override
    @Nonnull
     HashShortLongMap newImmutableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3,
            short k4, long v4);

    @Override
    @Nonnull
     HashShortLongMap newImmutableMapOf(short k1, long v1,
            short k2, long v2, short k3, long v3,
            short k4, long v4, short k5, long v5);
}

