/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalByteIntMapOps;
import net.openhft.koloboke.collect.map.ByteIntMap;
import net.openhft.koloboke.function.ByteIntConsumer;
import net.openhft.koloboke.function.ByteIntPredicate;

public final class CommonByteIntMapOps {
    public static boolean containsAllEntries(final InternalByteIntMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ByteIntMap) {
            ByteIntMap m2 = (ByteIntMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalByteIntMapOps) {
                return ((InternalByteIntMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new ByteIntPredicate(){

                public boolean test(byte a, int b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Byte)e.getKey(), (Integer)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalByteIntMapOps map, Map<? extends Byte, ? extends Integer> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ByteIntMap) {
            if (another instanceof InternalByteIntMapOps) {
                ((InternalByteIntMapOps)another).reversePutAllTo(map);
            } else {
                ((ByteIntMap)another).forEach(new ByteIntConsumer(){

                    public void accept(byte key, int value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Byte, ? extends Integer> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonByteIntMapOps() {
    }
}

