/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalCharDoubleMapOps;
import net.openhft.koloboke.collect.map.CharDoubleMap;
import net.openhft.koloboke.function.CharDoubleConsumer;
import net.openhft.koloboke.function.CharDoublePredicate;

public final class CommonCharDoubleMapOps {
    public static boolean containsAllEntries(final InternalCharDoubleMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof CharDoubleMap) {
            CharDoubleMap m2 = (CharDoubleMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalCharDoubleMapOps) {
                return ((InternalCharDoubleMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new CharDoublePredicate(){

                public boolean test(char a, double b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(((Character)e.getKey()).charValue(), (Double)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalCharDoubleMapOps map, Map<? extends Character, ? extends Double> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof CharDoubleMap) {
            if (another instanceof InternalCharDoubleMapOps) {
                ((InternalCharDoubleMapOps)another).reversePutAllTo(map);
            } else {
                ((CharDoubleMap)another).forEach(new CharDoubleConsumer(){

                    public void accept(char key, double value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Character, ? extends Double> e : another.entrySet()) {
                map.justPut(e.getKey().charValue(), e.getValue());
            }
        }
    }

    private CommonCharDoubleMapOps() {
    }
}

